/*
 * User consent function
 * Based on dialog.c from opensc-0.11.14
 * And original code from DGP's DNIe module
 */

#include "dialog.h"

#include <assuan.h>
#include <stdlib.h>
#include <opensc/log.h>
#include <opensc/opensc.h>

static const char PINENTRY[] = "pinentry";
static const char *user_consent_app = PINENTRY;
static int  user_consent_enabled=1; /* default true */

/**
 * Parse configuration file to extract user consent flags
 */
static int get_user_consent_env(sc_context_t *ctx) {
    int i;
    scconf_block **blocks, *blk;
    for (i = 0; ctx->conf_blocks[i]; i++) {
        blocks = scconf_find_blocks(ctx->conf, ctx->conf_blocks[i],"card_driver","dnie");
        if (!blocks) continue;
        blk=blocks[0];
        free(blocks);
        if (blk==NULL) continue;
        user_consent_app = scconf_get_str(blk,"user_consent_app",PINENTRY); 
        user_consent_enabled = scconf_get_bool(blk,"user_consent_enabled",1);
    }
    return SC_SUCCESS;
}

int ask_user_consent(sc_card_t *card) {
    int res;
    const char *argv[3];
    assuan_fd_t noclosefds[2];
    assuan_context_t ctx; 
    if ( (card==NULL) || (card->ctx==NULL)) return SC_ERROR_INVALID_ARGUMENTS;
    get_user_consent_env(card->ctx);
    argv[0]=user_consent_app;
    argv[1]=NULL;
    argv[2]=NULL;
    noclosefds[0]= fileno(stderr);
    noclosefds[1]= ASSUAN_INVALID_FD;
    res = assuan_pipe_connect(&ctx,user_consent_app,argv,0);
    if (res!=0) {
        sc_debug(card->ctx,"Can't connect to the User Consent module: %s\n",assuan_strerror(res));
        res=SC_ERROR_INVALID_ARGUMENTS; /* invalid or not available pinentry */
        goto exit;
    }
    res = assuan_transact(
       ctx, 
       "SETDESC Está a punto de realizar una firma electrónica con su clave de FIRMA del DNI electrónico.¿Desea permitir esta operación?", 
       NULL, NULL, NULL, NULL, NULL, NULL);
    if (res!=0) {
       sc_debug(card->ctx,"SETDESC: %s\n", assuan_strerror(res));
       res=SC_ERROR_CARD_CMD_FAILED; /* perhaps should use a better errcode */
       goto exit;
    }
    res = assuan_transact(ctx,"CONFIRM",NULL,NULL,NULL,NULL,NULL,NULL);
    if (res == ASSUAN_Canceled) {
       sc_debug(card->ctx,"Sign cancelled by user");
       res= SC_ERROR_NOT_ALLOWED;
       goto exit;
    }
    if (res) {
       sc_debug(card->ctx,"SETERROR: %s\n",assuan_strerror(res));
       res=SC_ERROR_SECURITY_STATUS_NOT_SATISFIED;
     } else {
       res=SC_SUCCESS;
     }
exit:
    assuan_disconnect(ctx);
    SC_FUNC_RETURN(card->ctx,1,res);
}
