// OpenSSL replacement

#ifndef _OPENSC_DNIE_CRYPT_H
#define _OPENSC_DNIE_CRYPT_H

enum {
	DES_DECRYPT = 0,
	DES_ENCRYPT = 1,
	RSA_NO_PADDING = 0,
	SHA_DIGEST_LENGTH = 20
};

typedef struct gcry_mpi BIGNUM;
typedef unsigned char DES_cblock[8];
typedef DES_cblock DES_key_schedule;
typedef struct RSA {
	// public modulus
	BIGNUM *n;
	// public exponent
	BIGNUM *e;
	// secret exponent
	BIGNUM *d;
} RSA;
typedef const unsigned char const_DES_cblock[8];

BIGNUM *BN_bin2bn(const unsigned char *s, int len, BIGNUM *ret);
int BN_bn2bin(const BIGNUM *a, unsigned char *to);
int BN_cmp(BIGNUM *a, BIGNUM *b);
void BN_free(BIGNUM *a);
BIGNUM *BN_new(void);
int BN_num_bytes(const BIGNUM *a);
int BN_sub(BIGNUM *r, const BIGNUM *a, const BIGNUM *b);
_Bool DES_ecb_encrypt(const_DES_cblock *input, DES_cblock *output,
	DES_key_schedule *ks, int enc);
_Bool DES_ecb2_encrypt(const_DES_cblock *input, DES_cblock *output,
	DES_key_schedule *ks1, DES_key_schedule *ks2, int enc);
_Bool DES_ede3_cbc_encrypt(const unsigned char *input, unsigned char *output,
	long length, DES_key_schedule *ks1, DES_key_schedule *ks2,
	DES_key_schedule *ks3, DES_cblock *ivec, int enc);
void DES_set_key_unchecked(const_DES_cblock *key, DES_key_schedule *schedule);
int RAND_bytes(unsigned char *buf, int num);
void RSA_free(RSA *rsa);
RSA *RSA_new(void);
int RSA_private_decrypt(int flen, unsigned char *from, unsigned char *to,
	RSA *rsa, int padding);
int RSA_public_encrypt(int flen, unsigned char *from, unsigned char *to,
	RSA *rsa, int padding);
unsigned char *SHA1(const unsigned char *d, unsigned long n, unsigned char *md);

#endif
