// Text of a variable int

#include "stdproc/text_int.h"

#include "core.h"
#include "graphic.h"
#include "stdproc/text.h"

typedef struct font font;

typedef struct {
	const int *number;
	int last_value;
	char buffer[sizeof("-2147483648")];
} text_int_private;

static size_t private_offset;

static text_int_private *get_private(text_int *ti) {
	void *p = ti;
	return p + private_offset;
}

static void run(process *p) {
	text_int *ti_p = (text_int *) p;
	text_int_private *ti = get_private(ti_p);
	if (ti->last_value != *ti->number) {
		graphic_destroy(p->graph);
		ti->last_value = *ti->number;
		sprintf(ti->buffer, "%d", ti->last_value);
		set_graph_text(TEXT_INT_CAST(ti_p, text), ti->buffer);
	}
	frame_done(p);
}

text_int *text_int_create(process *father, const font *fnt, int x, int y,
	h_align halign, v_align valign, const int *number) {
	text_int *ti_p = alloc(text_int_sizeof());
	text *t = TEXT_INT_CAST(ti_p, text);
	text_init(t, father, fnt, x, y, halign, valign, NULL);
	process *p = TEXT_INT_CAST(ti_p, process);
	p->run = run;
	text_int_private *ti = get_private(ti_p);
	ti->number = number;
	ti->last_value = *number;
	sprintf(ti->buffer, "%d", ti->last_value);
	set_graph_text(t, ti->buffer);
	p->run(p);
	return ti_p;
}

size_t text_int_sizeof(void) {
	static size_t size;
	if (!size) {
		private_offset = text_sizeof();
		size = private_offset + sizeof(text_int_private);
	}
	return size;
}
