// Mouse cursor

#include "stdproc/mouse_cursor.h"

#include "core.h"

static void run(process *p);

mouse_cursor *mouse_cursor_create(process *father) {
	mouse_cursor *m = alloc(mouse_cursor_sizeof());
	process *p = MOUSE_CURSOR_CAST(m, process);
	process_init(p, father);
	p->z = -512;
	p->run = run;
	p->run(p);
	return m;
}

size_t mouse_cursor_sizeof(void) {
	return process_sizeof();
}

static void run(process *p) {
	p->x = mouse.x;
	p->y = mouse.y;
	frame_done(p);
}
