// List of elements

#include "list.h"

#include "core.h"

static void remove_entries(list *l);

void erase_entry(list *l, list_entry *entry) {
	list_entry *prev = entry->prev;
	list_entry *next = entry->next;
	if (prev)
		prev->next = next;
	if (next)
		next->prev = prev;
	if (l->first == entry)
		l->first = next;
	if (l->last == entry)
		l->last = prev;
	l->size--;
	free(entry);
}

void list_clear(list *l) {
	remove_entries(l);
	memset(l, 0, sizeof(list));
}

list_entry *list_create_entry(list *l) {
	list_entry *entry = alloc(sizeof(list_entry));
	list_entry *last = l->last;
	entry->prev = last;
	entry->next = NULL;
	if (last)
		last->next = entry;
	if (!l->first)
		l->first = entry;
	l->last = entry;
	l->size++;
	return entry;
}

void list_destroy(list *l) {
	remove_entries(l);
	free(l);
}

static void remove_entries(list *l) {
	list_entry *entry = l->first;
	while (entry) {
		list_entry *next = entry->next;
		free(entry);
		entry = next;
	}
}
