// Set of integers

#include "int_set.h"

#include <bestiola/compare.h>

#include "core.h"

struct int_set {
	int *set;
	unsigned length;
	unsigned size;
};

static int compare_entries(const void *p1, const void *p2) {
	const int *i1 = p1;
	const int *i2 = p2;
	return intcmp(*i1, *i2);
}

void clear(int_set *is) {
	if (is->set) {
		free(is->set);
		memset(is, 0, sizeof(int_set));
	}
}

int_set *int_set_create(void) {
	return ocell_calloc(1, sizeof(int_set));
}

bool int_set_find(int_set *is, int value) {
	return bsearch(&value, is->set, is->length, sizeof(int),
		compare_entries);
}

void int_set_push_back(int_set *is, int value) {
	if (!is->size) {
		int *set = alloc(sizeof(int));
		*set = value;
		is->set = set;
		is->length = 1;
		is->size = 1;
		return;
	}
	if (is->length == is->size) {
		is->size <<= 1;
		if (!is->size) {
//			warn limit reached
			fatal_error();
		}
		is->set = ocell_realloc(is->set, is->size * sizeof(int));
	}
	is->set[is->length++] = value;
}

void sort(int_set *is) {
	if (is->length < is->size)
		is->set = ocell_realloc(is->set, is->length * sizeof(int));
	qsort(is->set, is->length, sizeof(int), compare_entries);
}
