// Graphic set

#include "graphic_set.h"

#include <dirent.h>
#include <err.h>
#include <fnmatch.h>

#include "core.h"
#include "graphic.h"
#include "pointer_map.h"

graphic *at(const graphic_set *set, unsigned code) {
	return get_entry((const pointer_map *) set, code);
}

graphic_set *graphic_set_create(const char *dir_name) {
	pointer_map *map = pointer_map_create();
	char *full_dir_name = full_name(dir_name);
	DIR *dir = opendir(full_dir_name);
	if (!dir) {
		warnx("Missing graphic set %s", full_dir_name);
		fatal_error();
	}
	free(full_dir_name);

	const struct dirent *entry;
	for (entry = readdir(dir); entry; entry = readdir(dir)) {
		if (!fnmatch("*.png", entry->d_name, 0)) {
			char *endptr;
			unsigned num = strtol(entry->d_name, &endptr, 10);
			if (endptr != entry->d_name) {
				if (get_entry(map, num))
					warnx("graphic_set_create error");
				char *file_path = ocell_asprintf("%s/%s",
					dir_name, entry->d_name);
				set_entry(map, num,
					graphic_from_file(file_path));
				free(file_path);
			}
		}
	}
	closedir(dir);
	return (graphic_set *) map;
}

void graphic_set_destroy(graphic_set *set) {
	pointer_map_destroy((pointer_map *) set,
		(void (*)(void *)) graphic_destroy);
}
