// Font

#include "font.h"

#include <dirent.h>
#include <err.h>
#include <fnmatch.h>

#include "core.h"
#include "image.h"
#include "pointer_map.h"

font *font_create(const char *dir_name) {
	pointer_map *map = pointer_map_create();
	char *full_dir_name = full_name(dir_name);
	DIR *dir = opendir(full_dir_name);
	if (!dir) {
		warnx("Missing font %s", full_dir_name);
		fatal_error();
	}
	free(full_dir_name);

	const struct dirent *entry;
	for (entry = readdir(dir); entry; entry = readdir(dir)) {
		if (!fnmatch("*.png", entry->d_name, 0)) {
			char *endptr;
			unsigned num = strtol(entry->d_name, &endptr, 16);
			if (endptr != entry->d_name) {
				if (get_entry(map, num))
					warnx("font_create error");
				char *file_path = ocell_asprintf("%s/%s",
					dir_name, entry->d_name);
				set_entry(map, num, load_image(file_path));
				free(file_path);
			}
		}
	}
	closedir(dir);
	return (font *) map;
}

void font_destroy(font *f) {
	pointer_map_destroy((pointer_map *) f,
		(void (*)(void *)) SDL_FreeSurface);
}

SDL_Surface *font_glyph(const font *f, unsigned code) {
	return get_entry((const pointer_map *) f, code);
}
