// Atomic items

#include "atomic.h"

#include <pthread.h>

#include "core.h"

struct atomic_pointer {
	pthread_mutex_t mutex;
	void *value;
};

atomic_pointer *atomic_create(void) {
	atomic_pointer *ap = alloc(sizeof(atomic_pointer));
	pthread_mutex_init(&ap->mutex, NULL);
	ap->value = NULL;
	return ap;
}

void atomic_destroy(atomic_pointer *ap) {
	if (pthread_mutex_destroy(&ap->mutex))
		fatal_error();
	free(ap);
}

void *get(atomic_pointer *ap) {
	void *copy;
	copy = lock(ap);
	unlock(ap);
	return copy;
}

void *lock(atomic_pointer *ap) {
	pthread_mutex_lock(&ap->mutex);
	return ap->value;
}

void set(atomic_pointer *ap, void *new_value) {
	lock(ap);
	ap->value = new_value;
	unlock(ap);
}

void unlock(atomic_pointer *ap) {
	pthread_mutex_unlock(&ap->mutex);
}
