// Text

#ifndef OCELL_STDPROC_TEXT_H
#define OCELL_STDPROC_TEXT_H

#include <stddef.h>
#include <ocell/stdproc/cast/text.h>

struct font;
struct process;

typedef enum h_align {
	LEFT,
	CENTER,
	RIGHT
} h_align;

typedef enum v_align {
	TOP,
	MIDDLE,
	BOTTOM
} v_align;

typedef struct text text;

void set_graph_text(text *t, const char *value);
text *text_create(struct process *father, const struct font *fnt, int x, int y,
	h_align halign, v_align valign, const char *value);
void text_init(text *t, struct process *father, const struct font *fnt, int x,
	int y, h_align halign, v_align valign, const char *value);
size_t text_sizeof(void);

#endif
