// Graphic

#ifndef OCELL_GRAPHIC_H
#define OCELL_GRAPHIC_H

struct SDL_Color;

typedef struct graphic graphic;

void convert_palette(graphic *g, const struct SDL_Color *colors);
const struct control_point *get_center(const graphic *g);
const struct control_point *get_control_point(const graphic *g, unsigned n);
const struct SDL_Surface *get_surface(const graphic *g);
void graphic_destroy(graphic *g);
graphic *graphic_from_file(const char *file_name);
graphic *graphic_from_surface(struct SDL_Surface *surface);
void set_center(graphic *g, const struct control_point *new_center);

#endif
