// fade_channel_out.c - Fade channel out

#include "stdproc/fade_channel_out.h"

#include "atomic.h"
#include "core.h"

typedef struct {
	struct atomic_pointer *channel;
	unsigned millis;
	unsigned start;
	int volume;
} fade_channel_out_private;

static size_t private_offset;

static fade_channel_out_private *get_private(fade_channel_out *f);
static void run(process *p);

fade_channel_out *fade_channel_out_create(process *father,
	atomic_pointer *channel, unsigned millis) {
	fade_channel_out *f_p = alloc(fade_channel_out_sizeof());
	process *p = FADE_CHANNEL_OUT_CAST(f_p, process);
	process_init(p, father);
	p->run = run;
	fade_channel_out_private *f = get_private(f_p);
	f->channel = channel;
	f->millis = millis;
	f->volume = 0x80000000;
	p->run(p);
	return f_p;
}

size_t fade_channel_out_sizeof(void) {
	static size_t size;
	if (!size) {
		private_offset = process_sizeof();
		size = private_offset + sizeof(fade_channel_out_private);
	}
	return size;
}

static fade_channel_out_private *get_private(fade_channel_out *f) {
	void *p = f;
	return p + private_offset;
}

static void run(process *p) {
	fade_channel_out *f_p = (fade_channel_out *) p;
	fade_channel_out_private *f = get_private(f_p);
	if (p->state)
		goto *p->state;

	f->start = SDL_GetTicks();

	for (;;) {
		unsigned elapsed = SDL_GetTicks() - f->start;
		if (elapsed >= f->millis)
			break;

		sample_channel *raw_channel = lock(f->channel);
		if (raw_channel) {
			if (f->volume == (int) 0x80000000)
				f->volume = sample_channel_volume(raw_channel);
			sample_channel_set_volume(raw_channel,
				f->volume - f->volume * elapsed / f->millis);
		}
		unlock(f->channel);
		if (!raw_channel)
			break;

		FRAME(p);
	}
	remove_channel(f->channel);
	send_signal(p, S_KILL);
}
