// Background

#include "stdproc/background.h"

#include "core.h"

static process *bg_process;

static void on_kill(process *p);

background *background_create(process *father, struct graphic *graph) {
	background *b = alloc(background_sizeof());
	process *p = BACKGROUND_CAST(b, process);
	process_init(p, father);
	p->x = get_screen()->w / 2;
	p->y = get_screen()->h / 2;
	p->graph = graph;
	p->on_kill = on_kill;
	if (bg_process)
		send_signal(bg_process, S_KILL);
	bg_process = p;
	p->run(p);
	return b;
}

void background_free(void) {
	if (bg_process)
		send_signal(bg_process, S_KILL);
}

size_t background_sizeof(void) {
	return process_sizeof();
}

static void on_kill(__attribute__((unused)) process *p) {
	bg_process = NULL;
}
