// Image auxiliary functions

#include "image.h"

#include <err.h>
#include <SDL/SDL_image.h>

#include "core.h"

SDL_Surface *load_image(const char *file) {
	SDL_Surface *surface;
	if (file[0] == '/')
		surface = IMG_Load(file);
	else {
		char *file_name = full_name(file);
		surface = IMG_Load(file_name);
		free(file_name);
	}
	if (!surface) {
		warnx("IMG_Load: %s", IMG_GetError());
		fatal_error();
	}
	return surface;
}
