// list.h - List of elements

#ifndef _OCELL_LIST_H
#define _OCELL_LIST_H

typedef struct list_entry list_entry;

typedef struct list {
	list_entry *first;
	list_entry *last;
	unsigned size;
} list;

struct list_entry {
	union {
		unsigned u;
		void *p;
	};
	list_entry *prev;
	list_entry *next;
};

void erase_entry(list *l, list_entry *entry);
void list_clear(list *l);
list_entry *list_create_entry(list *l);
void list_destroy(list *l);

#endif
