// Pseudo random byte generator

#include "random.h"

#include <unistd.h>
#include <sys/syscall.h>

#include "core.h"

void random_buffer(char *buffer, size_t length) {
	while (length) {
		int result = syscall(SYS_getrandom, buffer, length, 0);
		if (result < 0)
			moix_error();
		buffer += result;
		length -= result;
	}
}
