// Integer operations

#include "int_ops.h"

bool moix_strtoi(const char *s, int *result) {
	unsigned value;
	if (moix_strtou(s, &value))
		return true;
	if (value & 0x80000000)
		return true;
	*result = value;
	return false;
}

bool moix_strtou(const char *s, unsigned *result) {
	if (!*s)
		return true;
	unsigned value = 0;
	for (; *s; s++) {
		unsigned digit = *s - '0';
		if (digit > 9)
			return true;
		static unsigned MAX_UINT = 0xffffffff;
		if (value > MAX_UINT / 10)
			return true;
		value *= 10;
		if (value > MAX_UINT - digit)
			return true;
		value += digit;
	}
	*result = value;
	return false;
}
