// Generate random hexchar strings

#include "random_hexchar.h"

#include "core.h"
#include "random.h"
#include "xstring.h"

moix_mem *moix_random_hexchar(size_t length) {
	size_t bytes = (length + 1) / 2;
	char *random_bytes_str = moix_alloc(bytes);
	moix_mem *random_bytes = moix_alloc_memory(random_bytes_str);
	random_buffer(random_bytes_str, bytes);
	char *hexchar_str = moix_alloc(length + 1);
	moix_mem *hexchar_string = moix_alloc_memory(hexchar_str);
	size_t i;
	for (i = 0; i < bytes; i++) {
		hexchar_str[2 * i] = hexchar(random_bytes_str[i] >> 4);
		hexchar_str[2 * i + 1] = hexchar(random_bytes_str[i]);
	}
	hexchar_str[length] = '\0';
	moix_free(random_bytes);
	return hexchar_string;
}
