// Request parameter type casting

#include "parameter.h"

#include <bestiola/utf8.h>

#include "core.h"
#include "http_codes.h"
#include "int_ops.h"

int moix_parameter_int(const char *name) {
	int value;
	if (moix_strtoi(moix_parameter_nonnull(name), &value))
		moix_send_error(HTTP_BAD_REQUEST);
	return value;
}

const char *moix_parameter_nonnull(const char *name) {
	const char *value = moix_get_parameter(name);
	if (!value)
		moix_send_error(HTTP_BAD_REQUEST);
	return value;
}

const char *moix_parameter_utf8(const char *name) {
	const char *value = moix_parameter_nonnull(name);
	if (!utf8_valid(value))
		moix_send_error(HTTP_BAD_REQUEST);
	return value;
}

int moix_parameter_value_int(const char *s) {
	if (!s)
		moix_send_error(HTTP_BAD_REQUEST);
	int value;
	if (moix_strtoi(s, &value))
		moix_send_error(HTTP_BAD_REQUEST);
	return value;
}
