// log_message.c - Print messages to stderr

#include "log_message.h"

#include <err.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

void log_message(const char *message) {
	time_t stamp = time(NULL);
	struct tm now;
	if (!gmtime_r(&stamp, &now))
		memset(&now, 0, sizeof(now));
	warnx("%04d/%02d/%02d %02d:%02d:%02d %s", 1900 + now.tm_year,
		now.tm_mon, now.tm_mday, now.tm_hour, now.tm_min, now.tm_sec,
		message);
	fflush(stderr);
}
