// Integer operations

#include "int_ops.h"

_Bool moix_strtoi(const char *s, int *result) {
	unsigned value;
	if (moix_strtou(s, &value))
		return 1;
	if (value & 0x80000000)
		return 1;
	*result = value;
	return 0;
}

_Bool moix_strtou(const char *s, unsigned *result) {
	if (!*s)
		return 1;
	unsigned value = 0;
	for (; *s; s++) {
		unsigned digit = *s - '0';
		if (digit > 9)
			return 1;
		static unsigned MAX_UINT = 0xffffffff;
		if (value > MAX_UINT / 10)
			return 1;
		value *= 10;
		if (value > MAX_UINT - digit)
			return 1;
		value += digit;
	}
	*result = value;
	return 0;
}
