// xml.h - XML functions

#ifndef _MOIXTOMEU_XML_H
#define _MOIXTOMEU_XML_H

struct moix_resource;

typedef struct _xmlNode moix_node;
typedef struct moix_xml_document moix_xml_document;

void moix_free_resource(struct moix_resource *resource);
moix_node *moix_xml_get_root(moix_xml_document *document);
moix_node *moix_xml_new_child(moix_node *parent, const char *name);
moix_xml_document *moix_xml_new_document(void);
moix_node *moix_xml_new_int_child(moix_node *parent, const char *name,
	int content);
moix_node *moix_xml_new_root(moix_xml_document *document, const char *name);
moix_node *moix_xml_new_text_child(moix_node *parent, const char *name,
	const char *content);
void moix_xml_set_attr(moix_node *node, const char *name, const char *value);
void moix_xml_set_int_attr(moix_node *node, const char *name, int value);
void moix_xml_set_text(moix_node *node, const char *content);
struct moix_mem *moix_xsl_transform(const char *xslt_file,
	moix_xml_document *document);

static inline void moix_xml_free(moix_xml_document *document) {
	moix_free_resource((struct moix_resource *) document);
}

#endif
