// db_connection.h - Handle database connections

#ifndef _DB_CONNECTION_H
#define _DB_CONNECTION_H

struct moix_resource;

typedef struct moix_db_result moix_db_result;

int moix_db_exec(const char *query);
int moix_db_exec_fmt(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
moix_db_result *moix_db_exec_nocheck(const char *query);
moix_db_result *moix_db_exec_nocheck_fmt(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
_Bool moix_db_exists(const char *query);
_Bool moix_db_exists_fmt(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
const char *moix_db_get(const moix_db_result *res, int ntuple,
	const char *cname);
_Bool moix_db_get_bool(const moix_db_result *res, int ntuple,
	const char *cname);
int moix_db_get_int(const moix_db_result *res, int ntuple, const char *cname);
int moix_db_ntuples(const moix_db_result *res);
moix_db_result *moix_db_query(const char *query);
moix_db_result *moix_db_query_fmt(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
moix_db_result *moix_db_query_nocheck(const char *query);
moix_db_result *moix_db_query_nocheck_fmt(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
void moix_free_resource(struct moix_resource *resource);

static inline void moix_db_free(moix_db_result *res) {
	moix_free_resource((struct moix_resource *) res);
}

static inline const struct pg_result *moix_pg_result(
	const moix_db_result *res) {
	return *((const struct pg_result * const *) res);
}

#endif
