// Support functions for moixervlets

#ifndef _MOIXTOMEU_CORE_H
#define _MOIXTOMEU_CORE_H

#include <setjmp.h>
#include <stdio.h>

struct moix_db_result;

typedef struct moix_mem moix_mem;
typedef struct moix_parameter moix_parameter;
typedef struct moix_resource moix_resource;

void *moix_alloc(size_t size);
moix_mem *moix_alloc_memory(void *mem);
moix_resource *moix_alloc_resource(void *value, void (*cleanup)(void *));
void moix_append_string(moix_mem *buffer, const char *s, size_t *length);
moix_mem *moix_asprintf(const char *fmt, ...)
	__attribute__((format(printf, 1, 2)));
int moix_atoi(const char *nptr);
_Bool moix_authenticated_session(void);
void *moix_calloc(size_t nmemb, size_t size);
struct gnutls_x509_crt_int *moix_client_cert(void);
const char *moix_context_path(void);
const char *moix_context_uri(void);
_Bool moix_create_request(FILE *stream, const char *uri);
int moix_db_cmd_tuples(const struct moix_db_result *result);
void moix_decline(void) __attribute__((noreturn));
_Bool moix_do_get(void);
_Bool moix_do_post(void);
void moix_error(void) __attribute__((noreturn));
void moix_free_error(void);
char moix_free_request(void);
void moix_free_resource(moix_resource *resource);
int moix_get_content_length(void);
struct pg_conn *moix_get_db_connection(void);
const moix_parameter *moix_get_first_parameter(const char *name);
moix_mem *moix_get_header(const char *name);
const moix_parameter *moix_get_next_parameter(const moix_parameter *param);
const char *moix_get_parameter(const char *name);
const char *moix_get_parameter_value(const moix_parameter *param);
unsigned moix_get_parameters_length(const moix_parameter *param);
moix_mem *moix_get_real_path(const char *uri);
const moix_mem *moix_get_request_attr(const void *key);
moix_mem *moix_get_session_attr(const char *key) __attribute__((nonnull));
int moix_get_session_key(_Bool create);
const char *moix_host(void);
_Bool moix_init_failed(void);
void moix_invalidate_session(void);
_Bool moix_is_secure(void);
const char *moix_method(void);
const char *moix_query_string(void);
void *moix_realloc(moix_mem *mem, size_t size);
void moix_redirect(const char *url) __attribute__((noreturn));
const unsigned char *moix_remote_address(void);
void moix_send_content(const char *content);
void moix_send_error(short code) __attribute__((noreturn));
void moix_set_cache_control(const char *directives);
_Bool moix_set_conn_info(const char *conninfo);
void moix_set_content_language(const char *language);
void moix_set_content_type(const char *type);
void moix_set_init_failed(void);
void moix_set_request_attr(const void *key, moix_mem *value);
void moix_set_session_attr(const char *key, const char *value)
	__attribute__((nonnull(1)));
void moix_setjmp_env(sigjmp_buf env);
moix_mem *moix_slice(const char *start, const char *end);
moix_mem *moix_strdup(const char *s);
const char *moix_uri(void) __attribute__((pure));
_Bool moix_uri_starts_path(const char *uri, const char *path)
	__attribute__((pure));
const char *moix_user(_Bool authentic);
int moix_user_id(void);
static inline const void *moix_void_ptr(const moix_mem *mem);

static inline void moix_free(moix_mem *mem) {
	moix_free_resource((moix_resource *) mem);
}

static inline const char *moix_string(const moix_mem *mem) {
	return moix_void_ptr(mem);
}

static inline const void *moix_void_ptr(const moix_mem *mem) {
	return *((const void * const *) mem);
}

#endif
