// Moixervlet protocol support functions

#define _GNU_SOURCE

#include "moixproto.h"

#include <stdlib.h>
#include <string.h>

bool moix_get_short(FILE *stream, short *s) {
	int c1 = getc(stream);
	if (c1 == EOF)
		return false;
	int c0 = getc(stream);
	if (c0 == EOF)
		return false;
	*s = (c1 << 8) | c0;
	return true;
}

bool moix_get_string(FILE *stream, char **s) {
	int length = getc(stream);
	switch (length) {
	case EOF:
		return false;
	case 254: ;
		short s_length;
		if (!moix_get_short(stream, &s_length))
			return false;
		length = (unsigned short) s_length;
		break;
	case 255:
		*s = NULL;
		return true;
	}
	char *buffer = malloc(length + 1);
	if (!buffer)
		return false;
	buffer[length] = '\0';
	if (length && !fread(buffer, length, 1, stream)) {
		free(buffer);
		return false;
	}
	*s = buffer;
	return true;
}

bool moix_put_short(FILE *stream, short s) {
	return putc((s >> 8) & 0x00ff, stream) != EOF
		&& putc(s & 0x00ff, stream) != EOF;
}

bool moix_put_string(FILE *stream, const char *s) {
	if (!s)
		return putc(255, stream) != EOF;
	size_t length = strlen(s);
	if (length < 254) {
		if (putc(length, stream) == EOF)
			return false;
	}
	else if (length < 1 << 16) {
		if (putc(254, stream) == EOF)
			return false;
		if (!moix_put_short(stream, length))
			return false;
	}
	else
		return false;
	return fputs(s, stream) != EOF;
}
