// Moixervlet protocol support functions

#define _GNU_SOURCE

#include "moixproto.h"

#include <stdlib.h>
#include <string.h>

_Bool moix_get_short(FILE *stream, short *s) {
	int c1 = getc(stream);
	if (c1 == EOF)
		return 0;
	int c0 = getc(stream);
	if (c0 == EOF)
		return 0;
	*s = (c1 << 8) | c0;
	return 1;
}

_Bool moix_get_string(FILE *stream, char **s) {
	int length = getc(stream);
	switch (length) {
	case EOF:
		return 0;
	case 254: ;
		short s_length;
		if (!moix_get_short(stream, &s_length))
			return 0;
		length = (unsigned short) s_length;
		break;
	case 255:
		*s = NULL;
		return 1;
	}
	char *buffer = malloc(length + 1);
	if (!buffer)
		return 0;
	buffer[length] = '\0';
	if (length && !fread(buffer, length, 1, stream)) {
		free(buffer);
		return 0;
	}
	*s = buffer;
	return 1;
}

_Bool moix_put_short(FILE *stream, short s) {
	return putc((s >> 8) & 0x00ff, stream) != EOF
		&& putc(s & 0x00ff, stream) != EOF;
}

_Bool moix_put_string(FILE *stream, const char *s) {
	if (!s)
		return putc(255, stream) != EOF;
	size_t length = strlen(s);
	if (length < 254) {
		if (putc(length, stream) == EOF)
			return 0;
	}
	else if (length < 1 << 16) {
		if (putc(254, stream) == EOF)
			return 0;
		if (!moix_put_short(stream, length))
			return 0;
	}
	else
		return 0;
	return fputs(s, stream) != EOF;
}
