// Moixervlet protocol specification

#ifndef _MOIXERVLET_PROTOCOL_H
#define _MOIXERVLET_PROTOCOL_H

#include <stdio.h>

enum {
	MOIX_CACHE_CONTROL,
	MOIX_CERTIFICATE,
	MOIX_CONTENT,
	MOIX_CONTENT_LANGUAGE,
	MOIX_CONTENT_TYPE,
	MOIX_CONTEXT_PATH,
	MOIX_COOKIE,
	MOIX_DECLINED,
	MOIX_DOCUMENT_ROOT,
	MOIX_END,
	MOIX_ERROR,
	MOIX_HEADER,
	MOIX_HOST,
	MOIX_METHOD,
	MOIX_QUERY_STRING,
	MOIX_REMOTE_ADDRESS,
	MOIX_REQUEST_BODY,
	MOIX_SECURE,
	MOIX_SEND_ERROR,
	MOIX_USER
};

_Bool moix_get_short(FILE *stream, short *s);
_Bool moix_get_string(FILE *stream, char **s);
_Bool moix_put_short(FILE *stream, short s);
_Bool moix_put_string(FILE *stream, const char *s);

#endif
