// Emulation stub base

#include "stub.h"

#include <err.h>
#include <stdlib.h>
#include <unistd.h>

#include "syscall.h"

static void default_error(int op);

void (*emu_stub_error)(int op) = default_error;

static void default_error(int op) {
	switch (op) {
	case EMU_STUB_CALL:
		warnx("Emulation stub error.");
		break;
	case EMU_STUB_LOAD:
		errx(EXIT_FAILURE, "Could not initialize emulation stub.");
	case EMU_STUB_UNLOAD:
		errx(EXIT_FAILURE, "Could not unload emulation stub.");
	}
}

int emu_stub_call(uint32_t handle_syscall, uint32_t args[]) {
	int ret = syscall(SYS_emu_stub, EMU_STUB_CALL, handle_syscall, args);
	if (ret == -1)
		emu_stub_error(EMU_STUB_CALL);
	return ret;
}

int emu_stub_load(const char *name, uint32_t *library_handle,
	uint32_t *handle_syscall) {
	int ret = syscall(SYS_emu_stub, EMU_STUB_LOAD, name, library_handle,
		handle_syscall);
	if (ret == -1)
		emu_stub_error(EMU_STUB_LOAD);
	return ret;
}

void emu_stub_return(void) {
	syscall(SYS_emu_stub, EMU_STUB_RETURN);
}

int emu_stub_unload(uint32_t library_handle) {
	int ret = syscall(SYS_emu_stub, EMU_STUB_UNLOAD, library_handle);
	if (ret == -1)
		emu_stub_error(EMU_STUB_UNLOAD);
	return ret;
}
