// Available methods for emulation stub handlers

#define _GNU_SOURCE

#include "handler-api.h"

#include <dlfcn.h>
#include <elf.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static const char *arch;
static const char *libdir = LIBDIR;
static char *runtime_libdir;

void (*emu_copy_internal)(emu_cpu_env *dest, emu_cpu_env *src);
emu_cpu_env *(*emu_cpu_clone)(emu_cpu_env *env);
void (*emu_cpu_free)(emu_cpu_env *env);
void (*emu_cpu_run)(emu_cpu_env *env);
target_ucontext_t *(*emu_create_ucontext)(emu_cpu_env *env);
void *(*emu_get_thread_data)(void);
void (*emu_print_debug)(void);
void (*emu_set_return_value)(emu_cpu_env *env, unsigned value);
void (*emu_set_stack)(emu_cpu_env *env, const stack_t *stack,
	stack_t *oldstack);
void (*emu_set_thread_data)(const void *thread_data);
void *(*emu_stackaddr)(emu_cpu_env *cpu_env);
size_t (*emu_stacksize)(void);

__attribute__((constructor)) static void unit_constructor(void) {
	Dl_info dlinfo;
	if (!dladdr(emu_handler_path, &dlinfo))
		return;
	char *slash = strrchr(dlinfo.dli_fname, '/');
	if (!slash)
		return;
	size_t length = slash - dlinfo.dli_fname;
	char *dir = malloc(length + 1);
	if (!dir)
		return;
	char *next = mempcpy(dir, dlinfo.dli_fname, length);
	*next = '\0';
	libdir = runtime_libdir = dir;
}

__attribute__((destructor)) static void unit_destructor(void) {
	free(runtime_libdir);
}

char *emu_handler_path(const char *name) {
	char *path;
	int ret = asprintf(&path, "%s/emu-handler/%s/%s", libdir, arch, name);
	if (ret == -1)
		return NULL;
	return path;
}

void emu_handler_set_machine(int machine) {
	switch (machine) {
	case EM_386:
		arch = "i386";
		break;
	case EM_PPC:
		arch = "powerpc";
	}
}
