// Emulation stub handler functions

#ifndef _EMU_STUB_HANDLER_H
#define _EMU_STUB_HANDLER_H

#include <endian.h>
#include <stdint.h>
#include <emu-stub/typeswap.h>

#include "target-config.h"

struct emu_cpu_env;

#if __BYTE_ORDER != TARGET_BYTE_ORDER

#define BSWAP_NEEDED

#include <byteswap.h>

#define tswap16(v) ((typeof(v)) bswap_16((uint16_t) v))
#define tswap32(v) ((typeof(v)) bswap_32((uint32_t) v))

#else

#define tswap16(v) v
#define tswap32(v) v

#endif

#define assign_result32(a, b) \
{ \
	typeof(b) *result = tswap32((void *) a); \
	*result = tswap32(b); \
}

int handle_syscall(uint32_t args[], struct emu_cpu_env *env);

static inline void memswap16(void *dest, const void *src, unsigned times) {
	const uint16_t *sp = src;
	uint16_t *dp = dest;
	while (times--)
		*dp++ = tswap16(*sp++);
}

static inline void memswap32(void *dest, const void *src, unsigned times) {
	const uint32_t *sp = src;
	uint32_t *dp = dest;
	while (times--)
		*dp++ = tswap32(*sp++);
}

#define size16of(x) (sizeof(x) / sizeof(uint16_t))
#define size32of(x) (sizeof(x) / sizeof(uint32_t))

static inline double swapd(double d) {
	int_s64 src = { .d = d };
#ifdef BSWAP_NEEDED
	static const int I0 = 1;
	static const int I1 = 0;
#else
	static const int I0 = 0;
	static const int I1 = 1;
#endif
	int_s64 dest = { .i = { tswap32(src.i[I0]), tswap32(src.i[I1]) } };
	return dest.d;
}

#endif
