// Methods related to emulation stub handlers

#ifndef _EMU_STUB_HANDLER_API_H
#define _EMU_STUB_HANDLER_API_H

#include <stddef.h>

typedef struct emu_cpu_env emu_cpu_env;
typedef struct sigaltstack stack_t;
typedef struct target_ucontext_t target_ucontext_t;

typedef int handle_syscall_t(void *args, emu_cpu_env *env);

extern void (*emu_copy_internal)(emu_cpu_env *dest, emu_cpu_env *src);
extern emu_cpu_env *(*emu_cpu_clone)(emu_cpu_env *env);
extern void (*emu_cpu_free)(emu_cpu_env *env);
extern void (*emu_cpu_run)(emu_cpu_env *env);
extern target_ucontext_t *(*emu_create_ucontext)(emu_cpu_env *env);
extern void *(*emu_get_thread_data)(void);
extern void (*emu_print_debug)(void);
extern void (*emu_set_return_value)(emu_cpu_env *env, unsigned value);
extern void (*emu_set_stack)(emu_cpu_env *env, const stack_t *stack,
	stack_t *oldstack);
extern void (*emu_set_thread_data)(const void *thread_data);
extern void *(*emu_stackaddr)(emu_cpu_env *cpu_env);
extern size_t (*emu_stacksize)(void);

char *emu_handler_path(const char *name);
void emu_handler_set_machine(int machine);

#endif
