// Emulation stub base

#ifndef _EMU_STUB_BASE_H
#define _EMU_STUB_BASE_H

#include <stdint.h>
#include <emu-stub/syscall.h>

static uint32_t library_handle;
static uint32_t handle_syscall;

#ifndef CUSTOM_EMU_STUB_CONSTRUCTOR
__attribute__((constructor))
#endif
static void emu_stub_constructor(void) {
	emu_stub_load(HANDLER_NAME, &library_handle, &handle_syscall);
}

#ifndef NO_EMU_STUB_DESTRUCTOR
__attribute__((destructor)) static void emu_stub_destructor(void) {
	emu_stub_unload(library_handle);
}
#endif

static inline int callback_call(uint32_t args[]) {
	return syscall(SYS_emu_stub, EMU_STUB_CALL, handle_syscall, args);
}

static inline void normal_call(uint32_t args[]) {
	emu_stub_call(handle_syscall, args);
}

#endif
