#define _LARGEFILE64_SOURCE

#include <fcntl.h>
#include <pthread.h>
#include <semaphore.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#define CUSTOM_EMU_STUB_CONSTRUCTOR
#define NO_EMU_STUB_DESTRUCTOR
#include <emu-stub/base.h>
#include <emu-stub/stub.h>
#include <emu-stub/typeswap.h>

#include "libc_private.h"
#include "libpthread_const.h"
#include "libpthread_private.h"

/* Compatibility type for old conditional variable interfaces.  */
typedef struct
{
  pthread_cond_t *cond;
} pthread_cond_2_0_t;

struct xid_command;

/* Data type shared with libc.  The libc uses it to pass on calls to
   the thread functions.  */
struct pthread_functions {
/* These functions do not support pthread upgrade yet.  */
#if 0
  int (*ptr_pthread_attr_destroy) (pthread_attr_t *);
  int (*ptr___pthread_attr_init_2_0) (pthread_attr_t *);
  int (*ptr___pthread_attr_init_2_1) (pthread_attr_t *);
  int (*ptr_pthread_attr_getdetachstate) (const pthread_attr_t *, int *);
  int (*ptr_pthread_attr_setdetachstate) (pthread_attr_t *, int);
  int (*ptr_pthread_attr_getinheritsched) (const pthread_attr_t *, int *);
  int (*ptr_pthread_attr_setinheritsched) (pthread_attr_t *, int);
  int (*ptr_pthread_attr_getschedparam) (const pthread_attr_t *,
					 struct sched_param *);
  int (*ptr_pthread_attr_setschedparam) (pthread_attr_t *,
					 const struct sched_param *);
  int (*ptr_pthread_attr_getschedpolicy) (const pthread_attr_t *, int *);
  int (*ptr_pthread_attr_setschedpolicy) (pthread_attr_t *, int);
  int (*ptr_pthread_attr_getscope) (const pthread_attr_t *, int *);
  int (*ptr_pthread_attr_setscope) (pthread_attr_t *, int);
  int (*ptr_pthread_condattr_destroy) (pthread_condattr_t *);
  int (*ptr_pthread_condattr_init) (pthread_condattr_t *);
#endif
  int (*ptr___pthread_cond_broadcast) (pthread_cond_t *);
  int (*ptr___pthread_cond_destroy) (pthread_cond_t *);
  int (*ptr___pthread_cond_init) (pthread_cond_t *,
				  const pthread_condattr_t *);
  int (*ptr___pthread_cond_signal) (pthread_cond_t *);
  int (*ptr___pthread_cond_wait) (pthread_cond_t *, pthread_mutex_t *);
  int (*ptr___pthread_cond_timedwait) (pthread_cond_t *, pthread_mutex_t *,
				       const struct timespec *);
  int (*ptr___pthread_cond_broadcast_2_0) (pthread_cond_2_0_t *);
  int (*ptr___pthread_cond_destroy_2_0) (pthread_cond_2_0_t *);
  int (*ptr___pthread_cond_init_2_0) (pthread_cond_2_0_t *,
				      const pthread_condattr_t *);
  int (*ptr___pthread_cond_signal_2_0) (pthread_cond_2_0_t *);
  int (*ptr___pthread_cond_wait_2_0) (pthread_cond_2_0_t *, pthread_mutex_t *);
  int (*ptr___pthread_cond_timedwait_2_0) (pthread_cond_2_0_t *,
					   pthread_mutex_t *,
					   const struct timespec *);
  int (*ptr_pthread_equal) (pthread_t, pthread_t);
/* These functions do not support pthread upgrade yet.  */
#if 0
  void (*ptr___pthread_exit) (void *);
  int (*ptr_pthread_getschedparam) (pthread_t, int *, struct sched_param *);
  int (*ptr_pthread_setschedparam) (pthread_t, int,
				    const struct sched_param *);
#endif
  int (*ptr_pthread_mutex_destroy) (pthread_mutex_t *);
  int (*ptr_pthread_mutex_init) (pthread_mutex_t *,
				 const pthread_mutexattr_t *);
  int (*ptr_pthread_mutex_lock) (pthread_mutex_t *);
  int (*ptr___pthread_mutex_trylock) (pthread_mutex_t *);
  int (*ptr_pthread_mutex_unlock) (pthread_mutex_t *);
  pthread_t (*ptr_pthread_self) (void);
  int (*ptr_pthread_setcancelstate) (int, int *);
/* This function does not support pthread upgrade yet.  */
#if 0
  int (*ptr_pthread_setcanceltype) (int, int *);
#endif
  void (*ptr___pthread_cleanup_upto) (__jmp_buf, char *);
  int (*ptr___pthread_once) (pthread_once_t *, void (*) (void));
  int (*ptr___pthread_rwlock_rdlock) (pthread_rwlock_t *);
  int (*ptr___pthread_rwlock_tryrdlock) (pthread_rwlock_t *);
  int (*ptr___pthread_rwlock_wrlock) (pthread_rwlock_t *);
  int (*ptr___pthread_rwlock_trywrlock) (pthread_rwlock_t *);
  int (*ptr___pthread_rwlock_unlock) (pthread_rwlock_t *);
  int (*ptr___pthread_key_create) (pthread_key_t *, void (*) (void *));
  void *(*ptr___pthread_getspecific) (pthread_key_t);
  int (*ptr___pthread_setspecific) (pthread_key_t, const void *);
  void (*ptr__pthread_cleanup_push_defer) (struct _pthread_cleanup_buffer *,
					   void (*) (void *), void *);
  void (*ptr__pthread_cleanup_pop_restore) (struct _pthread_cleanup_buffer *,
					    int);
#define HAVE_PTR_NTHREADS
  unsigned int *ptr_nthreads;
  void (*ptr___pthread_unwind) (__pthread_unwind_buf_t *)
       __attribute ((noreturn)) __cleanup_fct_attribute;
  void (*ptr__nptl_deallocate_tsd) (void);
  int (*ptr__nptl_setxid) (struct xid_command *);
  void (*ptr_freeres) (void);
};

static int pthread_cond_broadcast_2_0(pthread_cond_2_0_t *x) {
	fprintf(stderr, "Unimplemented stub pthread_cond_broadcast_2_0\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static int pthread_cond_destroy_2_0(pthread_cond_2_0_t *x) {
	fprintf(stderr, "Unimplemented stub pthread_cond_destroy_2_0\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static int pthread_cond_init_2_0(pthread_cond_2_0_t *x,
	const pthread_condattr_t *y) {
	fprintf(stderr, "Unimplemented stub pthread_cond_init_2_0\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

static int pthread_cond_signal_2_0(pthread_cond_2_0_t *x) {
	fprintf(stderr, "Unimplemented stub pthread_cond_signal_2_0\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static int pthread_cond_wait_2_0(pthread_cond_2_0_t *x, pthread_mutex_t *y) {
	fprintf(stderr, "Unimplemented stub pthread_cond_wait_2_0\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

static int pthread_cond_timedwait_2_0(pthread_cond_2_0_t *x, pthread_mutex_t *y,
	const struct timespec *z) {
	fprintf(stderr, "Unimplemented stub pthread_cond_timedwait_2_0\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

static void pthread_cleanup_upto(__jmp_buf x, char *y) {
	fprintf(stderr, "Unimplemented stub pthread_cleanup_upto\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

// TODO: Update in pthread_create... stubs
static unsigned int nthreads = 1;

__attribute__((noreturn)) __cleanup_fct_attribute static void
	pthread_unwind(__pthread_unwind_buf_t *x) {
	fprintf(stderr, "Unimplemented stub pthread_unwind\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static void nptl_deallocate_tsd(void) {
	fprintf(stderr, "Unimplemented stub nptl_deallocate_tsd\n");
	exit(EXIT_FAILURE);
}

static int nptl_setxid(struct xid_command *x) {
	fprintf(stderr, "Unimplemented stub nptl_setxid\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static void freeres(void) {
	fprintf(stderr, "Unimplemented stub freeres\n");
	exit(EXIT_FAILURE);
}

// TODO: These should be easy
static int pthread_rwlock_tryrdlock_internal(pthread_rwlock_t *x) {
	fprintf(stderr,
		"Unimplemented stub pthread_rwlock_tryrdlock_internal\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static int pthread_rwlock_trywrlock_internal(pthread_rwlock_t *x) {
	fprintf(stderr,
		"Unimplemented stub pthread_rwlock_trywrlock_internal\n");
	exit(EXIT_FAILURE);
	if (x) {}
}

static const struct pthread_functions pthread_functions = {
/* These functions do not support pthread upgrade yet.  */
#if 0
    .ptr_pthread_attr_destroy = __pthread_attr_destroy,
# if SHLIB_COMPAT(libpthread, GLIBC_2_0, GLIBC_2_1)
    .ptr___pthread_attr_init_2_0 = __pthread_attr_init_2_0,
# endif
    .ptr___pthread_attr_init_2_1 = __pthread_attr_init_2_1,
    .ptr_pthread_attr_getdetachstate = __pthread_attr_getdetachstate,
    .ptr_pthread_attr_setdetachstate = __pthread_attr_setdetachstate,
    .ptr_pthread_attr_getinheritsched = __pthread_attr_getinheritsched,
    .ptr_pthread_attr_setinheritsched = __pthread_attr_setinheritsched,
    .ptr_pthread_attr_getschedparam = __pthread_attr_getschedparam,
    .ptr_pthread_attr_setschedparam = __pthread_attr_setschedparam,
    .ptr_pthread_attr_getschedpolicy = __pthread_attr_getschedpolicy,
    .ptr_pthread_attr_setschedpolicy = __pthread_attr_setschedpolicy,
    .ptr_pthread_attr_getscope = __pthread_attr_getscope,
    .ptr_pthread_attr_setscope = __pthread_attr_setscope,
    .ptr_pthread_condattr_destroy = __pthread_condattr_destroy,
    .ptr_pthread_condattr_init = __pthread_condattr_init,
#endif
	.ptr___pthread_cond_broadcast = pthread_cond_broadcast,
	.ptr___pthread_cond_destroy = pthread_cond_destroy,
	.ptr___pthread_cond_init = pthread_cond_init,
	.ptr___pthread_cond_signal = pthread_cond_signal,
	.ptr___pthread_cond_wait = pthread_cond_wait,
	.ptr___pthread_cond_timedwait = pthread_cond_timedwait,
	.ptr___pthread_cond_broadcast_2_0 = pthread_cond_broadcast_2_0,
	.ptr___pthread_cond_destroy_2_0 = pthread_cond_destroy_2_0,
	.ptr___pthread_cond_init_2_0 = pthread_cond_init_2_0,
	.ptr___pthread_cond_signal_2_0 = pthread_cond_signal_2_0,
	.ptr___pthread_cond_wait_2_0 = pthread_cond_wait_2_0,
	.ptr___pthread_cond_timedwait_2_0 = pthread_cond_timedwait_2_0,
	.ptr_pthread_equal = pthread_equal,
/* These functions do not support pthread upgrade yet.  */
#if 0
    .ptr___pthread_exit = __pthread_exit,
    .ptr_pthread_getschedparam = __pthread_getschedparam,
    .ptr_pthread_setschedparam = __pthread_setschedparam,
#endif
	.ptr_pthread_mutex_destroy = pthread_mutex_destroy,
	.ptr_pthread_mutex_init = pthread_mutex_init,
	.ptr_pthread_mutex_lock = pthread_mutex_lock,
	.ptr___pthread_mutex_trylock = pthread_mutex_trylock,
	.ptr_pthread_mutex_unlock = pthread_mutex_unlock,
	.ptr_pthread_self = pthread_self,
	.ptr_pthread_setcancelstate = pthread_setcancelstate,
/* This function does not support pthread upgrade yet.  */
#if 0
    .ptr_pthread_setcanceltype = __pthread_setcanceltype,
#endif
	.ptr___pthread_cleanup_upto = pthread_cleanup_upto,
	.ptr___pthread_once = pthread_once,
	.ptr___pthread_rwlock_rdlock = __pthread_rwlock_rdlock,
	.ptr___pthread_rwlock_tryrdlock = pthread_rwlock_tryrdlock_internal,
	.ptr___pthread_rwlock_wrlock = __pthread_rwlock_wrlock,
	.ptr___pthread_rwlock_trywrlock = pthread_rwlock_trywrlock_internal,
	.ptr___pthread_rwlock_unlock = __pthread_rwlock_unlock,
	.ptr___pthread_key_create = pthread_key_create,
	.ptr___pthread_getspecific = pthread_getspecific,
	.ptr___pthread_setspecific = pthread_setspecific,
	.ptr__pthread_cleanup_push_defer = _pthread_cleanup_push_defer,
	.ptr__pthread_cleanup_pop_restore = _pthread_cleanup_pop_restore,
	.ptr_nthreads = &nthreads,
	.ptr___pthread_unwind = pthread_unwind,
	.ptr__nptl_deallocate_tsd = nptl_deallocate_tsd,
	.ptr__nptl_setxid = nptl_setxid,
	.ptr_freeres = freeres
};

// The emulator may reclaim some memory?
// reset nthreads
static void reclaim_stacks(void) {
	fprintf(stderr, "Unimplemented stub reclaim_stacks\n");
	exit(EXIT_FAILURE);
}

__attribute__((constructor)) static void stub_init(void) {
/*	unsigned args[] = {
		STUB_INIT
	};
	normal_call(args);*/
	__libc_emu_init();
	emu_stub_constructor();
	__libc_pthread_init(NULL, reclaim_stacks, &pthread_functions);
}

__attribute__((weak))
off64_t lseek64(int fd, off64_t offset, int whence) {
	off64_t result;
	int_s64 is = { .i64 = offset };
	unsigned args[] = {
		LSEEK64,
		(unsigned) &result,
		fd,
		is.i[0],
		is.i[1],
		whence
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int open64(const char *pathname, int flags, ...) {
	int result;
	mode_t mode = 0;
	if (flags & O_CREAT) {
		va_list ap;
		va_start(ap, flags);
		mode = va_arg(ap, mode_t);
		va_end(ap);
	}
	unsigned args[] = {
		OPEN64,
		(unsigned) &result,
		(unsigned) pathname,
		flags,
		mode
	};
	normal_call(args);
	return result;
}

int pthread_attr_destroy(pthread_attr_t *attr) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_DESTROY,
		(unsigned) &result,
		(unsigned) attr
	};
	normal_call(args);
	return result;
}

int pthread_attr_getschedparam(const pthread_attr_t *attr,
	struct sched_param *param) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_GETSCHEDPARAM,
		(unsigned) &result,
		(unsigned) attr,
		(unsigned) param
	};
	normal_call(args);
	return result;
}

int pthread_attr_getstack(const pthread_attr_t *attr, void **stackaddr,
	size_t *stacksize) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_GETSTACK,
		(unsigned) &result,
		(unsigned) attr,
		(unsigned) stackaddr,
		(unsigned) stacksize
	};
	normal_call(args);
	return result;
}

int pthread_attr_init(pthread_attr_t *attr) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_INIT,
		(unsigned) &result,
		(unsigned) attr
	};
	normal_call(args);
	return result;
}

int pthread_attr_setdetachstate(pthread_attr_t *attr, int detachstate) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_SETDETACHSTATE,
		(unsigned) &result,
		(unsigned) attr,
		detachstate
	};
	normal_call(args);
	return result;
}

int pthread_attr_setschedparam(pthread_attr_t *attr,
	const struct sched_param *param) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_SETSCHEDPARAM,
		(unsigned) &result,
		(unsigned) attr,
		(unsigned) param
	};
	normal_call(args);
	return result;
}

int pthread_attr_setscope(pthread_attr_t *attr, int scope) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_SETSCOPE,
		(unsigned) &result,
		(unsigned) attr,
		scope
	};
	normal_call(args);
	return result;
}

int pthread_attr_setstacksize(pthread_attr_t *attr, size_t stacksize) {
	int result;
	unsigned args[] = {
		PTHREAD_ATTR_SETSTACKSIZE,
		(unsigned) &result,
		(unsigned) attr,
		stacksize
	};
	normal_call(args);
	return result;
}

int pthread_cancel(pthread_t thread) {
	int result;
	unsigned args[] = {
		PTHREAD_CANCEL,
		(unsigned) &result,
		thread
	};
	normal_call(args);
	return result;
}

void _pthread_cleanup_pop_restore(struct _pthread_cleanup_buffer *buffer,
	int execute) {
	unsigned args[] = {
		_PTHREAD_CLEANUP_POP_RESTORE,
		(unsigned) buffer,
		execute
	};
	normal_call(args);
}

__attribute__((noinline)) static void do_cleanup(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *routine_args = (unsigned *) syscall_result;
	void (*routine)(void *) = (void *) routine_args[0];
	void *arg = (void *) routine_args[1];
	routine(arg);
	emu_stub_return();
}

void _pthread_cleanup_push_defer(struct _pthread_cleanup_buffer *buffer,
	void (*routine)(void *), void *arg) {
	unsigned args[] = {
		_PTHREAD_CLEANUP_PUSH_DEFER,
		(unsigned) buffer,
		(unsigned) routine,
		(unsigned) arg
	};
	do_cleanup(callback_call(args));
}

int pthread_condattr_init(pthread_condattr_t *attr) {
	unsigned args[] = {
		PTHREAD_CONDATTR_INIT,
		(unsigned) attr
	};
	normal_call(args);
	return 0;
}

__attribute__((noinline)) static void do_thread(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *routine_args = (unsigned *) syscall_result;
	void *(*start_routine)(void *) = (void *) routine_args[0];
	void *arg = (void *) routine_args[1];
	void *retval = start_routine(arg);
	routine_args[0] = (unsigned) retval;
	emu_stub_return();
}

int pthread_create(pthread_t *thread, const pthread_attr_t *attr,
	void *(*start_routine)(void *), void *arg) {
	int result;
	unsigned args[] = {
		PTHREAD_CREATE,
		(unsigned) &result,
		(unsigned) thread,
		(unsigned) attr,
		(unsigned) start_routine,
		(unsigned) arg
	};
	do_thread(callback_call(args));
	return result;
}

void pthread_exit(void *retval) {
	unsigned args[] = {
		PTHREAD_EXIT,
		(unsigned) retval
	};
	normal_call(args);
	exit(EXIT_FAILURE);
}

int pthread_getattr_np(pthread_t th, pthread_attr_t *attr) {
	int result;
	unsigned args[] = {
		PTHREAD_GETATTR_NP,
		(unsigned) &result,
		th,
		(unsigned) attr
	};
	normal_call(args);
	return result;
}

int pthread_getschedparam(pthread_t target_thread, int *policy,
	struct sched_param *param) {
	int result;
	unsigned args[] = {
		PTHREAD_GETSCHEDPARAM,
		(unsigned) &result,
		target_thread,
		(unsigned) policy,
		(unsigned) param
	};
	normal_call(args);
	return result;
}

void *pthread_getspecific(pthread_key_t key) {
	void *result;
	unsigned args[] = {
		PTHREAD_GETSPECIFIC,
		(unsigned) &result,
		key
	};
	normal_call(args);
	return result;
}

int pthread_join(pthread_t th, void **thread_return) {
	int result;
	unsigned args[] = {
		PTHREAD_JOIN,
		(unsigned) &result,
		th,
		(unsigned) thread_return
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_destr_function(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	void (*destr_function)(void *) = (void *) callback_args[0];
	void *pointer = (void *) callback_args[1];
	destr_function(pointer);
	emu_stub_return();
}

int pthread_key_create(pthread_key_t *key, void (*destr_function)(void *)) {
	int result;
	unsigned args[] = {
		PTHREAD_KEY_CREATE,
		(unsigned) &result,
		(unsigned) key,
		(unsigned) destr_function
	};
	static int once = 1;
	if (once) {
		once = 0;
		do_destr_function(callback_call(args));
	}
	else
		normal_call(args);
	return result;
}

int pthread_key_delete(pthread_key_t key) {
	int result;
	unsigned args[] = {
		PTHREAD_KEY_DELETE,
		(unsigned) &result,
		key
	};
	normal_call(args);
	return result;
}

int pthread_mutex_trylock(pthread_mutex_t *mutex) {
	int result;
	unsigned args[] = {
		PTHREAD_MUTEX_TRYLOCK,
		(unsigned) &result,
		(unsigned) mutex
	};
	normal_call(args);
	return result;
}

int pthread_mutexattr_destroy(pthread_mutexattr_t *attr) {
	unsigned args[] = {
		PTHREAD_MUTEXATTR_DESTROY,
		(unsigned) attr
	};
	normal_call(args);
	return 0;
}

int pthread_mutexattr_init(pthread_mutexattr_t *attr) {
	unsigned args[] = {
		PTHREAD_MUTEXATTR_INIT,
		(unsigned) attr
	};
	normal_call(args);
	return 0;
}

int pthread_mutexattr_settype(pthread_mutexattr_t *attr, int kind) {
	int result;
	unsigned args[] = {
		PTHREAD_MUTEXATTR_SETTYPE,
		(unsigned) &result,
		(unsigned) attr,
		kind
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_once(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	void (*init_routine)(void) = (void *) syscall_result;
	init_routine();
	emu_stub_return();
}

int pthread_once(pthread_once_t *once_control, void (*init_routine)(void)) {
	unsigned args[] = {
		PTHREAD_ONCE,
		(unsigned) once_control,
		(unsigned) init_routine
	};
	do_once(callback_call(args));
	return 0;
}

int __pthread_rwlock_rdlock(pthread_rwlock_t *rwlock) {
	int result;
	unsigned args[] = {
		__PTHREAD_RWLOCK_RDLOCK,
		(unsigned) &result,
		(unsigned) rwlock
	};
	normal_call(args);
	return result;
}

int __pthread_rwlock_unlock(pthread_rwlock_t *rwlock) {
	int result;
	unsigned args[] = {
		__PTHREAD_RWLOCK_UNLOCK,
		(unsigned) &result,
		(unsigned) rwlock
	};
	normal_call(args);
	return result;
}

int __pthread_rwlock_wrlock(pthread_rwlock_t *rwlock) {
	int result;
	unsigned args[] = {
		__PTHREAD_RWLOCK_WRLOCK,
		(unsigned) &result,
		(unsigned) rwlock
	};
	normal_call(args);
	return result;
}

int pthread_setschedparam(pthread_t target_thread, int policy,
	const struct sched_param *param) {
	int result;
	unsigned args[] = {
		PTHREAD_SETSCHEDPARAM,
		(unsigned) &result,
		target_thread,
		policy,
		(unsigned) param
	};
	normal_call(args);
	return result;
}

int pthread_setspecific(pthread_key_t key, const void *pointer) {
	int result;
	unsigned args[] = {
		PTHREAD_SETSPECIFIC,
		(unsigned) &result,
		key,
		(unsigned) pointer
	};
	normal_call(args);
	return result;
}

int pthread_sigmask(int how, const sigset_t *newmask, sigset_t *oldmask) {
	int result;
	unsigned args[] = {
		PTHREAD_SIGMASK,
		(unsigned) &result,
		how,
		(unsigned) newmask,
		(unsigned) oldmask
	};
	normal_call(args);
	return result;
}

int sem_destroy(sem_t *sem) {
	int result;
	unsigned args[] = {
		SEM_DESTROY,
		(unsigned) &result,
		(unsigned) sem
	};
	normal_call(args);
	return result;
}

int sem_init(sem_t *sem, int pshared, unsigned int value) {
	int result;
	unsigned args[] = {
		SEM_INIT,
		(unsigned) &result,
		(unsigned) sem,
		pshared,
		value
	};
	normal_call(args);
	return result;
}

int sem_wait(sem_t *sem) {
	int result;
	unsigned args[] = {
		SEM_WAIT,
		(unsigned) &result,
		(unsigned) sem
	};
	normal_call(args);
	return result;
}

int pthread_attr_getdetachstate(const pthread_attr_t *attr, int *detachstate) {
	fprintf(stderr, "Unimplemented stub pthread_attr_getdetachstate\n");
	exit(EXIT_FAILURE);
	if (attr || detachstate) {}
}
int pthread_attr_getinheritsched(const pthread_attr_t *attr, int *inherit) {
	fprintf(stderr, "Unimplemented stub pthread_attr_getinheritsched\n");
	exit(EXIT_FAILURE);
	if (attr || inherit) {}
}
int pthread_attr_getschedpolicy(const pthread_attr_t *attr, int *policy) {
	fprintf(stderr, "Unimplemented stub pthread_attr_getschedpolicy\n");
	exit(EXIT_FAILURE);
	if (attr || policy) {}
}
int pthread_attr_getscope(const pthread_attr_t *attr, int *scope) {
	fprintf(stderr, "Unimplemented stub pthread_attr_getscope\n");
	exit(EXIT_FAILURE);
	if (attr || scope) {}
}
int pthread_attr_setinheritsched(pthread_attr_t *attr, int inherit) {
	fprintf(stderr, "Unimplemented stub pthread_attr_setinheritsched\n");
	exit(EXIT_FAILURE);
	if (attr || inherit) {}
}
int pthread_attr_setschedpolicy(pthread_attr_t *attr, int policy) {
	fprintf(stderr, "Unimplemented stub pthread_attr_setschedpolicy\n");
	exit(EXIT_FAILURE);
	if (attr || policy) {}
}
int pthread_condattr_destroy(pthread_condattr_t *attr) {
	fprintf(stderr, "Unimplemented stub pthread_condattr_destroy\n");
	exit(EXIT_FAILURE);
	if (attr) {}
}
int pthread_setcanceltype(int type, int *oldtype) {
	fprintf(stderr, "Unimplemented stub pthread_setcanceltype\n");
	exit(EXIT_FAILURE);
	if (type || oldtype) {}
}
