#include <emu-stub/base.h>
#include <fontconfig/fcprivate.h>
#include <fontconfig/fontconfig.h>
#include <fontconfig/fcfreetype.h>

#include "libfontconfig_const.h"

FcChar32 FcCharSetFirstPage(const FcCharSet *a,
	FcChar32 map[FC_CHARSET_MAP_SIZE], FcChar32 *next) {
	FcChar32 result;
	unsigned args[] = {
		FCCHARSETFIRSTPAGE,
		(unsigned) &result,
		(unsigned) a,
		(unsigned) map,
		(unsigned) next
	};
	normal_call(args);
	return result;
}

FcChar32 FcCharSetNextPage(const FcCharSet *a,
	FcChar32 map[FC_CHARSET_MAP_SIZE], FcChar32 *next) {
	FcChar32 result;
	unsigned args[] = {
		FCCHARSETNEXTPAGE,
		(unsigned) &result,
		(unsigned) a,
		(unsigned) map,
		(unsigned) next
	};
	normal_call(args);
	return result;
}

FcBool FcConfigSubstitute(FcConfig *config, FcPattern *p, FcMatchKind kind) {
	FcBool result;
	unsigned args[] = {
		FCCONFIGSUBSTITUTE,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) p,
		kind
	};
	normal_call(args);
	return result;
}

void FcDefaultSubstitute(FcPattern *pattern) {
	unsigned args[] = {
		FCDEFAULTSUBSTITUTE,
		(unsigned) pattern
	};
	normal_call(args);
}

FcPattern *FcFontRenderPrepare(FcConfig *config, FcPattern *pat,
	FcPattern *font) {
	FcPattern *result;
	unsigned args[] = {
		FCFONTRENDERPREPARE,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) pat,
		(unsigned) font
	};
	normal_call(args);
	return result;
}

void FcFontSetDestroy(FcFontSet *s) {
	unsigned args[] = {
		FCFONTSETDESTROY,
		(unsigned) s
	};
	normal_call(args);
}

FcFontSet *FcFontSort(FcConfig *config, FcPattern *p, FcBool trim,
	FcCharSet **csp, FcResult *target_result) {
	FcFontSet *result;
	unsigned args[] = {
		FCFONTSORT,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) p,
		trim,
		(unsigned) csp,
		(unsigned) target_result
	};
	normal_call(args);
	return result;
}

FT_UInt FcFreeTypeCharIndex(FT_Face face, FcChar32 ucs4) {
	FT_UInt result;
	unsigned args[] = {
		FCFREETYPECHARINDEX,
		(unsigned) &result,
		(unsigned) face,
		ucs4
	};
	normal_call(args);
	return result;
}

FcBool FcPatternAdd(FcPattern *p, const char *object, FcValue value,
	FcBool append) {
	FcBool result;
	unsigned args[] = {
		FCPATTERNADD,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		(unsigned) &value,
		append
	};
	normal_call(args);
	return result;
}

FcBool FcPatternAddString(FcPattern *p, const char *object, const FcChar8 *s) {
	FcBool result;
	unsigned args[] = {
		FCPATTERNADDSTRING,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		(unsigned) s
	};
	normal_call(args);
	return result;
}

FcPattern *FcPatternBuild(FcPattern *orig, ...) {
	FcPattern *result;
	va_list ap;
	va_start(ap, orig);
	result = FcPatternVaBuild(orig, ap);
	va_end(ap);
	return result;
}

FcPattern *FcPatternCreate(void) {
	FcPattern *result;
	unsigned args[] = {
		FCPATTERNCREATE,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

void FcPatternDestroy(FcPattern *p) {
	unsigned args[] = {
		FCPATTERNDESTROY,
		(unsigned) p
	};
	normal_call(args);
}

FcResult FcPatternGetBool(const FcPattern *p, const char *object, int n,
	FcBool *b) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETBOOL,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) b
	};
	normal_call(args);
	return result;
}

FcResult FcPatternGetCharSet(const FcPattern *p, const char *object, int n,
	FcCharSet **c) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETCHARSET,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) c
	};
	normal_call(args);
	return result;
}

FcResult FcPatternGetDouble(const FcPattern *p, const char *object, int n,
	double *d) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETDOUBLE,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) d
	};
	normal_call(args);
	return result;
}

FcResult FcPatternGetInteger(const FcPattern *p, const char *object, int n,
	int *i) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETINTEGER,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) i
	};
	normal_call(args);
	return result;
}

FcResult FcPatternGetMatrix(const FcPattern *p, const char *object, int n,
	FcMatrix **s) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETMATRIX,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) s
	};
	normal_call(args);
	return result;
}

FcResult FcPatternGetString(const FcPattern *p, const char *object, int n,
	FcChar8 **s) {
	FcResult result;
	unsigned args[] = {
		FCPATTERNGETSTRING,
		(unsigned) &result,
		(unsigned) p,
		(unsigned) object,
		n,
		(unsigned) s
	};
	normal_call(args);
	return result;
}

FcChar32 FcPatternHash(const FcPattern *p) {
	FcChar32 result;
	unsigned args[] = {
		FCPATTERNHASH,
		(unsigned) &result,
		(unsigned) p
	};
	normal_call(args);
	return result;
}

void FcPatternReference(FcPattern *p) {
	unsigned args[] = {
		FCPATTERNREFERENCE,
		(unsigned) p
	};
	normal_call(args);
}

FcPattern *FcPatternVaBuild(FcPattern *orig, va_list va) {
	FcPattern *result;
	FcPatternVapBuild(result, orig, va);
	return result;
}
