#include <cairo/cairo.h>
#include <cairo/cairo-ft.h>
#include <emu-stub/base.h>

#include "libcairo_const.h"

void cairo_font_face_destroy(cairo_font_face_t *font_face) {
	unsigned args[] = {
		CAIRO_FONT_FACE_DESTROY,
		(unsigned) font_face
	};
	normal_call(args);
}

cairo_font_options_t *cairo_font_options_copy(
	const cairo_font_options_t *original) {
	cairo_font_options_t *result;
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_COPY,
		(unsigned) &result,
		(unsigned) original
	};
	normal_call(args);
	return result;
}

cairo_font_options_t *cairo_font_options_create(void) {
	cairo_font_options_t *result;
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_CREATE,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

void cairo_font_options_destroy(cairo_font_options_t *options) {
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_DESTROY,
		(unsigned) options
	};
	normal_call(args);
}

cairo_hint_metrics_t cairo_font_options_get_hint_metrics(
	const cairo_font_options_t *options) {
	cairo_hint_metrics_t result;
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_GET_HINT_METRICS,
		(unsigned) &result,
		(unsigned) options
	};
	normal_call(args);
	return result;
}

unsigned long cairo_font_options_hash(const cairo_font_options_t *options) {
	unsigned long result;
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_HASH,
		(unsigned) &result,
		(unsigned) options
	};
	normal_call(args);
	return result;
}

void cairo_font_options_merge(cairo_font_options_t *options,
	const cairo_font_options_t *other) {
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_MERGE,
		(unsigned) options,
		(unsigned) other
	};
	normal_call(args);
}

void cairo_font_options_set_antialias(cairo_font_options_t *options,
	cairo_antialias_t antialias) {
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_SET_ANTIALIAS,
		(unsigned) options,
		antialias
	};
	normal_call(args);
}

void cairo_font_options_set_hint_style(cairo_font_options_t *options,
	cairo_hint_style_t hint_style) {
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_SET_HINT_STYLE,
		(unsigned) options,
		hint_style
	};
	normal_call(args);
}

void cairo_font_options_set_subpixel_order(cairo_font_options_t *options,
	cairo_subpixel_order_t subpixel_order) {
	unsigned args[] = {
		CAIRO_FONT_OPTIONS_SET_SUBPIXEL_ORDER,
		(unsigned) options,
		subpixel_order
	};
	normal_call(args);
}

cairo_font_face_t *cairo_ft_font_face_create_for_pattern(FcPattern *pattern) {
	cairo_font_face_t *result;
	unsigned args[] = {
		CAIRO_FT_FONT_FACE_CREATE_FOR_PATTERN,
		(unsigned) &result,
		(unsigned) pattern
	};
	normal_call(args);
	return result;
}

void cairo_ft_font_options_substitute(const cairo_font_options_t *options,
	FcPattern *pattern) {
	unsigned args[] = {
		CAIRO_FT_FONT_OPTIONS_SUBSTITUTE,
		(unsigned) options,
		(unsigned) pattern
	};
	normal_call(args);
}

FT_Face cairo_ft_scaled_font_lock_face(cairo_scaled_font_t *scaled_font) {
	FT_Face result;
	unsigned args[] = {
		CAIRO_FT_SCALED_FONT_LOCK_FACE,
		(unsigned) &result,
		(unsigned) scaled_font
	};
	normal_call(args);
	return result;
}

void cairo_ft_scaled_font_unlock_face(cairo_scaled_font_t *scaled_font) {
	unsigned args[] = {
		CAIRO_FT_SCALED_FONT_UNLOCK_FACE,
		(unsigned) scaled_font
	};
	normal_call(args);
}

void cairo_matrix_init(cairo_matrix_t *matrix, double xx, double yx, double xy,
	double yy, double x0, double y0) {
	matrix->xx = xx;
	matrix->yx = yx;
	matrix->xy = xy;
	matrix->yy = yy;
	matrix->x0 = x0;
	matrix->y0 = y0;
}

void cairo_matrix_init_identity(cairo_matrix_t *matrix) {
	cairo_matrix_init(matrix, 1, 0, 0, 1, 0, 0);
}

void cairo_matrix_init_rotate(cairo_matrix_t *matrix, double radians) {
	double s = sin(radians);
	double c = cos(radians);
	cairo_matrix_init(matrix, c, s, -s, c, 0, 0);
}

void cairo_matrix_init_scale(cairo_matrix_t *matrix, double sx, double sy) {
	cairo_matrix_init(matrix, 1, 0, 0, 1, 0, 0);
}

void cairo_matrix_multiply(cairo_matrix_t *result, const cairo_matrix_t *a,
	const cairo_matrix_t *b) {
	cairo_matrix_t r;
	r.xx = a->xx * b->xx + a->yx * b->xy;
	r.yx = a->xx * b->yx + a->yx * b->yy;
	r.xy = a->xy * b->xx + a->yy * b->xy;
	r.yy = a->xy * b->yx + a->yy * b->yy;
	r.x0 = a->x0 * b->xx + a->y0 * b->xy + b->x0;
	r.y0 = a->x0 * b->yx + a->y0 * b->yy + b->y0;
	*result = r;
}

void cairo_matrix_scale(cairo_matrix_t *matrix, double sx, double sy) {
	cairo_matrix_t tmp;
	cairo_matrix_init_scale(&tmp, sx, sy);
	cairo_matrix_multiply(matrix, &tmp, matrix);
}

cairo_scaled_font_t *cairo_scaled_font_create(cairo_font_face_t *font_face,
	const cairo_matrix_t *font_matrix, const cairo_matrix_t *ctm,
	const cairo_font_options_t *options) {
	cairo_scaled_font_t *result;
	unsigned args[] = {
		CAIRO_SCALED_FONT_CREATE,
		(unsigned) &result,
		(unsigned) font_face,
		(unsigned) font_matrix,
		(unsigned) ctm,
		(unsigned) options
	};
	normal_call(args);
	return result;
}

cairo_status_t cairo_scaled_font_status(cairo_scaled_font_t *scaled_font) {
	cairo_status_t result;
	unsigned args[] = {
		CAIRO_SCALED_FONT_STATUS,
		(unsigned) &result,
		(unsigned) scaled_font
	};
	normal_call(args);
	return result;
}

void cairo_surface_destroy(cairo_surface_t *surface) {
	unsigned args[] = {
		CAIRO_SURFACE_DESTROY,
		(unsigned) surface
	};
	normal_call(args);
}
