#define _GNU_SOURCE

#include <dlfcn.h>
#include <errno.h>
#include <fcntl.h>
#include <langinfo.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#define CUSTOM_EMU_STUB_CONSTRUCTOR
#define NO_EMU_STUB_DESTRUCTOR
#include <emu-stub/base.h>
#include <emu-stub/stub.h>
#include <emu-stub/typeswap.h>
#include <sys/epoll.h>
#include <sys/socket.h>
#include <sys/uio.h>

#include "libc_preload_const.h"
#include "libc_private.h"

/*FILE *stderr;
FILE *stdin;
FILE *stdout;*/

__attribute__((constructor)) static void stub_init(void) {
	__libc_emu_init();
	unsigned args[] = {
		STUB_INIT
	};
	normal_call(args);
}

__attribute__((weak))
int accept(int sockfd, struct sockaddr *addr, socklen_t *addrlen) {
	int result;
	unsigned args[] = {
		ACCEPT,
		(unsigned) &result,
		sockfd,
		(unsigned) addr,
		(unsigned) addrlen
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
char *bindtextdomain(const char *domainname, const char *dirname) {
	char *result;
	unsigned args[] = {
		BINDTEXTDOMAIN,
		(unsigned) &result,
		(unsigned) domainname,
		(unsigned) dirname
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
void *calloc(size_t nmemb, size_t size) {
	void *result;
	unsigned args[] = {
		CALLOC,
		(unsigned) &result,
		nmemb,
		size
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int close(int fd) {
	int result;
	unsigned args[] = {
		CLOSE,
		(unsigned) &result,
		fd
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int connect(int sockfd, const struct sockaddr *serv_addr, socklen_t addrlen) {
	int result;
	unsigned args[] = {
		CONNECT,
		(unsigned) &result,
		sockfd,
		(unsigned) serv_addr,
		addrlen
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
char *dcgettext(const char *domainname, const char *msgid, int category) {
	char *result;
	unsigned args[] = {
		DCGETTEXT,
		(unsigned) &result,
		(unsigned) domainname,
		(unsigned) msgid,
		category
	};
	normal_call(args);
	return result;
}

char *__dcgettext(const char *domainname, const char *msgid, int category) {
	char *result;
	unsigned args[] = {
		__DCGETTEXT,
		(unsigned) &result,
		(unsigned) domainname,
		(unsigned) msgid,
		category
	};
	normal_call(args);
	return result;
}

/*void *dlopen(const char *filename, int flag) {
printf("dlopen %s %d\n", filename, flag);
	void *(*target_dlopen)(const char *, int) = dlsym(RTLD_NEXT, "dlopen");
	return target_dlopen(filename, flag);
}*/

/*void *dlsym(void *handle, const char *symbol) {
printf("dlsym %s\n", symbol);
	void *(*target_dlsym)(void *, const char *) = dlvsym(RTLD_NEXT, "dlsym", "GLIBC_2.0");
	return target_dlsym(handle, symbol);
}*/

int epoll_create(int size) {
	int result;
	unsigned args[] = {
		EPOLL_CREATE,
		(unsigned) &result,
		size
	};
	normal_call(args);
	return result;
}

int epoll_ctl(int epfd, int op, int fd, struct epoll_event *event) {
	int result;
	unsigned args[] = {
		EPOLL_CTL,
		(unsigned) &result,
		epfd,
		op,
		fd,
		(unsigned) event
	};
	normal_call(args);
	return result;
}

int epoll_wait(int epfd, struct epoll_event *events, int maxevents,
	int timeout) {
	int result;
	unsigned args[] = {
		EPOLL_WAIT,
		(unsigned) &result,
		epfd,
		(unsigned) events,
		maxevents,
		timeout
	};
	normal_call(args);
	return result;
}

int *__errno_location(void) {
	int *result;
	unsigned args[] = {
		__ERRNO_LOCATION,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

/*void exit(int status) {
	unsigned args[] = {
		EXIT,
		status
	};
	normal_call(args);
}*/

/*int fclose(FILE *fp) {
	int result;
	unsigned args[] = {
		FCLOSE,
		(unsigned) &result,
		(unsigned) fp
	};
	normal_call(args);
	return result;
}*/

__attribute__((weak))
int fcntl(int fd, int cmd, ...) {
	int result;
	unsigned arg = 0;
	va_list ap;
	va_start(ap, cmd);
	switch (cmd) {
	case F_DUPFD:
	case F_SETFD:
	case F_SETFL:
		arg = va_arg(ap, long);
		break;
	default:
		fprintf(stderr, "unsupported fcntl cmd %d\n", cmd);
	case F_GETFD:
	case F_GETFL:
		;
	}
	va_end(ap);
	unsigned args[] = {
		FCNTL,
		(unsigned) &result,
		fd,
		cmd,
		arg
	};
	normal_call(args);
	return result;
}

/*int fflush(FILE *stream) {
	int result;
	unsigned args[] = {
		FFLUSH,
		(unsigned) &result,
		(unsigned) stream
	};
	normal_call(args);
	return result;
}*/

/*FILE *fopen64(const char *path, const char *mode) {
	FILE *result;
	unsigned args[] = {
		FOPEN64,
		(unsigned) &result,
		(unsigned) path,
		(unsigned) mode
	};
	normal_call(args);
	return result;
}*/

__attribute__((weak))
pid_t fork(void) {
	pid_t result;
	unsigned args[] = {
		FORK,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

// va_list assumed a stack pointer. This stub workarounds i386.

/*int fprintf(FILE *stream, const char *format, ...) {
	va_list ap;
	va_start(ap, format);
	int result = vfprintf(stream, format, ap);
	va_end(ap);
	return result;
}*/

/*int fputc(int c, FILE *stream) {
	int result;
	unsigned args[] = {
		FPUTC,
		(unsigned) &result,
		c,
		(unsigned) stream
	};
	normal_call(args);
	return result;
}*/

void free(void *ptr) {
	unsigned args[] = {
		FREE,
		(unsigned) ptr
	};
	normal_call(args);
}

__attribute__((weak))
int fsync(int fd) {
	int result;
	unsigned args[] = {
		FSYNC,
		(unsigned) &result,
		fd
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int ftruncate64(int fd, off64_t length) {
	int result;
	int_s64 is = { .i64 = length };
	unsigned args[] = {
		FTRUNCATE64,
		(unsigned) &result,
		fd,
		is.i[0],
		is.i[1]
	};
	normal_call(args);
	return result;
}

/*size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream) {
	size_t result;
	unsigned args[] = {
		FWRITE,
		(unsigned) &result,
		(unsigned) ptr,
		size,
		nmemb,
		(unsigned) stream
	};
	normal_call(args);
	return result;
}*/

/* set target errno */
/*char *getcwd(char *buf, size_t size) {
	char *result;
	unsigned args[] = {
		GETCWD,
		(unsigned) &result,
		(unsigned) buf,
		size
	};
	normal_call(args);
	return result;
}*/

/*ssize_t getline(char **lineptr, size_t *n, FILE *stream) {
	ssize_t result;
	unsigned args[] = {
		GETLINE,
		(unsigned) &result,
		(unsigned) lineptr,
		(unsigned) n,
		(unsigned) stream
	};
	normal_call(args);
	return result;
}*/

__attribute__((weak))
char *gettext(const char *msgid) {
	char *result;
	unsigned args[] = {
		GETTEXT,
		(unsigned) &result,
		(unsigned) msgid
	};
	normal_call(args);
	return result;
}

int inotify_init1(int flags) {
	int result;
	unsigned args[] = {
		INOTIFY_INIT1,
		(unsigned) &result,
		flags
	};
	normal_call(args);
	return result;
}

void __libc_emu_init(void) {
	if (!handle_syscall)
		emu_stub_constructor();
}

void *__libc_getspecific(pthread_key_t key) {
	void *result;
	unsigned args[] = {
		__LIBC_GETSPECIFIC,
		(unsigned) &result,
		key
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_destr_function(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	void (*destr_function)(void *) = (void *) callback_args[0];
	void *pointer = (void *) callback_args[1];
	destr_function(pointer);
	emu_stub_return();
}

int __libc_key_create(pthread_key_t *key, void (*destr)(void *)) {
	int result;
	unsigned args[] = {
		__LIBC_KEY_CREATE,
		(unsigned) &result,
		(unsigned) key,
		(unsigned) destr
	};
	static int once = 1;
	if (once) {
		once = 0;
		do_destr_function(callback_call(args));
	}
	else
		normal_call(args);
	return result;
}

int __libc_setspecific(pthread_key_t key, const void *value) {
	int result;
	unsigned args[] = {
		__LIBC_SETSPECIFIC,
		(unsigned) &result,
		key,
		(unsigned) value
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
off_t lseek(int fd, off_t offset, int whence) {
	off_t result;
	unsigned args[] = {
		LSEEK,
		(unsigned) &result,
		fd,
		offset,
		whence
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
off64_t lseek64(int fd, off64_t offset, int whence) {
	off64_t result;
	int_s64 is = { .i64 = offset };
	unsigned args[] = {
		LSEEK64,
		(unsigned) &result,
		fd,
		is.i[0],
		is.i[1],
		whence
	};
	normal_call(args);
	return result;
}

void *malloc(size_t size) {
	void *result;
	unsigned args[] = {
		MALLOC,
		(unsigned) &result,
		size
	};
	normal_call(args);
	return result;
}

/*int mkdir(const char *pathname, mode_t mode) {
	int result;
	unsigned args[] = {
		MKDIR,
		(unsigned) &result,
		(unsigned) pathname,
		mode,
		(unsigned) &errno
	};
	normal_call(args);
	return result;
}*/

__attribute__((weak))
void *mmap(void *addr, size_t length, int prot, int flags, int fd,
	off_t offset) {
	void *result;
	unsigned args[] = {
		MMAP,
		(unsigned) &result,
		(unsigned) addr,
		length,
		prot,
		flags,
		fd,
		offset
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
void *mmap64(void *addr, size_t length, int prot, int flags, int fd,
	off64_t offset) {
	void *result;
	int_s64 is = { .i64 = offset };
	unsigned args[] = {
		MMAP64,
		(unsigned) &result,
		(unsigned) addr,
		length,
		prot,
		flags,
		fd,
		is.i[0],
		is.i[1]
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int msync(void *addr, size_t length, int flags) {
	int result;
	unsigned args[] = {
		MSYNC,
		(unsigned) &result,
		(unsigned) addr,
		length,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int munmap(void *addr, size_t length) {
	int result;
	unsigned args[] = {
		MUNMAP,
		(unsigned) &result,
		(unsigned) addr,
		length
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int nanosleep(const struct timespec *req, struct timespec *rem) {
	int result;
	unsigned args[] = {
		NANOSLEEP,
		(unsigned) &result,
		(unsigned) req,
		(unsigned) rem
	};
	normal_call(args);
	return result;
}

char *nl_langinfo(nl_item item) {
	char *result;
	unsigned args[] = {
		NL_LANGINFO,
		(unsigned) &result,
		item
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int open(const char *pathname, int flags, ...) {
	int result;
	mode_t mode = 0;
	if (flags & O_CREAT) {
		va_list ap;
		va_start(ap, flags);
		mode = va_arg(ap, mode_t);
		va_end(ap);
	}
	unsigned args[] = {
		OPEN,
		(unsigned) &result,
		(unsigned) pathname,
		flags,
		mode
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int open64(const char *pathname, int flags, ...) {
	int result;
	mode_t mode = 0;
	if (flags & O_CREAT) {
		va_list ap;
		va_start(ap, flags);
		mode = va_arg(ap, mode_t);
		va_end(ap);
	}
	unsigned args[] = {
		OPEN64,
		(unsigned) &result,
		(unsigned) pathname,
		flags,
		mode
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int pipe(int pipefd[2]) {
	int result;
	unsigned args[] = {
		PIPE,
		(unsigned) &result,
		(unsigned) pipefd
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int pipe2(int pipefd[2], int flags) {
	int result;
	unsigned args[] = {
		PIPE2,
		(unsigned) &result,
		(unsigned) pipefd,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int posix_memalign(void **memptr, size_t alignment, size_t size) {
	int result;
	unsigned args[] = {
		POSIX_MEMALIGN,
		(unsigned) &result,
		(unsigned) memptr,
		alignment,
		size
	};
	normal_call(args);
	return result;
}

/*int printf(const char *format, ...) {
	va_list ap;
	va_start(ap, format);
	int result = vfprintf(stdout, format, ap);
	va_end(ap);
	return result;
}*/

int pthread_cond_broadcast(pthread_cond_t *cond) {
	unsigned args[] = {
		PTHREAD_COND_BROADCAST,
		(unsigned) cond
	};
	normal_call(args);
	return 0;
}

int pthread_cond_destroy(pthread_cond_t *cond) {
	int result;
	unsigned args[] = {
		PTHREAD_COND_DESTROY,
		(unsigned) &result,
		(unsigned) cond
	};
	normal_call(args);
	return result;
}

int pthread_cond_init(pthread_cond_t *cond,
	const pthread_condattr_t *cond_attr) {
	unsigned args[] = {
		PTHREAD_COND_INIT,
		(unsigned) cond,
		(unsigned) cond_attr
	};
	normal_call(args);
	return 0;
}

int pthread_cond_signal(pthread_cond_t *cond) {
	unsigned args[] = {
		PTHREAD_COND_SIGNAL,
		(unsigned) cond
	};
	normal_call(args);
	return 0;
}

int pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex,
	const struct timespec *abstime) {
	int result;
	unsigned args[] = {
		PTHREAD_COND_TIMEDWAIT,
		(unsigned) &result,
		(unsigned) cond,
		(unsigned) mutex,
		(unsigned) abstime
	};
	normal_call(args);
	return result;
}

int pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex) {
	unsigned args[] = {
		PTHREAD_COND_WAIT,
		(unsigned) cond,
		(unsigned) mutex
	};
	normal_call(args);
	return 0;
}

int pthread_equal(pthread_t t1, pthread_t t2) {
	return t1 == t2;
}

int pthread_mutex_destroy(pthread_mutex_t *mutex) {
	int result;
	unsigned args[] = {
		PTHREAD_MUTEX_DESTROY,
		(unsigned) &result,
		(unsigned) mutex
	};
	normal_call(args);
	return result;
}

int pthread_mutex_init(pthread_mutex_t *mutex,
	const pthread_mutexattr_t *mutexattr) {
	unsigned args[] = {
		PTHREAD_MUTEX_INIT,
		(unsigned) mutex,
		(unsigned) mutexattr
	};
	normal_call(args);
	return 0;
}

int pthread_mutex_lock(pthread_mutex_t *mutex) {
	int result;
	unsigned args[] = {
		PTHREAD_MUTEX_LOCK,
		(unsigned) &result,
		(unsigned) mutex
	};
	normal_call(args);
	return result;
}

int pthread_mutex_unlock(pthread_mutex_t *mutex) {
	int result;
	unsigned args[] = {
		PTHREAD_MUTEX_UNLOCK,
		(unsigned) &result,
		(unsigned) mutex
	};
	normal_call(args);
	return result;
}

pthread_t pthread_self(void) {
	pthread_t result;
	unsigned args[] = {
		PTHREAD_SELF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

/*int putchar(int c) {
	return putc(c, stdout);
//	return printf("%c", c);
	int result;
	unsigned args[] = {
		PUTCHAR,
		(unsigned) &result,
		c
	};
	normal_call(args);
	return result;
}*/

/*int puts(const char *s) {
	int result;
	unsigned args[] = {
		PUTS,
		(unsigned) &result,
		(unsigned) s
	};
	normal_call(args);
	return result;
}*/

__attribute__((weak))
ssize_t read(int fd, void *buf, size_t count) {
	ssize_t result;
	unsigned args[] = {
		READ,
		(unsigned) &result,
		fd,
		(unsigned) buf,
		count
	};
	normal_call(args);
	return result;
}

void *realloc(void *ptr, size_t size) {
	void *result;
	unsigned args[] = {
		REALLOC,
		(unsigned) &result,
		(unsigned) ptr,
		size
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t recv(int s, void *buf, size_t len, int flags) {
	ssize_t result;
	unsigned args[] = {
		RECV,
		(unsigned) &result,
		s,
		(unsigned) buf,
		len,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t recvfrom(int s, void *buf, size_t len, int flags, struct sockaddr *from,
	socklen_t *fromlen) {
	ssize_t result;
	unsigned args[] = {
		RECVFROM,
		(unsigned) &result,
		s,
		(unsigned) buf,
		len,
		flags,
		(unsigned) from,
		(unsigned) fromlen
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t recvmsg(int s, struct msghdr *msg, int flags) {
	ssize_t result;
	unsigned args[] = {
		RECVMSG,
		(unsigned) &result,
		s,
		(unsigned) msg,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t send(int s, const void *buf, size_t len, int flags) {
	ssize_t result;
	unsigned args[] = {
		SEND,
		(unsigned) &result,
		s,
		(unsigned) buf,
		len,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t sendmsg(int s, const struct msghdr *msg, int flags) {
	ssize_t result;
	unsigned args[] = {
		SENDMSG,
		(unsigned) &result,
		s,
		(unsigned) msg,
		flags
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int setenv(const char *name, const char *value, int overwrite) {
	unsigned args[] = {
		SETENV,
		(unsigned) name,
		(unsigned) value,
		overwrite
	};
	normal_call(args);
	typeof(setenv) *target_setenv = dlsym(RTLD_NEXT, "setenv");
	return target_setenv(name, value, overwrite);
}

char *setlocale(int category, const char *locale) {
	char *result;
	unsigned args[] = {
		SETLOCALE,
		(unsigned) &result,
		category,
		(unsigned) locale
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_sa_sigaction(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *handler_args = (unsigned *) syscall_result;
	for (;;) {
		void (*handler)(int, siginfo_t *, void *)
			= (void *) handler_args[0];
		int signum = handler_args[1];
		siginfo_t *info = (void *) handler_args[2];
		void *uc = (void *) handler_args[3];
		handler(signum, info, uc);
		emu_stub_return();
	}
}

__attribute__((weak))
int sigaction(int signum, const struct sigaction *act,
	struct sigaction *oldact) {
	int result;
	unsigned args[] = {
		SIGACTION,
		(unsigned) &result,
		signum,
		(unsigned) act,
		(unsigned) oldact
	};
	do_sa_sigaction(callback_call(args));
	return result;
}

__attribute__((weak))
int sigaltstack(const stack_t *ss, stack_t *oss) {
	int result;
	unsigned args[] = {
		SIGALTSTACK,
		(unsigned) &result,
		(unsigned) ss,
		(unsigned) oss
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_signal_handler(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *handler_args = (unsigned *) syscall_result;
	for (;;) {
		sighandler_t handler = (void *) handler_args[0];
		int signum = handler_args[1];
		handler(signum);
		emu_stub_return();
	}
}

__attribute__((weak))
sighandler_t signal(int signum, sighandler_t handler) {
	sighandler_t result;
	unsigned args[] = {
		SIGNAL,
		(unsigned) &result,
		signum,
		(unsigned) handler
	};
	do_signal_handler(callback_call(args));
	return result;
}

size_t strftime(char *s, size_t max, const char *format, const struct tm *tm) {
	size_t result;
	unsigned args[] = {
		STRFTIME,
		(unsigned) &result,
		(unsigned) s,
		max,
		(unsigned) format,
		(unsigned) tm
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
char *textdomain(const char *domainname) {
	char *result;
	unsigned args[] = {
		TEXTDOMAIN,
		(unsigned) &result,
		(unsigned) domainname
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
int unsetenv(const char *name) {
	unsigned args[] = {
		UNSETENV,
		(unsigned) name
	};
	normal_call(args);
	typeof(unsetenv) *target_unsetenv = dlsym(RTLD_NEXT, "unsetenv");
	return target_unsetenv(name);
}

/*int vfprintf(FILE *stream, const char *format, va_list ap) {
	int result;
	char *buffer;
	unsigned args[] = {
		VFPRINTF_PRINT,
		(unsigned) &result,
		(unsigned) &buffer,
		(unsigned) format,
		(unsigned) ap
	};
	normal_call(args);
	fputs(buffer, stream);
	unsigned args2[] = {
		VFPRINTF_FREE,
		(unsigned) buffer
	};
	normal_call(args2);
	return result;
}*/

__attribute__((weak))
pid_t waitpid(pid_t pid, int *status, int options) {
	pid_t result;
	unsigned args[] = {
		WAITPID,
		(unsigned) &result,
		pid,
		(unsigned) status,
		options
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t write(int fd, const void *buf, size_t count) {
	ssize_t result;
	unsigned args[] = {
		WRITE,
		(unsigned) &result,
		fd,
		(unsigned) buf,
		count
	};
	normal_call(args);
	return result;
}

__attribute__((weak))
ssize_t writev(int fd, const struct iovec *iov, int iovcnt) {
	ssize_t result;
	unsigned args[] = {
		WRITEV,
		(unsigned) &result,
		fd,
		(unsigned) iov,
		iovcnt
	};
	normal_call(args);
	return result;
}

#define unimplemented_stub(s) \
void s(void) { \
	fprintf(stderr, "Unimplemented stub " #s "\n"); \
	exit(EXIT_FAILURE); \
}

unimplemented_stub(__close)
unimplemented_stub(__connect)
unimplemented_stub(__fcntl)
__attribute__((weak))
void flockfile(FILE *filehandle) {
//	fprintf(stderr, "Unimplemented stub flockfile\n");
//	exit(EXIT_FAILURE);
//	if (filehandle) {}
//	fprintf(stderr, "stub flockfile\n");
	typeof(flockfile) *target_flockfile = dlsym(RTLD_NEXT, "flockfile");
	return target_flockfile(filehandle);
}
unimplemented_stub(__fork)
int ftrylockfile(FILE *filehandle) {
	fprintf(stderr, "Unimplemented stub ftrylockfile\n");
	exit(EXIT_FAILURE);
	if (filehandle) {}
}
__attribute__((weak))
void funlockfile(FILE *filehandle) {
//	fprintf(stderr, "Unimplemented stub funlockfile\n");
//	exit(EXIT_FAILURE);
//	if (filehandle) {}
//	fprintf(stderr, "stub funlockfile\n");
	typeof(funlockfile) *target_funlockfile = dlsym(RTLD_NEXT,
		"funlockfile");
	return target_funlockfile(filehandle);
}
unimplemented_stub(__h_errno_location)
#undef _IO_flockfile
void _IO_flockfile(_IO_FILE *_fp) {
	fprintf(stderr, "Unimplemented stub _IO_flockfile\n");
	exit(EXIT_FAILURE);
	if (_fp) {}
}
#undef _IO_ftrylockfile
int _IO_ftrylockfile(_IO_FILE *_fp) {
	fprintf(stderr, "Unimplemented stub _IO_ftrylockfile\n");
	exit(EXIT_FAILURE);
	if (_fp) {}
}
#undef _IO_funlockfile
void _IO_funlockfile(_IO_FILE *_fp) {
	fprintf(stderr, "Unimplemented stub _IO_funlockfile\n");
	exit(EXIT_FAILURE);
	if (_fp) {}
}
unimplemented_stub(__libc_allocate_rtsig)
int __libc_current_sigrtmax(void) {
	fprintf(stderr, "Unimplemented stub __libc_current_sigrtmax\n");
	exit(EXIT_FAILURE);
}
int __libc_current_sigrtmin(void) {
	fprintf(stderr, "Unimplemented stub __libc_current_sigrtmin\n");
	exit(EXIT_FAILURE);
}
unimplemented_stub(longjmp)
unimplemented_stub(__lseek)
unimplemented_stub(__nanosleep)
unimplemented_stub(__open)
unimplemented_stub(__open64)
int pause(void) {
	fprintf(stderr, "Unimplemented stub pause\n");
	exit(EXIT_FAILURE);
}
FILE *popen(const char *command, const char *type) {
//	fprintf(stderr, "Unimplemented stub popen\n");
//	exit(EXIT_FAILURE);
//	if (command || type) {}
//	fprintf(stderr, "stub popen\n");
	typeof(popen) *target_popen = dlsym(RTLD_NEXT, "popen");
	return target_popen(command, type);
}
ssize_t pread(int fd, void *buf, size_t count, off_t offset) {
	fprintf(stderr, "Unimplemented stub pread\n");
	exit(EXIT_FAILURE);
	if (fd || buf || count || offset) {}
}
ssize_t pread64(int fd, void *buf, size_t nbytes, __off64_t offset) {
	fprintf(stderr, "Unimplemented stub pread64\n");
	exit(EXIT_FAILURE);
	if (fd || buf || nbytes || offset) {}
}
unimplemented_stub(__pread64)
int pthread_setcancelstate(int state, int *oldstate) {
	fprintf(stderr, "Unimplemented stub pthread_setcancelstate\n");
	exit(EXIT_FAILURE);
	if (state || oldstate) {}
}
ssize_t pwrite(int fd, const void *buf, size_t count, off_t offset) {
	fprintf(stderr, "Unimplemented stub pwrite\n");
	exit(EXIT_FAILURE);
	if (fd || buf || count || offset) {}
}
ssize_t pwrite64(int fd, const void *buf, size_t n, __off64_t offset) {
	fprintf(stderr, "Unimplemented stub pwrite64\n");
	exit(EXIT_FAILURE);
	if (fd || buf || n || offset) {}
}
unimplemented_stub(__pwrite64)
int raise(int __sig) {
	fprintf(stderr, "Unimplemented stub raise\n");
	exit(EXIT_FAILURE);
	if (__sig) {}
}
unimplemented_stub(__read)
unimplemented_stub(__res_state)
unimplemented_stub(__send)
__attribute__((weak))
ssize_t sendto(int s, const void *buf, size_t len, int flags,
	const struct sockaddr *to, socklen_t tolen) {
	fprintf(stderr, "Unimplemented stub sendto\n");
	exit(EXIT_FAILURE);
	if (s || buf || len || flags || to || tolen) {}
}
unimplemented_stub(__sigaction)
unimplemented_stub(siglongjmp)
int sigwait(__const sigset_t *__restrict __set, int *__restrict __sig) {
	fprintf(stderr, "Unimplemented stub sigwait\n");
	exit(EXIT_FAILURE);
	if (__set || __sig) {}
}
int system(const char *command) {
	fprintf(stderr, "Unimplemented stub system\n");
	exit(EXIT_FAILURE);
	if (command) {}
}
unimplemented_stub(tcdrain)
pid_t vfork(void) {
	fprintf(stderr, "Unimplemented stub vfork\n");
	exit(EXIT_FAILURE);
}
unimplemented_stub(__vfork)
unimplemented_stub(wait)
unimplemented_stub(__wait)
unimplemented_stub(__write)
