#include <alsa/asoundlib.h>
#include <emu-stub/base.h>
#include <emu-stub/stub.h>

#include "libasound_const.h"

snd_config_t *snd_config;

int snd_card_get_index(const char *name) {
	int result;
	unsigned args[] = {
		SND_CARD_GET_INDEX,
		(unsigned) &result,
		(unsigned) name
	};
	normal_call(args);
	return result;
}

int snd_card_next(int *card) {
	int result;
	unsigned args[] = {
		SND_CARD_NEXT,
		(unsigned) &result,
		(unsigned) card
	};
	normal_call(args);
	return result;
}

int snd_config_get_integer(const snd_config_t *config, long *value) {
	int result;
	unsigned args[] = {
		SND_CONFIG_GET_INTEGER,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) value
	};
	normal_call(args);
	return result;
}

int snd_config_get_string(const snd_config_t *config, const char **value) {
	int result;
	unsigned args[] = {
		SND_CONFIG_GET_STRING,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) value
	};
	normal_call(args);
	return result;
}

snd_config_type_t snd_config_get_type(const snd_config_t *config) {
	snd_config_type_t result;
	unsigned args[] = {
		SND_CONFIG_GET_TYPE,
		(unsigned) &result,
		(unsigned) config
	};
	normal_call(args);
	return result;
}

snd_config_iterator_t snd_config_iterator_end(const snd_config_t *node) {
	snd_config_iterator_t result;
	unsigned args[] = {
		SND_CONFIG_ITERATOR_END,
		(unsigned) &result,
		(unsigned) node
	};
	normal_call(args);
	return result;
}

snd_config_t *snd_config_iterator_entry(const snd_config_iterator_t iterator) {
	snd_config_t *result;
	unsigned args[] = {
		SND_CONFIG_ITERATOR_ENTRY,
		(unsigned) &result,
		(unsigned) iterator
	};
	normal_call(args);
	return result;
}

snd_config_iterator_t snd_config_iterator_first(const snd_config_t *node) {
	snd_config_iterator_t result;
	unsigned args[] = {
		SND_CONFIG_ITERATOR_FIRST,
		(unsigned) &result,
		(unsigned) node
	};
	normal_call(args);
	return result;
}

snd_config_iterator_t snd_config_iterator_next(
	const snd_config_iterator_t iterator) {
	snd_config_iterator_t result;
	unsigned args[] = {
		SND_CONFIG_ITERATOR_NEXT,
		(unsigned) &result,
		(unsigned) iterator
	};
	normal_call(args);
	return result;
}

int snd_config_search(snd_config_t *config, const char *key,
	snd_config_t **_result) {
	int result;
	unsigned args[] = {
		SND_CONFIG_SEARCH,
		(unsigned) &result,
		(unsigned) config,
		(unsigned) key,
		(unsigned) _result
	};
	normal_call(args);
	return result;
}

int snd_config_update(void) {
	int result;
	unsigned args[] = {
		SND_CONFIG_UPDATE,
		(unsigned) &result,
		(unsigned) &snd_config
	};
	normal_call(args);
	return result;
}

int snd_config_update_free_global(void) {
	int result;
	unsigned args[] = {
		SND_CONFIG_UPDATE_FREE_GLOBAL,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_ctl_card_info(snd_ctl_t *ctl, snd_ctl_card_info_t *info) {
	int result;
	unsigned args[] = {
		SND_CTL_CARD_INFO,
		(unsigned) &result,
		(unsigned) ctl,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

const char *snd_ctl_card_info_get_id(const snd_ctl_card_info_t *obj) {
	const char *result;
	unsigned args[] = {
		SND_CTL_CARD_INFO_GET_ID,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

const char *snd_ctl_card_info_get_name(const snd_ctl_card_info_t *obj) {
	const char *result;
	unsigned args[] = {
		SND_CTL_CARD_INFO_GET_NAME,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

size_t snd_ctl_card_info_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_CTL_CARD_INFO_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_ctl_close(snd_ctl_t *ctl) {
	int result;
	unsigned args[] = {
		SND_CTL_CLOSE,
		(unsigned) &result,
		(unsigned) ctl
	};
	normal_call(args);
	return result;
}

void snd_ctl_elem_id_clear(snd_ctl_elem_id_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_ID_CLEAR,
		(unsigned) obj
	};
	normal_call(args);
}

void snd_ctl_elem_id_free(snd_ctl_elem_id_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_ID_FREE,
		(unsigned) obj
	};
	normal_call(args);
}

int snd_ctl_elem_id_malloc(snd_ctl_elem_id_t **ptr) {
	int result;
	unsigned args[] = {
		SND_CTL_ELEM_ID_MALLOC,
		(unsigned) &result,
		(unsigned) ptr
	};
	normal_call(args);
	return result;
}

void snd_ctl_elem_id_set_interface(snd_ctl_elem_id_t *obj,
	snd_ctl_elem_iface_t val) {
	unsigned args[] = {
		SND_CTL_ELEM_ID_SET_INTERFACE,
		(unsigned) obj,
		val
	};
	normal_call(args);
}

void snd_ctl_elem_id_set_name(snd_ctl_elem_id_t *obj, const char *val) {
	unsigned args[] = {
		SND_CTL_ELEM_ID_SET_NAME,
		(unsigned) obj,
		(unsigned) val
	};
	normal_call(args);
}

void snd_ctl_elem_info_clear(snd_ctl_elem_info_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_INFO_CLEAR,
		(unsigned) obj
	};
	normal_call(args);
}

void snd_ctl_elem_info_free(snd_ctl_elem_info_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_INFO_FREE,
		(unsigned) obj
	};
	normal_call(args);
}

unsigned int snd_ctl_elem_info_get_count(const snd_ctl_elem_info_t *obj) {
	unsigned int result;
	unsigned args[] = {
		SND_CTL_ELEM_INFO_GET_COUNT,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

long snd_ctl_elem_info_get_max(const snd_ctl_elem_info_t *obj) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_info_get_max\n");
	exit(EXIT_FAILURE);
	if (obj) {}
}

long snd_ctl_elem_info_get_min(const snd_ctl_elem_info_t *obj) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_info_get_min\n");
	exit(EXIT_FAILURE);
	if (obj) {}
}

long snd_ctl_elem_info_get_step(const snd_ctl_elem_info_t *obj) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_info_get_step\n");
	exit(EXIT_FAILURE);
	if (obj) {}
}

int snd_ctl_elem_info_is_readable(const snd_ctl_elem_info_t *obj) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_info_is_readable\n");
	exit(EXIT_FAILURE);
	if (obj) {}
}

int snd_ctl_elem_info_malloc(snd_ctl_elem_info_t **ptr) {
	int result;
	unsigned args[] = {
		SND_CTL_ELEM_INFO_MALLOC,
		(unsigned) &result,
		(unsigned) ptr
	};
	normal_call(args);
	return result;
}

void snd_ctl_elem_value_clear(snd_ctl_elem_value_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_VALUE_CLEAR,
		(unsigned) obj
	};
	normal_call(args);
}

void snd_ctl_elem_value_free(snd_ctl_elem_value_t *obj) {
	unsigned args[] = {
		SND_CTL_ELEM_VALUE_FREE,
		(unsigned) obj
	};
	normal_call(args);
}

long snd_ctl_elem_value_get_integer(const snd_ctl_elem_value_t *obj,
	unsigned int idx) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_value_get_integer\n");
	exit(EXIT_FAILURE);
	if (obj || idx) {}
}

int snd_ctl_elem_value_malloc(snd_ctl_elem_value_t **ptr) {
	int result;
	unsigned args[] = {
		SND_CTL_ELEM_VALUE_MALLOC,
		(unsigned) &result,
		(unsigned) ptr
	};
	normal_call(args);
	return result;
}

void snd_ctl_elem_value_set_integer(snd_ctl_elem_value_t *obj, unsigned int idx,
	long val) {
	fprintf(stderr, "Unimplemented stub snd_ctl_elem_value_set_integer\n");
	exit(EXIT_FAILURE);
	if (obj || idx || val) {}
}

const char *snd_ctl_name(snd_ctl_t *ctl) {
	const char *result;
	unsigned args[] = {
		SND_CTL_NAME,
		(unsigned) &result,
		(unsigned) ctl
	};
	normal_call(args);
	return result;
}

int snd_ctl_open(snd_ctl_t **ctl, const char *name, int mode) {
	int result;
	unsigned args[] = {
		SND_CTL_OPEN,
		(unsigned) &result,
		(unsigned) ctl,
		(unsigned) name,
		mode
	};
	normal_call(args);
	return result;
}

int snd_ctl_pcm_info(snd_ctl_t *ctl, snd_pcm_info_t *info) {
	int result;
	unsigned args[] = {
		SND_CTL_PCM_INFO,
		(unsigned) &result,
		(unsigned) ctl,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

int snd_ctl_pcm_next_device(snd_ctl_t *ctl, int *device) {
	int result;
	unsigned args[] = {
		SND_CTL_PCM_NEXT_DEVICE,
		(unsigned) &result,
		(unsigned) ctl,
		(unsigned) device
	};
	normal_call(args);
	return result;
}

int snd_hctl_close(snd_hctl_t *hctl) {
	int result;
	unsigned args[] = {
		SND_HCTL_CLOSE,
		(unsigned) &result,
		(unsigned) hctl
	};
	normal_call(args);
	return result;
}

int snd_hctl_elem_info(snd_hctl_elem_t *elem, snd_ctl_elem_info_t *info) {
	int result;
	unsigned args[] = {
		SND_HCTL_ELEM_INFO,
		(unsigned) &result,
		(unsigned) elem,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

int snd_hctl_elem_read(snd_hctl_elem_t *elem, snd_ctl_elem_value_t *value) {
	fprintf(stderr, "Unimplemented stub snd_hctl_elem_read\n");
	exit(EXIT_FAILURE);
	if (elem || value) {}
}

int snd_hctl_elem_write(snd_hctl_elem_t *elem, snd_ctl_elem_value_t *value) {
	fprintf(stderr, "Unimplemented stub snd_hctl_elem_write\n");
	exit(EXIT_FAILURE);
	if (elem || value) {}
}

snd_hctl_elem_t *snd_hctl_find_elem(snd_hctl_t *hctl,
	const snd_ctl_elem_id_t *id) {
	snd_hctl_elem_t *result;
	unsigned args[] = {
		SND_HCTL_FIND_ELEM,
		(unsigned) &result,
		(unsigned) hctl,
		(unsigned) id
	};
	normal_call(args);
	return result;
}

int snd_hctl_free(snd_hctl_t *hctl) {
	int result;
	unsigned args[] = {
		SND_HCTL_FREE,
		(unsigned) &result,
		(unsigned) hctl
	};
	normal_call(args);
	return result;
}

int snd_hctl_load(snd_hctl_t *hctl) {
	int result;
	unsigned args[] = {
		SND_HCTL_LOAD,
		(unsigned) &result,
		(unsigned) hctl
	};
	normal_call(args);
	return result;
}

int snd_hctl_open(snd_hctl_t **hctl, const char *name, int mode) {
	int result;
	unsigned args[] = {
		SND_HCTL_OPEN,
		(unsigned) &result,
		(unsigned) hctl,
		(unsigned) name,
		mode
	};
	normal_call(args);
	return result;
}

int snd_mixer_attach(snd_mixer_t *mixer, const char *name) {
	int result;
	unsigned args[] = {
		SND_MIXER_ATTACH,
		(unsigned) &result,
		(unsigned) mixer,
		(unsigned) name
	};
	normal_call(args);
	return result;
}

int snd_mixer_close(snd_mixer_t *mixer) {
	int result;
	unsigned args[] = {
		SND_MIXER_CLOSE,
		(unsigned) &result,
		(unsigned) mixer
	};
	normal_call(args);
	return result;
}

void *snd_mixer_elem_get_callback_private(const snd_mixer_elem_t *obj) {
	void *result;
	unsigned args[] = {
		SND_MIXER_ELEM_GET_CALLBACK_PRIVATE,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

snd_mixer_elem_t *snd_mixer_elem_next(snd_mixer_elem_t *elem) {
	snd_mixer_elem_t *result;
	unsigned args[] = {
		SND_MIXER_ELEM_NEXT,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_elem_callback(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	for (;;) {
		int (*elem_callback)(snd_mixer_elem_t *, unsigned int)
			= (void *) callback_args[0];
		snd_mixer_elem_t *elem = (void *) callback_args[1];
		unsigned int mask = callback_args[2];
		int result = elem_callback(elem, mask);
		callback_args[0] = result;
		emu_stub_return();
	}
}

void snd_mixer_elem_set_callback(snd_mixer_elem_t *obj,
	snd_mixer_elem_callback_t val) {
	unsigned args[] = {
		SND_MIXER_ELEM_SET_CALLBACK,
		(unsigned) obj,
		(unsigned) val
	};
	do_elem_callback(callback_call(args));
	normal_call(args);
}

void snd_mixer_elem_set_callback_private(snd_mixer_elem_t *obj, void *val) {
	unsigned args[] = {
		SND_MIXER_ELEM_SET_CALLBACK_PRIVATE,
		(unsigned) obj,
		(unsigned) val
	};
	normal_call(args);
}

snd_mixer_elem_t *snd_mixer_first_elem(snd_mixer_t *mixer) {
	snd_mixer_elem_t *result;
	unsigned args[] = {
		SND_MIXER_FIRST_ELEM,
		(unsigned) &result,
		(unsigned) mixer
	};
	normal_call(args);
	return result;
}

int snd_mixer_handle_events(snd_mixer_t *mixer) {
	fprintf(stderr, "Unimplemented stub snd_mixer_handle_events\n");
	exit(EXIT_FAILURE);
	if (mixer) {}
}

int snd_mixer_load(snd_mixer_t *mixer) {
	int result;
	unsigned args[] = {
		SND_MIXER_LOAD,
		(unsigned) &result,
		(unsigned) mixer
	};
	normal_call(args);
	return result;
}

int snd_mixer_open(snd_mixer_t **mixer, int mode) {
	int result;
	unsigned args[] = {
		SND_MIXER_OPEN,
		(unsigned) &result,
		(unsigned) mixer,
		mode
	};
	normal_call(args);
	return result;
}

int snd_mixer_poll_descriptors(snd_mixer_t *mixer, struct pollfd *pfds,
	unsigned int space) {
	fprintf(stderr, "Unimplemented stub snd_mixer_poll_descriptors\n");
	exit(EXIT_FAILURE);
	if (mixer || pfds || space) {}
}

int snd_mixer_poll_descriptors_count(snd_mixer_t *mixer) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_poll_descriptors_count\n");
	exit(EXIT_FAILURE);
	if (mixer) {}
}

int snd_mixer_selem_get_capture_switch(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, int *value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_get_capture_switch\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_get_capture_volume(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, long *value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_get_capture_volume\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_get_capture_volume_range(snd_mixer_elem_t *elem, long *min,
	long *max) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_GET_CAPTURE_VOLUME_RANGE,
		(unsigned) &result,
		(unsigned) elem,
		(unsigned) min,
		(unsigned) max
	};
	normal_call(args);
	return result;
}

const char *snd_mixer_selem_get_name(snd_mixer_elem_t *elem) {
	const char *result;
	unsigned args[] = {
		SND_MIXER_SELEM_GET_NAME,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_get_playback_switch(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, int *value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_get_playback_switch\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_get_playback_volume(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, long *value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_get_playback_volume\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_get_playback_volume_range(snd_mixer_elem_t *elem, long *min,
	long *max) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_GET_PLAYBACK_VOLUME_RANGE,
		(unsigned) &result,
		(unsigned) elem,
		(unsigned) min,
		(unsigned) max
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_capture_channel(snd_mixer_elem_t *obj,
	snd_mixer_selem_channel_id_t channel) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_CAPTURE_CHANNEL,
		(unsigned) &result,
		(unsigned) obj,
		channel
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_capture_switch(snd_mixer_elem_t *elem) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_CAPTURE_SWITCH,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_capture_switch_exclusive(snd_mixer_elem_t *elem) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_CAPTURE_SWITCH_EXCLUSIVE,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_capture_volume(snd_mixer_elem_t *elem) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_CAPTURE_VOLUME,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_playback_channel(snd_mixer_elem_t *obj,
	snd_mixer_selem_channel_id_t channel) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_PLAYBACK_CHANNEL,
		(unsigned) &result,
		(unsigned) obj,
		channel
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_playback_switch(snd_mixer_elem_t *elem) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_PLAYBACK_SWITCH,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_has_playback_volume(snd_mixer_elem_t *elem) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_HAS_PLAYBACK_VOLUME,
		(unsigned) &result,
		(unsigned) elem
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_register(snd_mixer_t *mixer,
	struct snd_mixer_selem_regopt *options, snd_mixer_class_t **classp) {
	int result;
	unsigned args[] = {
		SND_MIXER_SELEM_REGISTER,
		(unsigned) &result,
		(unsigned) mixer,
		(unsigned) options,
		(unsigned) classp
	};
	normal_call(args);
	return result;
}

int snd_mixer_selem_set_capture_switch(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, int value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_set_capture_switch\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_set_capture_volume(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, long value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_set_capture_volume\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_set_playback_switch(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, int value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_set_playback_switch\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_mixer_selem_set_playback_volume(snd_mixer_elem_t *elem,
	snd_mixer_selem_channel_id_t channel, long value) {
	fprintf(stderr,
		"Unimplemented stub snd_mixer_selem_set_playback_volume\n");
	exit(EXIT_FAILURE);
	if (elem || channel || value) {}
}

int snd_output_close(snd_output_t *output) {
	int result;
	unsigned args[] = {
		SND_OUTPUT_CLOSE,
		(unsigned) &result,
		(unsigned) output
	};
	normal_call(args);
	return result;
}

int snd_output_stdio_attach(snd_output_t **outputp, FILE *fp, int _close) {
	int result;
	unsigned args[] = {
		SND_OUTPUT_STDIO_ATTACH,
		(unsigned) &result,
		(unsigned) outputp,
		(unsigned) fp,
		_close
	};
	normal_call(args);
	return result;
}

size_t snd_pcm_access_mask_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_PCM_ACCESS_MASK_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_pcm_access_mask_test(const snd_pcm_access_mask_t *mask,
	snd_pcm_access_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_ACCESS_MASK_TEST,
		(unsigned) &result,
		(unsigned) mask,
		val
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_access_name(const snd_pcm_access_t _access) {
	fprintf(stderr, "Unimplemented stub snd_pcm_access_name\n");
	exit(EXIT_FAILURE);
	if (_access) {}
}

snd_pcm_sframes_t snd_pcm_avail_update(snd_pcm_t *pcm) {
	snd_pcm_sframes_t result;
	unsigned args[] = {
		SND_PCM_AVAIL_UPDATE,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

snd_pcm_sframes_t snd_pcm_bytes_to_frames(snd_pcm_t *pcm, ssize_t bytes) {
	snd_pcm_sframes_t result;
	unsigned args[] = {
		SND_PCM_BYTES_TO_FRAMES,
		(unsigned) &result,
		(unsigned) pcm,
		bytes
	};
	normal_call(args);
	return result;
}

int snd_pcm_close(snd_pcm_t *pcm) {
	int result;
	unsigned args[] = {
		SND_PCM_CLOSE,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

int snd_pcm_delay(snd_pcm_t *pcm, snd_pcm_sframes_t *delayp) {
	int result;
	unsigned args[] = {
		SND_PCM_DELAY,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) delayp
	};
	normal_call(args);
	return result;
}

int snd_pcm_drain(snd_pcm_t *pcm) {
	int result;
	unsigned args[] = {
		SND_PCM_DRAIN,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

int snd_pcm_drop(snd_pcm_t *pcm) {
	int result;
	unsigned args[] = {
		SND_PCM_DROP,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_format_description(const snd_pcm_format_t format) {
	const char *result;
	unsigned args[] = {
		SND_PCM_FORMAT_DESCRIPTION,
		(unsigned) &result,
		format
	};
	normal_call(args);
	return result;
}

size_t snd_pcm_format_mask_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_PCM_FORMAT_MASK_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_pcm_format_mask_test(const snd_pcm_format_mask_t *mask,
	snd_pcm_format_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_FORMAT_MASK_TEST,
		(unsigned) &result,
		(unsigned) mask,
		val
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_format_name(const snd_pcm_format_t format) {
	const char *result;
	unsigned args[] = {
		SND_PCM_FORMAT_NAME,
		(unsigned) &result,
		format
	};
	normal_call(args);
	return result;
}

int snd_pcm_format_physical_width(snd_pcm_format_t format) {
	int result;
	unsigned args[] = {
		SND_PCM_FORMAT_PHYSICAL_WIDTH,
		(unsigned) &result,
		format
	};
	normal_call(args);
	return result;
}

int snd_pcm_format_set_silence(snd_pcm_format_t format, void *buf,
	unsigned int samples) {
	int result;
	unsigned args[] = {
		SND_PCM_FORMAT_SET_SILENCE,
		(unsigned) &result,
		format,
		(unsigned) buf,
		samples
	};
	normal_call(args);
	return result;
}

snd_pcm_sframes_t snd_pcm_forward(snd_pcm_t *pcm, snd_pcm_uframes_t frames) {
	fprintf(stderr, "Unimplemented stub snd_pcm_forward\n");
	exit(EXIT_FAILURE);
	if (pcm || frames) {}
}

ssize_t snd_pcm_frames_to_bytes(snd_pcm_t *pcm, snd_pcm_sframes_t frames) {
	ssize_t result;
	unsigned args[] = {
		SND_PCM_FRAMES_TO_BYTES,
		(unsigned) &result,
		(unsigned) pcm,
		frames
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params(snd_pcm_t *pcm, snd_pcm_hw_params_t *params) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_any(snd_pcm_t *pcm, snd_pcm_hw_params_t *params) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_ANY,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_can_mmap_sample_resolution(
	const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub "
		"snd_pcm_hw_params_can_mmap_sample_resolution\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_can_overrange(const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_can_overrange\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_can_pause(const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_can_pause\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_can_resume(const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_can_resume\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_can_sync_start(const snd_pcm_hw_params_t *params) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_can_sync_start\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

void snd_pcm_hw_params_copy(snd_pcm_hw_params_t *dst,
	const snd_pcm_hw_params_t *src) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_copy\n");
	exit(EXIT_FAILURE);
	if (dst || src) {}
}

int snd_pcm_hw_params_current(snd_pcm_t *pcm, snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_current\n");
	exit(EXIT_FAILURE);
	if (pcm || params) {}
}

void snd_pcm_hw_params_free(snd_pcm_hw_params_t *obj) {
	unsigned args[] = {
		SND_PCM_HW_PARAMS_FREE,
		(unsigned) obj
	};
	normal_call(args);
}

int snd_pcm_hw_params_get_access(const snd_pcm_hw_params_t *params,
	snd_pcm_access_t *_access) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_access\n");
	exit(EXIT_FAILURE);
	if (params || _access) {}
}

int snd_pcm_hw_params_get_access_mask(snd_pcm_hw_params_t *params,
	snd_pcm_access_mask_t *mask) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_ACCESS_MASK,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) mask
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_buffer_size(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *val) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_BUFFER_SIZE,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_buffer_size_max(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *val) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_buffer_size_max\n");
	exit(EXIT_FAILURE);
	if (params || val) {}
}

int snd_pcm_hw_params_get_buffer_size_min(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *val) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_buffer_size_min\n");
	exit(EXIT_FAILURE);
	if (params || val) {}
}

int snd_pcm_hw_params_get_buffer_time(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_buffer_time\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_buffer_time_max(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_BUFFER_TIME_MAX,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_buffer_time_min(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_buffer_time_min\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_channels(const snd_pcm_hw_params_t *params,
	unsigned int *val) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_channels\n");
	exit(EXIT_FAILURE);
	if (params || val) {}
}

int snd_pcm_hw_params_get_channels_max(const snd_pcm_hw_params_t *params,
	unsigned int *val) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_CHANNELS_MAX,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_channels_min(const snd_pcm_hw_params_t *params,
	unsigned int *val) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_CHANNELS_MIN,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_format(const snd_pcm_hw_params_t *params,
	snd_pcm_format_t *val) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_format\n");
	exit(EXIT_FAILURE);
	if (params || val) {}
}

void snd_pcm_hw_params_get_format_mask(snd_pcm_hw_params_t *params,
	snd_pcm_format_mask_t *mask) {
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_FORMAT_MASK,
		(unsigned) params,
		(unsigned) mask
	};
	normal_call(args);
}

int snd_pcm_hw_params_get_period_size(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *frames, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_PERIOD_SIZE,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) frames,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_period_size_max(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *frames, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_period_size_max\n");
	exit(EXIT_FAILURE);
	if (params || frames || dir) {}
}

int snd_pcm_hw_params_get_period_size_min(const snd_pcm_hw_params_t *params,
	snd_pcm_uframes_t *frames, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_period_size_min\n");
	exit(EXIT_FAILURE);
	if (params || frames || dir) {}
}

int snd_pcm_hw_params_get_period_time(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_PERIOD_TIME,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_period_time_max(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_period_time_max\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_period_time_min(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_period_time_min\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_periods(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_periods\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_periods_max(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_periods_max\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_periods_min(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_periods_min\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_rate(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_rate\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_rate_max(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_RATE_MAX,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_rate_min(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_GET_RATE_MIN,
		(unsigned) &result,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_get_tick_time(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_get_tick_time\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_tick_time_max(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_tick_time_max\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_get_tick_time_min(const snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_get_tick_time_min\n");
	exit(EXIT_FAILURE);
	if (params || val || dir) {}
}

int snd_pcm_hw_params_is_batch(const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_is_batch\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_is_block_transfer(const snd_pcm_hw_params_t *params) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_is_block_transfer\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_is_double(const snd_pcm_hw_params_t *params) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hw_params_is_double\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_is_half_duplex(const snd_pcm_hw_params_t *params) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_is_half_duplex\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_is_joint_duplex(const snd_pcm_hw_params_t *params) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_is_joint_duplex\n");
	exit(EXIT_FAILURE);
	if (params) {}
}

int snd_pcm_hw_params_malloc(snd_pcm_hw_params_t **ptr) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_MALLOC,
		(unsigned) &result,
		(unsigned) ptr
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_access(snd_pcm_t *pcm, snd_pcm_hw_params_t *params,
	snd_pcm_access_t _access) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_ACCESS,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		_access
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_buffer_size_near(snd_pcm_t *pcm,
	snd_pcm_hw_params_t *params, snd_pcm_uframes_t *val) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_set_buffer_size_near\n");
	exit(EXIT_FAILURE);
	if (pcm || params || val) {}
}

int snd_pcm_hw_params_set_buffer_time_near(snd_pcm_t *pcm,
	snd_pcm_hw_params_t *params, unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_BUFFER_TIME_NEAR,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_channels(snd_pcm_t *pcm, snd_pcm_hw_params_t *params,
	unsigned int val) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_CHANNELS,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_format(snd_pcm_t *pcm, snd_pcm_hw_params_t *params,
	snd_pcm_format_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_FORMAT,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_period_time_near(snd_pcm_t *pcm,
	snd_pcm_hw_params_t *params, unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_PERIOD_TIME_NEAR,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_periods_integer(snd_pcm_t *pcm,
	snd_pcm_hw_params_t *params) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_set_periods_integer\n");
	exit(EXIT_FAILURE);
	if (pcm || params) {}
}

int snd_pcm_hw_params_set_rate_near(snd_pcm_t *pcm, snd_pcm_hw_params_t *params,
	unsigned int *val, int *dir) {
	int result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SET_RATE_NEAR,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		(unsigned) val,
		(unsigned) dir
	};
	normal_call(args);
	return result;
}

int snd_pcm_hw_params_set_rate_resample(snd_pcm_t *pcm,
	snd_pcm_hw_params_t *params, unsigned int val) {
	fprintf(stderr,
		"Unimplemented stub snd_pcm_hw_params_set_rate_resample\n");
	exit(EXIT_FAILURE);
	if (pcm || params || val) {}
}

size_t snd_pcm_hw_params_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_PCM_HW_PARAMS_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_pcm_hwsync(snd_pcm_t *pcm) {
	fprintf(stderr, "Unimplemented stub snd_pcm_hwsync\n");
	exit(EXIT_FAILURE);
	if (pcm) {}
}

int snd_pcm_info(snd_pcm_t *pcm, snd_pcm_info_t *info) {
	int result;
	unsigned args[] = {
		SND_PCM_INFO,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_info_get_id(const snd_pcm_info_t *obj) {
	const char *result;
	unsigned args[] = {
		SND_PCM_INFO_GET_ID,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_info_get_name(const snd_pcm_info_t *obj) {
	const char *result;
	unsigned args[] = {
		SND_PCM_INFO_GET_NAME,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_info_get_subdevice_name(const snd_pcm_info_t *obj) {
	const char *result;
	unsigned args[] = {
		SND_PCM_INFO_GET_SUBDEVICE_NAME,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

unsigned int snd_pcm_info_get_subdevices_avail(const snd_pcm_info_t *obj) {
	unsigned int result;
	unsigned args[] = {
		SND_PCM_INFO_GET_SUBDEVICES_AVAIL,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

unsigned int snd_pcm_info_get_subdevices_count(const snd_pcm_info_t *obj) {
	unsigned int result;
	unsigned args[] = {
		SND_PCM_INFO_GET_SUBDEVICES_COUNT,
		(unsigned) &result,
		(unsigned) obj
	};
	normal_call(args);
	return result;
}

void snd_pcm_info_set_device(snd_pcm_info_t *obj, unsigned int val) {
	unsigned args[] = {
		SND_PCM_INFO_SET_DEVICE,
		(unsigned) obj,
		val
	};
	normal_call(args);
}

void snd_pcm_info_set_stream(snd_pcm_info_t *obj, snd_pcm_stream_t val) {
	unsigned args[] = {
		SND_PCM_INFO_SET_STREAM,
		(unsigned) obj,
		val
	};
	normal_call(args);
}

void snd_pcm_info_set_subdevice(snd_pcm_info_t *obj, unsigned int val) {
	unsigned args[] = {
		SND_PCM_INFO_SET_SUBDEVICE,
		(unsigned) obj,
		val
	};
	normal_call(args);
}

size_t snd_pcm_info_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_PCM_INFO_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_pcm_mmap_begin(snd_pcm_t *pcm, const snd_pcm_channel_area_t **areas,
	snd_pcm_uframes_t *offset, snd_pcm_uframes_t *frames) {
	fprintf(stderr, "Unimplemented stub snd_pcm_mmap_begin\n");
	exit(EXIT_FAILURE);
	if (pcm || areas || offset || frames) {}
}

snd_pcm_sframes_t snd_pcm_mmap_commit(snd_pcm_t *pcm, snd_pcm_uframes_t offset,
	snd_pcm_uframes_t frames) {
	fprintf(stderr, "Unimplemented stub snd_pcm_mmap_commit\n");
	exit(EXIT_FAILURE);
	if (pcm || offset || frames) {}
}

snd_pcm_sframes_t snd_pcm_mmap_readi(snd_pcm_t *pcm, void *buffer,
	snd_pcm_uframes_t size) {
	fprintf(stderr, "Unimplemented stub snd_pcm_mmap_readi\n");
	exit(EXIT_FAILURE);
	if (pcm || buffer || size) {}
}

snd_pcm_sframes_t snd_pcm_mmap_writei(snd_pcm_t *pcm, const void *buffer,
	snd_pcm_uframes_t size) {
	snd_pcm_sframes_t result;
	unsigned args[] = {
		SND_PCM_MMAP_WRITEI,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) buffer,
		size
	};
	normal_call(args);
	return result;
}

int snd_pcm_nonblock(snd_pcm_t *pcm, int nonblock) {
	int result;
	unsigned args[] = {
		SND_PCM_NONBLOCK__FUNCTION,
		(unsigned) &result,
		(unsigned) pcm,
		nonblock
	};
	normal_call(args);
	return result;
}

int snd_pcm_open(snd_pcm_t **pcm, const char *name, snd_pcm_stream_t stream,
	int mode) {
	int result;
	unsigned args[] = {
		SND_PCM_OPEN,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) name,
		stream,
		mode
	};
	normal_call(args);
	return result;
}

int snd_pcm_pause(snd_pcm_t *pcm, int enable) {
	fprintf(stderr, "Unimplemented stub snd_pcm_pause\n");
	exit(EXIT_FAILURE);
	if (pcm || enable) {}
}

int snd_pcm_prepare(snd_pcm_t *pcm) {
	int result;
	unsigned args[] = {
		SND_PCM_PREPARE,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

snd_pcm_sframes_t snd_pcm_readi(snd_pcm_t *pcm, void *buffer,
	snd_pcm_uframes_t size) {
	snd_pcm_sframes_t result;
	unsigned args[] = {
		SND_PCM_READI,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) buffer,
		size
	};
	normal_call(args);
	return result;
}

int snd_pcm_start(snd_pcm_t *pcm) {
	int result;
	unsigned args[] = {
		SND_PCM_START,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

snd_pcm_state_t snd_pcm_state(snd_pcm_t *pcm) {
	snd_pcm_state_t result;
	unsigned args[] = {
		SND_PCM_STATE,
		(unsigned) &result,
		(unsigned) pcm
	};
	normal_call(args);
	return result;
}

const char *snd_pcm_stream_name(const snd_pcm_stream_t stream) {
	const char *result;
	unsigned args[] = {
		SND_PCM_STREAM_NAME,
		(unsigned) &result,
		stream
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params(snd_pcm_t *pcm, snd_pcm_sw_params_t *params) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_current(snd_pcm_t *pcm, snd_pcm_sw_params_t *params) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_CURRENT,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_get_boundary(const snd_pcm_sw_params_t *params,
	snd_pcm_uframes_t *val) {
	fprintf(stderr, "Unimplemented stub snd_pcm_sw_params_get_boundary\n");
	exit(EXIT_FAILURE);
	if (params || val) {}
}

int snd_pcm_sw_params_set_avail_min(snd_pcm_t *pcm, snd_pcm_sw_params_t *params,
	snd_pcm_uframes_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_AVAIL_MIN,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_set_silence_size(snd_pcm_t *pcm,
	snd_pcm_sw_params_t *params, snd_pcm_uframes_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_SILENCE_SIZE,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_set_silence_threshold(snd_pcm_t *pcm,
	snd_pcm_sw_params_t *params, snd_pcm_uframes_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_SILENCE_THRESHOLD,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_set_start_threshold(snd_pcm_t *pcm,
	snd_pcm_sw_params_t *params, snd_pcm_uframes_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_START_THRESHOLD,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

int snd_pcm_sw_params_set_stop_threshold(snd_pcm_t *pcm,
	snd_pcm_sw_params_t *params, snd_pcm_uframes_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_STOP_THRESHOLD,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

__attribute__((deprecated))
int snd_pcm_sw_params_set_xfer_align(__attribute__((unused)) snd_pcm_t *pcm,
	__attribute__((unused)) snd_pcm_sw_params_t *params,
	__attribute__((unused)) snd_pcm_uframes_t val) {
	return 0;
}

__attribute__((deprecated))
int snd_pcm_sw_params_set_xrun_mode(snd_pcm_t *pcm, snd_pcm_sw_params_t *params,
	snd_pcm_xrun_t val) {
	int result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SET_XRUN_MODE,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) params,
		val
	};
	normal_call(args);
	return result;
}

size_t snd_pcm_sw_params_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_PCM_SW_PARAMS_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

snd_pcm_type_t snd_pcm_type(snd_pcm_t *pcm) {
	fprintf(stderr, "Unimplemented stub snd_pcm_type\n");
	exit(EXIT_FAILURE);
	if (pcm) {}
}

int snd_pcm_wait(snd_pcm_t *pcm, int timeout) {
	int result;
	unsigned args[] = {
		SND_PCM_WAIT,
		(unsigned) &result,
		(unsigned) pcm,
		timeout
	};
	normal_call(args);
	return result;
}

snd_pcm_sframes_t snd_pcm_writei(snd_pcm_t *pcm, const void *buffer,
	snd_pcm_uframes_t size) {
	snd_pcm_sframes_t result;
	unsigned args[] = {
		SND_PCM_WRITEI,
		(unsigned) &result,
		(unsigned) pcm,
		(unsigned) buffer,
		size
	};
	normal_call(args);
	return result;
}

int snd_seq_client_info_get_client(const snd_seq_client_info_t *info) {
	int result;
	unsigned args[] = {
		SND_SEQ_CLIENT_INFO_GET_CLIENT,
		(unsigned) &result,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

const char *snd_seq_client_info_get_name(snd_seq_client_info_t *info) {
	const char *result;
	unsigned args[] = {
		SND_SEQ_CLIENT_INFO_GET_NAME,
		(unsigned) &result,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

snd_seq_client_type_t snd_seq_client_info_get_type(
	const snd_seq_client_info_t *info) {
	fprintf(stderr, "Unimplemented stub snd_seq_client_info_get_type\n");
	exit(EXIT_FAILURE);
	if (info) {}
}

void snd_seq_client_info_set_client(snd_seq_client_info_t *info, int client) {
	unsigned args[] = {
		SND_SEQ_CLIENT_INFO_SET_CLIENT,
		(unsigned) info,
		client
	};
	normal_call(args);
}

size_t snd_seq_client_info_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_SEQ_CLIENT_INFO_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_seq_close(snd_seq_t *handle) {
	int result;
	unsigned args[] = {
		SND_SEQ_CLOSE,
		(unsigned) &result,
		(unsigned) handle
	};
	normal_call(args);
	return result;
}

int snd_seq_connect_from(snd_seq_t *seq, int my_port, int src_client,
	int src_port) {
	fprintf(stderr, "Unimplemented stub snd_seq_connect_from\n");
	exit(EXIT_FAILURE);
	if (seq || my_port || src_client || src_port) {}
}

int snd_seq_connect_to(snd_seq_t *seq, int my_port, int dest_client,
	int dest_port) {
	fprintf(stderr, "Unimplemented stub snd_seq_connect_to\n");
	exit(EXIT_FAILURE);
	if (seq || my_port || dest_client || dest_port) {}
}

int snd_seq_create_simple_port(snd_seq_t *seq, const char *name,
	unsigned int caps, unsigned int type) {
	fprintf(stderr, "Unimplemented stub snd_seq_create_simple_port\n");
	exit(EXIT_FAILURE);
	if (seq || name || caps || type) {}
}

int snd_seq_delete_simple_port(snd_seq_t *seq, int port) {
	int result;
	unsigned args[] = {
		SND_SEQ_DELETE_SIMPLE_PORT,
		(unsigned) &result,
		(unsigned) seq,
		port
	};
	normal_call(args);
	return result;
}

int snd_seq_disconnect_from(snd_seq_t *seq, int my_port, int src_client,
	int src_port) {
	fprintf(stderr, "Unimplemented stub snd_seq_disconnect_from\n");
	exit(EXIT_FAILURE);
	if (seq || my_port || src_client || src_port) {}
}

int snd_seq_disconnect_to(snd_seq_t *seq, int my_port, int dest_client,
	int dest_port) {
	fprintf(stderr, "Unimplemented stub snd_seq_disconnect_to\n");
	exit(EXIT_FAILURE);
	if (seq || my_port || dest_client || dest_port) {}
}

int snd_seq_event_input(snd_seq_t *handle, snd_seq_event_t **ev) {
	fprintf(stderr, "Unimplemented stub snd_seq_event_input\n");
	exit(EXIT_FAILURE);
	if (handle || ev) {}
}

int snd_seq_event_input_pending(snd_seq_t *seq, int fetch_sequencer) {
	fprintf(stderr, "Unimplemented stub snd_seq_event_input_pending\n");
	exit(EXIT_FAILURE);
	if (seq || fetch_sequencer) {}
}

int snd_seq_event_output_direct(snd_seq_t *handle, snd_seq_event_t *ev) {
	fprintf(stderr, "Unimplemented stub snd_seq_event_output_direct\n");
	exit(EXIT_FAILURE);
	if (handle || ev) {}
}

int snd_seq_free_event(snd_seq_event_t *ev) {
	fprintf(stderr, "Unimplemented stub snd_seq_free_event\n");
	exit(EXIT_FAILURE);
	if (ev) {}
}

int snd_seq_open(snd_seq_t **handle, const char *name, int streams, int mode) {
	int result;
	unsigned args[] = {
		SND_SEQ_OPEN,
		(unsigned) &result,
		(unsigned) handle,
		(unsigned) name,
		streams,
		mode
	};
	normal_call(args);
	return result;
}

int snd_seq_poll_descriptors(snd_seq_t *handle, struct pollfd *pfds,
	unsigned int space, short events) {
	fprintf(stderr, "Unimplemented stub snd_seq_poll_descriptors\n");
	exit(EXIT_FAILURE);
	if (handle || pfds || space || events) {}
}

int snd_seq_poll_descriptors_count(snd_seq_t *handle, short events) {
	fprintf(stderr, "Unimplemented stub snd_seq_poll_descriptors_count\n");
	exit(EXIT_FAILURE);
	if (handle || events) {}
}

const snd_seq_addr_t *snd_seq_port_info_get_addr(
	const snd_seq_port_info_t *info) {
	const snd_seq_addr_t *result;
	unsigned args[] = {
		SND_SEQ_PORT_INFO_GET_ADDR,
		(unsigned) &result,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

unsigned int snd_seq_port_info_get_capability(const snd_seq_port_info_t *info) {
	unsigned int result;
	unsigned args[] = {
		SND_SEQ_PORT_INFO_GET_CAPABILITY,
		(unsigned) &result,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

const char *snd_seq_port_info_get_name(const snd_seq_port_info_t *info) {
	fprintf(stderr, "Unimplemented stub snd_seq_port_info_get_name\n");
	exit(EXIT_FAILURE);
	if (info) {}
}

int snd_seq_port_info_get_port(const snd_seq_port_info_t *info) {
	fprintf(stderr, "Unimplemented stub snd_seq_port_info_get_port\n");
	exit(EXIT_FAILURE);
	if (info) {}
}

unsigned int snd_seq_port_info_get_type(const snd_seq_port_info_t *info) {
	unsigned int result;
	unsigned args[] = {
		SND_SEQ_PORT_INFO_GET_TYPE,
		(unsigned) &result,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

void snd_seq_port_info_set_client(snd_seq_port_info_t *info, int client) {
	unsigned args[] = {
		SND_SEQ_PORT_INFO_SET_CLIENT,
		(unsigned) info,
		client
	};
	normal_call(args);
}

void snd_seq_port_info_set_port(snd_seq_port_info_t *info, int port) {
	unsigned args[] = {
		SND_SEQ_PORT_INFO_SET_PORT,
		(unsigned) info,
		port
	};
	normal_call(args);
}

size_t snd_seq_port_info_sizeof(void) {
	size_t result;
	unsigned args[] = {
		SND_SEQ_PORT_INFO_SIZEOF,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int snd_seq_query_next_client(snd_seq_t *handle, snd_seq_client_info_t *info) {
	int result;
	unsigned args[] = {
		SND_SEQ_QUERY_NEXT_CLIENT,
		(unsigned) &result,
		(unsigned) handle,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

int snd_seq_query_next_port(snd_seq_t *handle, snd_seq_port_info_t *info) {
	int result;
	unsigned args[] = {
		SND_SEQ_QUERY_NEXT_PORT,
		(unsigned) &result,
		(unsigned) handle,
		(unsigned) info
	};
	normal_call(args);
	return result;
}

int snd_seq_set_client_name(snd_seq_t *seq, const char *name) {
	fprintf(stderr, "Unimplemented stub snd_seq_set_client_name\n");
	exit(EXIT_FAILURE);
	if (seq || name) {}
}

const char *snd_strerror(int errnum) {
	const char *result;
	unsigned args[] = {
		SND_STRERROR,
		(unsigned) &result,
		errnum
	};
	normal_call(args);
	return result;
}

void *snd_async_handler_get_callback_private(snd_async_handler_t *handler) {
	fprintf(stderr,
		"Unimplemented stub snd_async_handler_get_callback_private\n");
	exit(EXIT_FAILURE);
	if (handler) {}
}
snd_pcm_t *snd_async_handler_get_pcm(snd_async_handler_t *handler) {
	fprintf(stderr, "Unimplemented stub snd_async_handler_get_pcm\n");
	exit(EXIT_FAILURE);
	if (handler) {}
}
int snd_pcm_resume(snd_pcm_t *pcm) {
	fprintf(stderr, "Unimplemented stub snd_pcm_resume\n");
	exit(EXIT_FAILURE);
	if (pcm) {}
}
int snd_pcm_status(snd_pcm_t *pcm, snd_pcm_status_t *status) {
	fprintf(stderr, "Unimplemented stub snd_pcm_status\n");
	exit(EXIT_FAILURE);
	if (pcm || status) {}
}
int snd_pcm_status_dump(snd_pcm_status_t *status, snd_output_t *out) {
	fprintf(stderr, "Unimplemented stub snd_pcm_status_dump\n");
	exit(EXIT_FAILURE);
	if (status || out) {}
}
int snd_pcm_status_malloc(snd_pcm_status_t **ptr) {
	fprintf(stderr, "Unimplemented stub snd_pcm_status_malloc\n");
	exit(EXIT_FAILURE);
	if (ptr) {}
}
size_t snd_pcm_status_sizeof(void) {
	fprintf(stderr, "Unimplemented stub snd_pcm_status_sizeof\n");
	exit(EXIT_FAILURE);
}
