#include <stdio.h>
#include <stdlib.h>
#include <emu-stub/base.h>
#include <X11/extensions/xf86vmode.h>

#include "libXxf86vm_const.h"

Bool XF86VidModeGetAllModeLines(Display *dpy, int screen, int *modecount,
	XF86VidModeModeInfo ***modelinesPtr) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODEGETALLMODELINES,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		(unsigned) modecount,
		(unsigned) modelinesPtr
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeGetGamma(Display *dpy, int screen, XF86VidModeGamma *Gamma) {
	fprintf(stderr, "Unimplemented stub XF86VidModeGetGamma\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || Gamma) {}
}

Bool XF86VidModeGetGammaRamp(Display *dpy, int screen, int size,
	unsigned short *red, unsigned short *green, unsigned short *blue) {
	fprintf(stderr, "Unimplemented stub XF86VidModeGetGammaRamp\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || size || red || green || blue) {}
}

Bool XF86VidModeGetGammaRampSize(Display *dpy, int screen, int *size) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODEGETGAMMARAMPSIZE,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		(unsigned) size
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeGetModeLine(Display *dpy, int screen, int *dotclock,
	XF86VidModeModeLine *modeline) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODEGETMODELINE,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		(unsigned) dotclock,
		(unsigned) modeline
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeLockModeSwitch(Display *dpy, int screen, int lock) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODELOCKMODESWITCH,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		lock
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeQueryExtension(Display *dpy, int *event_base, int *error_base) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODEQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) event_base,
		(unsigned) error_base
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeQueryVersion(Display *dpy, int *majorVersion,
	int *minorVersion) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODEQUERYVERSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) majorVersion,
		(unsigned) minorVersion
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeSetGamma(Display *dpy, int screen, XF86VidModeGamma *Gamma) {
	fprintf(stderr, "Unimplemented stub XF86VidModeSetGamma\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || Gamma) {}
}

Bool XF86VidModeSetGammaRamp(Display *dpy, int screen, int size,
	unsigned short *red, unsigned short *green, unsigned short *blue) {
	Bool result;
	unsigned args[] = {
		XF86VIDMODESETGAMMARAMP,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		size,
		(unsigned) red,
		(unsigned) green,
		(unsigned) blue
	};
	normal_call(args);
	return result;
}

Bool XF86VidModeSwitchToMode(Display *dpy, int screen,
	XF86VidModeModeInfo *modeline) {
	fprintf(stderr, "Unimplemented stub XF86VidModeSwitchToMode\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || modeline) {}
}
