#include <emu-stub/base.h>
#include <X11/extensions/Xrender.h>

#include "libXrender_const.h"

void XRenderAddGlyphs(Display *dpy, GlyphSet glyphset, const Glyph *gids,
	const XGlyphInfo *glyphs, int nglyphs, const char *images,
	int nbyte_images) {
	unsigned args[] = {
		XRENDERADDGLYPHS,
		(unsigned) dpy,
		glyphset,
		(unsigned) gids,
		(unsigned) glyphs,
		nglyphs,
		(unsigned) images,
		nbyte_images
	};
	normal_call(args);
}

void XRenderChangePicture(Display *dpy, Picture picture,
	unsigned long valuemask, const XRenderPictureAttributes *attributes) {
	unsigned args[] = {
		XRENDERCHANGEPICTURE,
		(unsigned) dpy,
		picture,
		valuemask,
		(unsigned) attributes
	};
	normal_call(args);
}

void XRenderComposite(Display *dpy, int op, Picture src, Picture mask,
	Picture dst, int src_x, int src_y, int mask_x, int mask_y, int dst_x,
	int dst_y, unsigned int width, unsigned int height) {
	unsigned args[] = {
		XRENDERCOMPOSITE,
		(unsigned) dpy,
		op,
		src,
		mask,
		dst,
		src_x,
		src_y,
		mask_x,
		mask_y,
		dst_x,
		dst_y,
		width,
		height
	};
	normal_call(args);
}

void XRenderCompositeText16(Display *dpy, int op, Picture src, Picture dst,
	const XRenderPictFormat *maskFormat, int xSrc, int ySrc, int xDst,
	int yDst, const XGlyphElt16 *elts, int nelt) {
	unsigned args[] = {
		XRENDERCOMPOSITETEXT16,
		(unsigned) dpy,
		op,
		src,
		dst,
		(unsigned) maskFormat,
		xSrc,
		ySrc,
		xDst,
		yDst,
		(unsigned) elts,
		nelt
	};
	normal_call(args);
}

void XRenderCompositeText32(Display *dpy, int op, Picture src, Picture dst,
	const XRenderPictFormat *maskFormat, int xSrc, int ySrc, int xDst,
	int yDst, const XGlyphElt32 *elts, int nelt) {
	unsigned args[] = {
		XRENDERCOMPOSITETEXT32,
		(unsigned) dpy,
		op,
		src,
		dst,
		(unsigned) maskFormat,
		xSrc,
		ySrc,
		xDst,
		yDst,
		(unsigned) elts,
		nelt
	};
	normal_call(args);
}

void XRenderCompositeText8(Display *dpy, int op, Picture src, Picture dst,
	const XRenderPictFormat *maskFormat, int xSrc, int ySrc, int xDst,
	int yDst, const XGlyphElt8 *elts, int nelt) {
	unsigned args[] = {
		XRENDERCOMPOSITETEXT8,
		(unsigned) dpy,
		op,
		src,
		dst,
		(unsigned) maskFormat,
		xSrc,
		ySrc,
		xDst,
		yDst,
		(unsigned) elts,
		nelt
	};
	normal_call(args);
}

void XRenderCompositeTrapezoids(Display *dpy, int op, Picture src, Picture dst,
	const XRenderPictFormat *maskFormat, int xSrc, int ySrc,
	const XTrapezoid *traps, int ntrap) {
	unsigned args[] = {
		XRENDERCOMPOSITETRAPEZOIDS,
		(unsigned) dpy,
		op,
		src,
		dst,
		(unsigned) maskFormat,
		xSrc,
		ySrc,
		(unsigned) traps,
		ntrap
	};
	normal_call(args);
}

GlyphSet XRenderCreateGlyphSet(Display *dpy, const XRenderPictFormat *format) {
	GlyphSet result;
	unsigned args[] = {
		XRENDERCREATEGLYPHSET,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) format
	};
	normal_call(args);
	return result;
}

Picture XRenderCreatePicture(Display *dpy, Drawable drawable,
	const XRenderPictFormat *format, unsigned long valuemask,
	const XRenderPictureAttributes *attributes) {
	Picture result;
	unsigned args[] = {
		XRENDERCREATEPICTURE,
		(unsigned) &result,
		(unsigned) dpy,
		drawable,
		(unsigned) format,
		valuemask,
		(unsigned) attributes
	};
	normal_call(args);
	return result;
}

void XRenderFillRectangles(Display *dpy, int op, Picture dst,
	const XRenderColor *color, const XRectangle *rectangles, int n_rects) {
	unsigned args[] = {
		XRENDERFILLRECTANGLES,
		(unsigned) dpy,
		op,
		dst,
		(unsigned) color,
		(unsigned) rectangles,
		n_rects
	};
	normal_call(args);
}

XRenderPictFormat *XRenderFindFormat(Display *dpy, unsigned long mask,
	const XRenderPictFormat *templ, int count) {
	XRenderPictFormat *result;
	unsigned args[] = {
		XRENDERFINDFORMAT,
		(unsigned) &result,
		(unsigned) dpy,
		mask,
		(unsigned) templ,
		count
	};
	normal_call(args);
	return result;
}

XRenderPictFormat *XRenderFindStandardFormat(Display *dpy, int format) {
	XRenderPictFormat *result;
	unsigned args[] = {
		XRENDERFINDSTANDARDFORMAT,
		(unsigned) &result,
		(unsigned) dpy,
		format
	};
	normal_call(args);
	return result;
}

XRenderPictFormat *XRenderFindVisualFormat(Display *dpy, const Visual *visual) {
	XRenderPictFormat *result;
	unsigned args[] = {
		XRENDERFINDVISUALFORMAT,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) visual
	};
	normal_call(args);
	return result;
}

void XRenderFreeGlyphSet(Display *dpy, GlyphSet glyphset) {
	unsigned args[] = {
		XRENDERFREEGLYPHSET,
		(unsigned) dpy,
		glyphset
	};
	normal_call(args);
}

void XRenderFreePicture(Display *dpy, Picture picture) {
	unsigned args[] = {
		XRENDERFREEPICTURE,
		(unsigned) dpy,
		picture
	};
	normal_call(args);
}

Bool XRenderQueryExtension(Display *dpy, int *event_basep, int *error_basep) {
	Bool result;
	unsigned args[] = {
		XRENDERQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) event_basep,
		(unsigned) error_basep
	};
	normal_call(args);
	return result;
}

Status XRenderQueryVersion(Display *dpy, int *major_versionp,
	int *minor_versionp) {
	Status result;
	unsigned args[] = {
		XRENDERQUERYVERSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) major_versionp,
		(unsigned) minor_versionp
	};
	normal_call(args);
	return result;
}

void XRenderSetPictureClipRectangles(Display *dpy, Picture picture, int xOrigin,
	int yOrigin, const XRectangle *rects, int n) {
	unsigned args[] = {
		XRENDERSETPICTURECLIPRECTANGLES,
		(unsigned) dpy,
		picture,
		xOrigin,
		yOrigin,
		(unsigned) rects,
		n
	};
	normal_call(args);
}
