#include <emu-stub/base.h>
#include <X11/extensions/Xrandr.h>

#include "libXrandr_const.h"

void XRRFreeCrtcInfo(XRRCrtcInfo *crtcInfo) {
	unsigned args[] = {
		XRRFREECRTCINFO,
		(unsigned) crtcInfo
	};
	normal_call(args);
}

void XRRFreeOutputInfo(XRROutputInfo *outputInfo) {
	unsigned args[] = {
		XRRFREEOUTPUTINFO,
		(unsigned) outputInfo
	};
	normal_call(args);
}

void XRRFreeScreenResources(XRRScreenResources *resources) {
	unsigned args[] = {
		XRRFREESCREENRESOURCES,
		(unsigned) resources
	};
	normal_call(args);
}

XRRCrtcInfo *XRRGetCrtcInfo(Display *dpy, XRRScreenResources *resources,
	RRCrtc crtc) {
	XRRCrtcInfo *result;
	unsigned args[] = {
		XRRGETCRTCINFO,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) resources,
		crtc
	};
	normal_call(args);
	return result;
}

XRROutputInfo *XRRGetOutputInfo(Display *dpy, XRRScreenResources *resources,
	RROutput output) {
	XRROutputInfo *result;
	unsigned args[] = {
		XRRGETOUTPUTINFO,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) resources,
		output
	};
	normal_call(args);
	return result;
}

RROutput XRRGetOutputPrimary(Display *dpy, Window window) {
	RROutput result;
	unsigned args[] = {
		XRRGETOUTPUTPRIMARY,
		(unsigned) &result,
		(unsigned) dpy,
		window
	};
	normal_call(args);
	return result;
}

XRRScreenResources *XRRGetScreenResourcesCurrent(Display *dpy, Window window) {
	XRRScreenResources *result;
	unsigned args[] = {
		XRRGETSCREENRESOURCESCURRENT,
		(unsigned) &result,
		(unsigned) dpy,
		window
	};
	normal_call(args);
	return result;
}

Bool XRRQueryExtension(Display *dpy, int *event_base_return,
	int *error_base_return) {
	Bool result;
	unsigned args[] = {
		XRRQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) event_base_return,
		(unsigned) error_base_return
	};
	normal_call(args);
	return result;
}

Status XRRQueryVersion(Display *dpy, int *major_version_return,
	int *minor_version_return) {
	Status result;
	unsigned args[] = {
		XRRQUERYVERSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) major_version_return,
		(unsigned) minor_version_return
	};
	normal_call(args);
	return result;
}

void XRRSelectInput(Display *dpy, Window window, int mask) {
	unsigned args[] = {
		XRRSELECTINPUT,
		(unsigned) dpy,
		window,
		mask
	};
	normal_call(args);
}

int XRRUpdateConfiguration(XEvent *event) {
	int result;
	unsigned args[] = {
		XRRUPDATECONFIGURATION,
		(unsigned) &result,
		(unsigned) event
	};
	normal_call(args);
	return result;
}
