#include <emu-stub/base.h>
#include <X11/extensions/XInput.h>

#include "libXi_const.h"

void XFreeDeviceList(XDeviceInfo *list) {
	unsigned args[] = {
		XFREEDEVICELIST,
		(unsigned) list
	};
	normal_call(args);
}

XDeviceInfo *XListInputDevices(Display *display, int *ndevices) {
	XDeviceInfo *result;
	unsigned args[] = {
		XLISTINPUTDEVICES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) ndevices
	};
	normal_call(args);
	return result;
}

XDevice *XOpenDevice(Display *display, XID id) {
	XDevice *result;
	unsigned args[] = {
		XOPENDEVICE,
		(unsigned) &result,
		(unsigned) display,
		id
	};
	normal_call(args);
	return result;
}
