#include <stdio.h>
#include <stdlib.h>
#include <emu-stub/base.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/sync.h>
#include <X11/extensions/XShm.h>

#include "libXext_const.h"

static int destroy_image(XImage *ximage) {
	int result;
	unsigned args[] = {
		DESTROY_IMAGE,
		(unsigned) &result,
		(unsigned) ximage
	};
	normal_call(args);
	return result;
}

static int put_pixel(XImage *ximage, int x, int y, unsigned long pixel) {
	int result;
	unsigned args[] = {
		PUT_PIXEL,
		(unsigned) &result,
		(unsigned) ximage,
		x,
		y,
		pixel
	};
	normal_call(args);
	return result;
}

void XShapeCombineMask(Display *display, Window dest, int dest_kind, int x_off,
	int y_off, Pixmap src, int op) {
	unsigned args[] = {
		XSHAPECOMBINEMASK,
		(unsigned) display,
		dest,
		dest_kind,
		x_off,
		y_off,
		src,
		op
	};
	normal_call(args);
}

void XShapeCombineRectangles(Display *display, Window dest, int dest_kind,
	int x_off, int y_off, XRectangle *rectangles, int n_rects, int op,
	int ordering) {
	unsigned args[] = {
		XSHAPECOMBINERECTANGLES,
		(unsigned) display,
		dest,
		dest_kind,
		x_off,
		y_off,
		(unsigned) rectangles,
		n_rects,
		op,
		ordering
	};
	normal_call(args);
}

Bool XShapeQueryExtension(Display *display, int *event_base, int *error_base) {
	Bool result;
	unsigned args[] = {
		XSHAPEQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) event_base,
		(unsigned) error_base
	};
	normal_call(args);
	return result;
}

Status XShapeQueryVersion(Display *display, int *major_version,
	int *minor_version) {
	Status result;
	unsigned args[] = {
		XSHAPEQUERYVERSION,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) major_version,
		(unsigned) minor_version
	};
	normal_call(args);
	return result;
}

Status XShmAttach(Display *dpy, XShmSegmentInfo *shminfo) {
	Status result;
	unsigned args[] = {
		XSHMATTACH,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) shminfo
	};
	normal_call(args);
	return result;
}

static void unimplemented_image_function(void) {
	fprintf(stderr, "unimplemented Xext image function.\n");
	exit(EXIT_FAILURE);
}

XImage *XShmCreateImage(Display *dpy, Visual *visual, unsigned int depth,
	int format, char *data, XShmSegmentInfo *shminfo, unsigned int width,
	unsigned int height) {
	XImage *result;
	unsigned args[] = {
		XSHMCREATEIMAGE,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) visual,
		depth,
		format,
		(unsigned) data,
		(unsigned) shminfo,
		width,
		height
	};
	normal_call(args);
	result->f.create_image = (void *) unimplemented_image_function;
	result->f.destroy_image = destroy_image;
	result->f.get_pixel = (void *) unimplemented_image_function;
	result->f.put_pixel = put_pixel;
	result->f.sub_image = (void *) unimplemented_image_function;
	result->f.add_pixel = (void *) unimplemented_image_function;
	return result;
}

Pixmap XShmCreatePixmap(Display *dpy, Drawable d, char *data,
	XShmSegmentInfo *shminfo, unsigned int width, unsigned int height,
	unsigned int depth) {
	Pixmap result;
	unsigned args[] = {
		XSHMCREATEPIXMAP,
		(unsigned) &result,
		(unsigned) dpy,
		d,
		(unsigned) data,
		(unsigned) shminfo,
		width,
		height,
		depth
	};
	normal_call(args);
	return result;
}

Status XShmDetach(Display *dpy, XShmSegmentInfo *shminfo) {
	Status result;
	unsigned args[] = {
		XSHMDETACH,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) shminfo
	};
	normal_call(args);
	return result;
}

int XShmGetEventBase(Display *dpy) {
	int result;
	unsigned args[] = {
		XSHMGETEVENTBASE,
		(unsigned) &result,
		(unsigned) dpy
	};
	normal_call(args);
	return result;
}

Status XShmGetImage(Display *dpy, Drawable d, XImage *image, int x, int y,
	unsigned long plane_mask) {
	fprintf(stderr, "Unimplemented stub XShmGetImage\n");
	exit(EXIT_FAILURE);
	if (dpy || d || image || x || y || plane_mask) {}
}

Status XShmPutImage(Display *dpy, Drawable d, GC gc, XImage *image, int src_x,
	int src_y, int dst_x, int dst_y, unsigned int src_width,
	unsigned int src_height, Bool send_event) {
	Status result;
	unsigned args[] = {
		XSHMPUTIMAGE,
		(unsigned) &result,
		(unsigned) dpy,
		d,
		(unsigned) gc,
		(unsigned) image,
		src_x,
		src_y,
		dst_x,
		dst_y,
		src_width,
		src_height,
		send_event
	};
	normal_call(args);
	return result;
}

Bool XShmQueryExtension(Display *dpy) {
	Bool result;
	unsigned args[] = {
		XSHMQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy
	};
	normal_call(args);
	return result;
}

Bool XShmQueryVersion(Display *dpy, int *majorVersion, int *minorVersion,
	Bool *sharedPixmaps) {
	Bool result;
	unsigned args[] = {
		XSHMQUERYVERSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) majorVersion,
		(unsigned) minorVersion,
		(unsigned) sharedPixmaps
	};
	normal_call(args);
	return result;
}

XSyncCounter XSyncCreateCounter(Display *dpy, XSyncValue initial_value) {
	XSyncCounter result;
	unsigned args[] = {
		XSYNCCREATECOUNTER,
		(unsigned) &result,
		(unsigned) dpy,
		initial_value.hi,
		initial_value.lo
	};
	normal_call(args);
	return result;
}

Status XSyncDestroyCounter(Display *dpy, XSyncCounter counter) {
	Status result;
	unsigned args[] = {
		XSYNCDESTROYCOUNTER,
		(unsigned) &result,
		(unsigned) dpy,
		counter
	};
	normal_call(args);
	return result;
}

Status XSyncInitialize(Display *dpy, int *major_version_return,
	int *minor_version_return) {
	Status result;
	unsigned args[] = {
		XSYNCINITIALIZE,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) major_version_return,
		(unsigned) minor_version_return
	};
	normal_call(args);
	return result;
}

void XSyncIntToValue(XSyncValue *pv, int i) {
	unsigned args[] = {
		XSYNCINTTOVALUE,
		(unsigned) pv,
		i
	};
	normal_call(args);
}

Status XSyncQueryExtension(Display *dpy, int *event_base_return,
	int *error_base_return) {
	Status result;
	unsigned args[] = {
		XSYNCQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) event_base_return,
		(unsigned) error_base_return
	};
	normal_call(args);
	return result;
}

Status XSyncSetCounter(Display *dpy, XSyncCounter counter, XSyncValue value) {
	Status result;
	unsigned args[] = {
		XSYNCSETCOUNTER,
		(unsigned) &result,
		(unsigned) dpy,
		counter,
		value.hi,
		value.lo
	};
	normal_call(args);
	return result;
}

Bool XSyncValueIsZero(XSyncValue a) {
	Bool result;
	unsigned args[] = {
		XSYNCVALUEISZERO,
		(unsigned) &result,
		a.hi,
		a.lo
	};
	normal_call(args);
	return result;
}
