#include <emu-stub/base.h>
#include <X11/Xcursor/Xcursor.h>

#include "libXcursor_const.h"

int XcursorGetDefaultSize(Display *dpy) {
	int result;
	unsigned args[] = {
		XCURSORGETDEFAULTSIZE,
		(unsigned) &result,
		(unsigned) dpy
	};
	normal_call(args);
	return result;
}

char *XcursorGetTheme(Display *dpy) {
	char *result;
	unsigned args[] = {
		XCURSORGETTHEME,
		(unsigned) &result,
		(unsigned) dpy
	};
	normal_call(args);
	return result;
}

XcursorBool XcursorSetDefaultSize(Display *dpy, int size) {
	XcursorBool result;
	unsigned args[] = {
		XCURSORSETDEFAULTSIZE,
		(unsigned) &result,
		(unsigned) dpy,
		size
	};
	normal_call(args);
	return result;
}

XcursorBool XcursorSetTheme(Display *dpy, const char *theme) {
	XcursorBool result;
	unsigned args[] = {
		XCURSORSETTHEME,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) theme
	};
	normal_call(args);
	return result;
}
