#include <stdarg.h>
#include <stdio.h>
#define CUSTOM_EMU_STUB_CONSTRUCTOR
#include <emu-stub/base.h>
#include <emu-stub/stub.h>
#include <X11/XKBlib.h>
#include <X11/Xlibint.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>

#include "libX11_const.h"

static void unlock_display(Display *dpy);

static int destroy_image(XImage *ximage) {
	int result;
	unsigned args[] = {
		DESTROY_IMAGE,
		(unsigned) &result,
		(unsigned) ximage
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_predicate(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	for (;;) {
		Bool (*predicate)(Display *, XEvent *, XPointer)
			= (void *) callback_args[0];
		Display *display = (void *) callback_args[1];
		XEvent *event = (void *) callback_args[2];
		XPointer arg = (void *) callback_args[3];
		Bool match = predicate(display, event, arg);
		callback_args[1] = match;
		emu_stub_return();
	}
}

static unsigned long get_pixel(XImage *ximage, int x, int y) {
	unsigned long result;
	unsigned args[] = {
		GET_PIXEL,
		(unsigned) &result,
		(unsigned) ximage,
		x,
		y
	};
	normal_call(args);
	return result;
}

static int get_vargs(va_list ap, unsigned **vargs) {
	int count = 0;
	va_list count_ap;
	va_copy(count_ap, ap);
	unsigned attr = va_arg(count_ap, unsigned);
	while (attr) {
		va_arg(count_ap, unsigned);
		attr = va_arg(count_ap, unsigned);
		count++;
	}
	va_end(count_ap);

	*vargs = malloc(2 * count * sizeof(unsigned));
	unsigned *varg = *vargs;
	attr = va_arg(ap, unsigned);
	*varg++ = attr;
	while (attr) {
		*varg++ = va_arg(ap, unsigned);
		attr = va_arg(ap, unsigned);
		*varg++ = attr;
	}
	va_end(ap);
	return count;
}

static void lock_display(Display *dpy) {
	unsigned args[] = {
		LOCK_DISPLAY,
		(unsigned) dpy
	};
	normal_call(args);
}

static int put_pixel(XImage *ximage, int x, int y, unsigned long pixel) {
	int result;
	unsigned args[] = {
		PUT_PIXEL,
		(unsigned) &result,
		(unsigned) ximage,
		x,
		y,
		pixel
	};
	normal_call(args);
	return result;
}

__attribute__((constructor)) static void stub_init(void) {
	emu_stub_constructor();
	static struct _XLockPtrs lock_fns = { lock_display, unlock_display };
	unsigned args[] = {
		STUB_INIT,
		(unsigned) &lock_fns
	};
	normal_call(args);
}

__attribute__((noinline)) static void do_async_handler(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	for (;;) {
		Bool (*handler)(Display *, xReply *, char *, int, XPointer)
			= (void *) callback_args[0];
		Display *dpy = (void *) callback_args[1];
		xReply *rep = (void *) callback_args[2];
		char *buf = (void *) callback_args[3];
		int len = callback_args[4];
		XPointer data = (void *) callback_args[5];
		Bool handled = handler(dpy, rep, buf, len, data);
		callback_args[0] = handled;
		emu_stub_return();
	}
}

static void unlock_display(Display *dpy) {
	unsigned args[] = {
		UNLOCK_DISPLAY,
		(unsigned) dpy
	};
	static int once = 1;
	if (once) {
		once = 0;
		do_async_handler(callback_call(args));
	}
	else
		normal_call(args);
}

Status XAddConnectionWatch(Display *dpy, XConnectionWatchProc callback,
	XPointer client_data) {
	Status result;
	unsigned args[] = {
		XADDCONNECTIONWATCH,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) callback,
		(unsigned) client_data
	};
	normal_call(args);
	return result;
}

XExtCodes *XAddExtension(Display *display) {
	XExtCodes *result;
	unsigned args[] = {
		XADDEXTENSION,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

XClassHint *XAllocClassHint(void) {
	XClassHint *result;
	unsigned args[] = {
		XALLOCCLASSHINT,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

Status XAllocColor(Display *display, Colormap colormap, XColor *screen_in_out) {
	Status result;
	unsigned args[] = {
		XALLOCCOLOR,
		(unsigned) &result,
		(unsigned) display,
		colormap,
		(unsigned) screen_in_out
	};
	normal_call(args);
	return result;
}

Status XAllocColorCells(Display *display, Colormap colormap, Bool contig,
	unsigned long *plane_masks_return, unsigned int nplanes,
	unsigned long *pixels_return, unsigned int npixels) {
	fprintf(stderr, "Unimplemented stub XAllocColorCells\n");
	exit(EXIT_FAILURE);
	if (display || colormap || contig || plane_masks_return || nplanes
		|| pixels_return || npixels) {}
}

Status XAllocNamedColor(Display *display, Colormap colormap,
	const char *color_name, XColor *screen_def_return,
	XColor *exact_def_return) {
	Status result;
	unsigned args[] = {
		XALLOCNAMEDCOLOR,
		(unsigned) &result,
		(unsigned) display,
		colormap,
		(unsigned) color_name,
		(unsigned) screen_def_return,
		(unsigned) exact_def_return
	};
	normal_call(args);
	return result;
}

XSizeHints *XAllocSizeHints(void) {
	XSizeHints *result;
	unsigned args[] = {
		XALLOCSIZEHINTS,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

XWMHints *XAllocWMHints(void) {
	XWMHints *result;
	unsigned args[] = {
		XALLOCWMHINTS,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int XBell(Display *display, int percent) {
	int result;
	unsigned args[] = {
		XBELL,
		(unsigned) &result,
		(unsigned) display,
		percent
	};
	normal_call(args);
	return result;
}

int XChangeGC(Display *display, GC gc, unsigned long valuemask,
	XGCValues *values) {
	int result;
	unsigned args[] = {
		XCHANGEGC,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		valuemask,
		(unsigned) values
	};
	normal_call(args);
	return result;
}

int XChangeProperty(Display *display, Window w, Atom property, Atom type,
	int format, int mode, const unsigned char *data, int nelements) {
	int result;
	unsigned args[] = {
		XCHANGEPROPERTY,
		(unsigned) &result,
		(unsigned) display,
		w,
		property,
		type,
		format,
		mode,
		(unsigned) data,
		nelements
	};
	normal_call(args);
	return result;
}

int XChangeWindowAttributes(Display *display, Window w, unsigned long valuemask,
	XSetWindowAttributes *attributes) {
	int result;
	unsigned args[] = {
		XCHANGEWINDOWATTRIBUTES,
		(unsigned) &result,
		(unsigned) display,
		w,
		valuemask,
		(unsigned) attributes
	};
	normal_call(args);
	return result;
}

Bool XCheckIfEvent(Display *display, XEvent *event_return,
	Bool (*predicate)(Display *, XEvent *, XPointer), XPointer arg) {
	Bool result;
	unsigned args[] = {
		XCHECKIFEVENT,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) event_return,
		(unsigned) predicate,
		(unsigned) arg
	};
	do_predicate(callback_call(args));
	return result;
}

Bool XCheckTypedWindowEvent(Display *display, Window w, int event_type,
	XEvent *event_return) {
	Bool result;
	unsigned args[] = {
		XCHECKTYPEDWINDOWEVENT,
		(unsigned) &result,
		(unsigned) display,
		w,
		event_type,
		(unsigned) event_return
	};
	normal_call(args);
	return result;
}

int XClearArea(Display *display, Window w, int x, int y, unsigned int width,
	unsigned int height, Bool exposures) {
	int result;
	unsigned args[] = {
		XCLEARAREA,
		(unsigned) &result,
		(unsigned) display,
		w,
		x,
		y,
		width,
		height,
		exposures
	};
	normal_call(args);
	return result;
}

int XClearWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XCLEARWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

int XClipBox(Region r, XRectangle *rect_return) {
	int result;
	unsigned args[] = {
		XCLIPBOX,
		(unsigned) &result,
		(unsigned) r,
		(unsigned) rect_return
	};
	normal_call(args);
	return result;
}

int XCloseDisplay(Display *display) {
	int result;
	unsigned args[] = {
		XCLOSEDISPLAY,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

Status XCloseIM(XIM im) {
	fprintf(stderr, "Unimplemented stub XCloseIM\n");
	exit(EXIT_FAILURE);
	if (im) {}
}

int XConfigureWindow(Display *display, Window w, unsigned int value_mask,
	XWindowChanges *values) {
	int result;
	unsigned args[] = {
		XCONFIGUREWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		value_mask,
		(unsigned) values
	};
	normal_call(args);
	return result;
}

void XConvertCase(KeySym sym, KeySym *lower, KeySym *upper) {
	unsigned args[] = {
		XCONVERTCASE,
		sym,
		(unsigned) lower,
		(unsigned) upper
	};
	normal_call(args);
}

int XConvertSelection(Display *display, Atom selection, Atom target,
	Atom property, Window requestor, Time time) {
	int result;
	unsigned args[] = {
		XCONVERTSELECTION,
		(unsigned) &result,
		(unsigned) display,
		selection,
		target,
		property,
		requestor,
		time
	};
	normal_call(args);
	return result;
}

int XCopyArea(Display *display, Drawable src, Drawable dest, GC gc, int src_x,
	int src_y, unsigned int width, unsigned int height, int dest_x,
	int dest_y) {
	int result;
	unsigned args[] = {
		XCOPYAREA,
		(unsigned) &result,
		(unsigned) display,
		src,
		dest,
		(unsigned) gc,
		src_x,
		src_y,
		width,
		height,
		dest_x,
		dest_y
	};
	normal_call(args);
	return result;
}

int XCopyPlane(Display *display, Drawable src, Drawable dest, GC gc, int src_x,
	int src_y, unsigned int width, unsigned int height, int dest_x,
	int dest_y, unsigned long plane) {
	int result;
	unsigned args[] = {
		XCOPYPLANE,
		(unsigned) &result,
		(unsigned) display,
		src,
		dest,
		(unsigned) gc,
		src_x,
		src_y,
		width,
		height,
		dest_x,
		dest_y,
		plane
	};
	normal_call(args);
	return result;
}

Pixmap XCreateBitmapFromData(Display *display, Drawable d, const char *data,
	unsigned int width, unsigned int height) {
	Pixmap result;
	unsigned args[] = {
		XCREATEBITMAPFROMDATA,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) data,
		width,
		height
	};
	normal_call(args);
	return result;
}

Colormap XCreateColormap(Display *display, Window w, Visual *visual,
	int alloc) {
	Colormap result;
	unsigned args[] = {
		XCREATECOLORMAP,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) visual,
		alloc
	};
	normal_call(args);
	return result;
}

Cursor XCreateFontCursor(Display *display, unsigned int shape) {
	Cursor result;
	unsigned args[] = {
		XCREATEFONTCURSOR,
		(unsigned) &result,
		(unsigned) display,
		shape
	};
	normal_call(args);
	return result;
}

GC XCreateGC(Display *display, Drawable d, unsigned long valuemask,
	XGCValues *values) {
	GC result;
	unsigned args[] = {
		XCREATEGC,
		(unsigned) &result,
		(unsigned) display,
		d,
		valuemask,
		(unsigned) values
	};
	normal_call(args);
	return result;
}

XIC XCreateIC(XIM im, ...) {
	XIC result;
	unsigned *vargs;
	va_list ap;
	va_start(ap, im);
	int count = get_vargs(ap, &vargs);
	va_end(ap);
	unsigned args[] = {
		XCREATEIC,
		(unsigned) &result,
		(unsigned) im,
		(unsigned) vargs,
		count
	};
	normal_call(args);
	free(vargs);
	return result;
}

static void unimplemented_image_function(void) {
	fprintf(stderr, "unimplemented X11 image function.\n");
	exit(EXIT_FAILURE);
}

XImage *XCreateImage(Display *display, Visual *visual, unsigned int depth,
	int format, int offset, char *data, unsigned int width,
	unsigned int height, int bitmap_pad, int bytes_per_line) {
	XImage *result;
	unsigned args[] = {
		XCREATEIMAGE,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) visual,
		depth,
		format,
		offset,
		(unsigned) data,
		width,
		height,
		bitmap_pad,
		bytes_per_line
	};
	normal_call(args);
	result->f.create_image = (void *) unimplemented_image_function;
	result->f.destroy_image = destroy_image;
	result->f.get_pixel = get_pixel;
	result->f.put_pixel = put_pixel;
	result->f.sub_image = (void *) unimplemented_image_function;
	result->f.add_pixel = (void *) unimplemented_image_function;
	return result;
}

Pixmap XCreatePixmap(Display *display, Drawable d, unsigned int width,
	unsigned int height, unsigned int depth) {
	Pixmap result;
	unsigned args[] = {
		XCREATEPIXMAP,
		(unsigned) &result,
		(unsigned) display,
		d,
		width,
		height,
		depth
	};
	normal_call(args);
	return result;
}

Cursor XCreatePixmapCursor(Display *display, Pixmap source, Pixmap mask,
	XColor *foreground_color, XColor *background_color, unsigned int x,
	unsigned int y) {
	Cursor result;
	unsigned args[] = {
		XCREATEPIXMAPCURSOR,
		(unsigned) &result,
		(unsigned) display,
		source,
		mask,
		(unsigned) foreground_color,
		(unsigned) background_color,
		x,
		y
	};
	normal_call(args);
	return result;
}

Region XCreateRegion(void) {
	Region result;
	unsigned args[] = {
		XCREATEREGION,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

Window XCreateSimpleWindow(Display *display, Window parent, int x, int y,
	unsigned int width, unsigned int height, unsigned int border_width,
	unsigned long border, unsigned long background) {
	Window result;
	unsigned args[] = {
		XCREATESIMPLEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		parent,
		x,
		y,
		width,
		height,
		border_width,
		border,
		background
	};
	normal_call(args);
	return result;
}

Window XCreateWindow(Display *display, Window parent, int x, int y,
	unsigned int width, unsigned int height, unsigned int border_width,
	int depth, unsigned int class, Visual *visual, unsigned long valuemask,
	XSetWindowAttributes *attributes) {
	Window result;
	unsigned args[] = {
		XCREATEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		parent,
		x,
		y,
		width,
		height,
		border_width,
		depth,
		class,
		(unsigned) visual,
		valuemask,
		(unsigned) attributes
	};
	normal_call(args);
	return result;
}

Window XDefaultRootWindow(Display *display) {
	return DefaultRootWindow(display);
}

int XDefineCursor(Display *display, Window w, Cursor cursor) {
	int result;
	unsigned args[] = {
		XDEFINECURSOR,
		(unsigned) &result,
		(unsigned) display,
		w,
		cursor
	};
	normal_call(args);
	return result;
}

int XDeleteContext(Display *display, XID rid, XContext context) {
	int result;
	unsigned args[] = {
		XDELETECONTEXT,
		(unsigned) &result,
		(unsigned) display,
		rid,
		context
	};
	normal_call(args);
	return result;
}

int XDeleteProperty(Display *display, Window w, Atom property) {
	int result;
	unsigned args[] = {
		XDELETEPROPERTY,
		(unsigned) &result,
		(unsigned) display,
		w,
		property
	};
	normal_call(args);
	return result;
}

void _XDeqAsyncHandler(Display *dpy, _XAsyncHandler *handler) {
	_XAsyncHandler *async = dpy->async_handlers;
	while (async->next != handler)
		async = async->next;
	async->next = handler->next;
}

void XDestroyIC(XIC ic) {
	unsigned args[] = {
		XDESTROYIC,
		(unsigned) ic
	};
	normal_call(args);
}

int XDestroyWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XDESTROYWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

int XDisplayKeycodes(Display *display, int *min_keycodes_return,
	int *max_keycodes_return) {
	int result;
	unsigned args[] = {
		XDISPLAYKEYCODES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) min_keycodes_return,
		(unsigned) max_keycodes_return
	};
	normal_call(args);
	return result;
}

char *XDisplayName(const char *string) {
	char *result;
	unsigned args[] = {
		XDISPLAYNAME,
		(unsigned) &result,
		(unsigned) string
	};
	normal_call(args);
	return result;
}

Display *XDisplayOfIM(XIM im) {
	fprintf(stderr, "Unimplemented stub XDisplayOfIM\n");
	exit(EXIT_FAILURE);
	if (im) {}
}

int XDrawArc(Display *display, Drawable d, GC gc, int x, int y,
	unsigned int width, unsigned int height, int angle1, int angle2) {
	int result;
	unsigned args[] = {
		XDRAWARC,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x,
		y,
		width,
		height,
		angle1,
		angle2
	};
	normal_call(args);
	return result;
}

int XDrawLine(Display *display, Drawable d, GC gc, int x1, int y1, int x2,
	int y2) {
	int result;
	unsigned args[] = {
		XDRAWLINE,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x1,
		y1,
		x2,
		y2
	};
	normal_call(args);
	return result;
}

int XDrawLines(Display *display, Drawable d, GC gc, XPoint *points, int npoints,
	int mode) {
	int result;
	unsigned args[] = {
		XDRAWLINES,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		(unsigned) points,
		npoints,
		mode
	};
	normal_call(args);
	return result;
}

int XDrawPoint(Display *display, Drawable d, GC gc, int x, int y) {
	int result;
	unsigned args[] = {
		XDRAWPOINT,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x,
		y
	};
	normal_call(args);
	return result;
}

int XDrawRectangle(Display *display, Drawable d, GC gc, int x, int y,
	unsigned int width, unsigned int height) {
	int result;
	unsigned args[] = {
		XDRAWRECTANGLE,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x,
		y,
		width,
		height
	};
	normal_call(args);
	return result;
}

int XDrawString16(Display *display, Drawable d, GC gc, int x, int y,
	const XChar2b *string, int length) {
	fprintf(stderr, "Unimplemented stub XDrawString16\n");
	exit(EXIT_FAILURE);
	if (display || d || gc || x || y || string || length) {}
}

int XDrawText16(Display *display, Drawable d, GC gc, int x, int y,
	XTextItem16 *items, int nitems) {
	fprintf(stderr, "Unimplemented stub XDrawText16\n");
	exit(EXIT_FAILURE);
	if (display || d || gc || x || y || items || nitems) {}
}

__attribute__((noinline)) static void do_ECloseDisplay(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	CloseDisplayType proc = (void *) callback_args[0];
	Display *display = (void *) callback_args[1];
	XExtCodes *codes = (void *) callback_args[2];
	proc(display, codes);
	emu_stub_return();
}

CloseDisplayType XESetCloseDisplay(Display *display, int extension,
	CloseDisplayType proc) {
	CloseDisplayType result;
	unsigned args[] = {
		XESETCLOSEDISPLAY,
		(unsigned) &result,
		(unsigned) display,
		extension,
		(unsigned) proc
	};
	do_ECloseDisplay(callback_call(args));
	return result;
}

int XEventsQueued(Display *display, int mode) {
	int result;
	unsigned args[] = {
		XEVENTSQUEUED,
		(unsigned) &result,
		(unsigned) display,
		mode
	};
	normal_call(args);
	return result;
}

long XExtendedMaxRequestSize(Display *display) {
	long result;
	unsigned args[] = {
		XEXTENDEDMAXREQUESTSIZE,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XFillArc(Display *display, Drawable d, GC gc, int x, int y,
	unsigned int width, unsigned int height, int angle1, int angle2) {
	int result;
	unsigned args[] = {
		XFILLARC,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x,
		y,
		width,
		height,
		angle1,
		angle2
	};
	normal_call(args);
	return result;
}

int XFillPolygon(Display *display, Drawable d, GC gc, XPoint *points,
	int npoints, int shape, int mode) {
	int result;
	unsigned args[] = {
		XFILLPOLYGON,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		(unsigned) points,
		npoints,
		shape,
		mode
	};
	normal_call(args);
	return result;
}

int XFillRectangle(Display *display, Drawable d, GC gc, int x, int y,
	unsigned int width, unsigned int height) {
	int result;
	unsigned args[] = {
		XFILLRECTANGLE,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		x,
		y,
		width,
		height
	};
	normal_call(args);
	return result;
}

int XFillRectangles(Display *display, Drawable d, GC gc, XRectangle *rectangles,
	int nrectangles) {
	fprintf(stderr, "Unimplemented stub XFillRectangles\n");
	exit(EXIT_FAILURE);
	if (display || d || gc || rectangles || nrectangles) {}
}

Bool XFilterEvent(XEvent *event, Window window) {
	Bool result;
	unsigned args[] = {
		XFILTEREVENT,
		(unsigned) &result,
		(unsigned) event,
		window
	};
	normal_call(args);
	return result;
}

int XFindContext(Display *display, XID rid, XContext context,
	XPointer *data_return) {
	int result;
	unsigned args[] = {
		XFINDCONTEXT,
		(unsigned) &result,
		(unsigned) display,
		rid,
		context,
		(unsigned) data_return
	};
	normal_call(args);
	return result;
}

int XFlush(Display *display) {
	int result;
	unsigned args[] = {
		XFLUSH,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XFree(void *data) {
	int result;
	unsigned args[] = {
		XFREE,
		(unsigned) &result,
		(unsigned) data
	};
	normal_call(args);
	return result;
}

int XFreeColormap(Display *display, Colormap colormap) {
	int result;
	unsigned args[] = {
		XFREECOLORMAP,
		(unsigned) &result,
		(unsigned) display,
		colormap
	};
	normal_call(args);
	return result;
}

int XFreeColors(Display *display, Colormap colormap, unsigned long *pixels,
	int npixels, unsigned long planes) {
	fprintf(stderr, "Unimplemented stub XFreeColors\n");
	exit(EXIT_FAILURE);
	if (display || colormap || pixels || npixels || planes) {}
}

int XFreeCursor(Display *display, Cursor cursor) {
	int result;
	unsigned args[] = {
		XFREECURSOR,
		(unsigned) &result,
		(unsigned) display,
		cursor
	};
	normal_call(args);
	return result;
}

int XFreeFont(Display *display, XFontStruct *font_struct) {
	fprintf(stderr, "Unimplemented stub XFreeFont\n");
	exit(EXIT_FAILURE);
	if (display || font_struct) {}
}

int XFreeFontNames(char **list) {
	fprintf(stderr, "Unimplemented stub XFreeFontNames\n");
	exit(EXIT_FAILURE);
	if (list) {}
}

int XFreeGC(Display *display, GC gc) {
	int result;
	unsigned args[] = {
		XFREEGC,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc
	};
	normal_call(args);
	return result;
}

int XFreeModifiermap(XModifierKeymap *modmap) {
	int result;
	unsigned args[] = {
		XFREEMODIFIERMAP,
		(unsigned) &result,
		(unsigned) modmap
	};
	normal_call(args);
	return result;
}

int XFreePixmap(Display *display, Pixmap pixmap) {
	int result;
	unsigned args[] = {
		XFREEPIXMAP,
		(unsigned) &result,
		(unsigned) display,
		pixmap
	};
	normal_call(args);
	return result;
}

void XFreeStringList(char **list) {
	fprintf(stderr, "Unimplemented stub XFreeStringList\n");
	exit(EXIT_FAILURE);
	if (list) {}
}

char *_XGetAsyncReply(Display *dpy, char *replbuf, xReply *rep, char *buf,
	int len, int extra, Bool discard) {
	unsigned args[] = {
		_XGETASYNCREPLY,
		(unsigned) dpy,
		(unsigned) replbuf,
		(unsigned) rep,
		(unsigned) buf,
		len,
		extra,
		discard
	};
	normal_call(args);
	return replbuf;
}

char *XGetAtomName(Display *display, Atom atom) {
	char *result;
	unsigned args[] = {
		XGETATOMNAME,
		(unsigned) &result,
		(unsigned) display,
		atom
	};
	normal_call(args);
	return result;
}

Status XGetAtomNames(Display *dpy, Atom *atoms, int count,
	char **names_return) {
	Status result;
	unsigned args[] = {
		XGETATOMNAMES,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) atoms,
		count,
		(unsigned) names_return
	};
	normal_call(args);
	return result;
}

char *XGetDefault(Display *display, const char *program, const char *option) {
	char *result;
	unsigned args[] = {
		XGETDEFAULT,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) program,
		(unsigned) option
	};
	normal_call(args);
	return result;
}

int XGetErrorText(Display *display, int code, char *buffer_return, int length) {
	int result;
	unsigned args[] = {
		XGETERRORTEXT,
		(unsigned) &result,
		(unsigned) display,
		code,
		(unsigned) buffer_return,
		length
	};
	normal_call(args);
	return result;
}

Bool XGetFontProperty(XFontStruct *font_struct, Atom atom,
	unsigned long *value_return) {
	fprintf(stderr, "Unimplemented stub XGetFontProperty\n");
	exit(EXIT_FAILURE);
	if (font_struct || atom || value_return) {}
}

Status XGetGCValues(Display *display, GC gc, unsigned long valuemask,
	XGCValues *values_return) {
	Status result;
	unsigned args[] = {
		XGETGCVALUES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		valuemask,
		(unsigned) values_return
	};
	normal_call(args);
	return result;
}

Status XGetGeometry(Display *display, Drawable d, Window *root_return,
	int *x_return, int *y_return, unsigned int *width_return,
	unsigned int *height_return, unsigned int *border_width_return,
	unsigned int *depth_return) {
	Status result;
	unsigned args[] = {
		XGETGEOMETRY,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) root_return,
		(unsigned) x_return,
		(unsigned) y_return,
		(unsigned) width_return,
		(unsigned) height_return,
		(unsigned) border_width_return,
		(unsigned) depth_return
	};
	normal_call(args);
	return result;
}

XImage *XGetImage(Display *display, Drawable d, int x, int y,
	unsigned int width, unsigned int height, unsigned long plane_mask,
	int format) {
	XImage *result;
	unsigned args[] = {
		XGETIMAGE,
		(unsigned) &result,
		(unsigned) display,
		d,
		x,
		y,
		width,
		height,
		plane_mask,
		format
	};
	normal_call(args);
	result->f.create_image = (void *) unimplemented_image_function;
	result->f.destroy_image = destroy_image;
	result->f.get_pixel = get_pixel;
	result->f.put_pixel = put_pixel;
	result->f.sub_image = (void *) unimplemented_image_function;
	result->f.add_pixel = (void *) unimplemented_image_function;
	return result;
}

char *XGetIMValues(XIM im, ...) {
	char *result;
	unsigned *vargs;
	va_list ap;
	va_start(ap, im);
	int count = get_vargs(ap, &vargs);
	va_end(ap);
	unsigned args[] = {
		XGETIMVALUES,
		(unsigned) &result,
		(unsigned) im,
		(unsigned) vargs,
		count
	};
	normal_call(args);
	free(vargs);
	return result;
}

int XGetInputFocus(Display *display, Window *focus_return,
	int *revert_to_return) {
	int result;
	unsigned args[] = {
		XGETINPUTFOCUS,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) focus_return,
		(unsigned) revert_to_return
	};
	normal_call(args);
	return result;
}

KeySym *XGetKeyboardMapping(Display *display, KeyCode first_keycode,
	int keycode_count, int *keysyms_per_keycode_return) {
	KeySym *result;
	unsigned args[] = {
		XGETKEYBOARDMAPPING,
		(unsigned) &result,
		(unsigned) display,
		first_keycode,
		keycode_count,
		(unsigned) keysyms_per_keycode_return
	};
	normal_call(args);
	return result;
}

XModifierKeymap *XGetModifierMapping(Display *display) {
	XModifierKeymap *result;
	unsigned args[] = {
		XGETMODIFIERMAPPING,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XGetScreenSaver(Display *display, int *timeout_return, int *interval_return,
	int *prefer_blanking_return, int *allow_exposures_return) {
	fprintf(stderr, "Unimplemented stub XGetScreenSaver\n");
	exit(EXIT_FAILURE);
	if (display || timeout_return || interval_return
		|| prefer_blanking_return || allow_exposures_return) {}
}

Window XGetSelectionOwner(Display *display, Atom selection) {
	Window result;
	unsigned args[] = {
		XGETSELECTIONOWNER,
		(unsigned) &result,
		(unsigned) display,
		selection
	};
	normal_call(args);
	return result;
}

XImage *XGetSubImage(Display *display, Drawable d, int x, int y,
	unsigned int width, unsigned int height, unsigned long plane_mask,
	int format, XImage *dest_image, int dest_x, int dest_y) {
	fprintf(stderr, "Unimplemented stub XGetSubImage\n");
	exit(EXIT_FAILURE);
	if (display || d || x || y || width || height || plane_mask || format
		|| dest_image || dest_x || dest_y) {}
}

Status XGetTextProperty(Display *display, Window window,
	XTextProperty *text_prop_return, Atom property) {
	fprintf(stderr, "Unimplemented stub XGetTextProperty\n");
	exit(EXIT_FAILURE);
	if (display || window || text_prop_return || property) {}
}

XVisualInfo *XGetVisualInfo(Display *display, long vinfo_mask,
	XVisualInfo *vinfo_template, int *nitems_return) {
	XVisualInfo *result;
	unsigned args[] = {
		XGETVISUALINFO,
		(unsigned) &result,
		(unsigned) display,
		vinfo_mask,
		(unsigned) vinfo_template,
		(unsigned) nitems_return
	};
	normal_call(args);
	return result;
}

Status XGetWindowAttributes(Display *display, Window w,
	XWindowAttributes *window_attributes_return) {
	Status result;
	unsigned args[] = {
		XGETWINDOWATTRIBUTES,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) window_attributes_return
	};
	normal_call(args);
	return result;
}

int XGetWindowProperty(Display *display, Window w, Atom property,
	long long_offset, long long_length, Bool delete, Atom req_type,
	Atom *actual_type_return, int *actual_format_return,
	unsigned long *nitems_return, unsigned long *bytes_after_return,
	unsigned char **prop_return) {
	int result;
	unsigned args[] = {
		XGETWINDOWPROPERTY,
		(unsigned) &result,
		(unsigned) display,
		w,
		property,
		long_offset,
		long_length,
		delete,
		req_type,
		(unsigned) actual_type_return,
		(unsigned) actual_format_return,
		(unsigned) nitems_return,
		(unsigned) bytes_after_return,
		(unsigned) prop_return
	};
	normal_call(args);
	return result;
}

int XGrabKeyboard(Display *display, Window grab_window, Bool owner_events,
	int pointer_mode, int keyboard_mode, Time time) {
	int result;
	unsigned args[] = {
		XGRABKEYBOARD,
		(unsigned) &result,
		(unsigned) display,
		grab_window,
		owner_events,
		pointer_mode,
		keyboard_mode,
		time
	};
	normal_call(args);
	return result;
}

int XGrabPointer(Display *display, Window grab_window, Bool owner_events,
	unsigned int event_mask, int pointer_mode, int keyboard_mode,
	Window confine_to, Cursor cursor, Time time) {
	int result;
	unsigned args[] = {
		XGRABPOINTER,
		(unsigned) &result,
		(unsigned) display,
		grab_window,
		owner_events,
		event_mask,
		pointer_mode,
		keyboard_mode,
		confine_to,
		cursor,
		time
	};
	normal_call(args);
	return result;
}

int XGrabServer(Display *display) {
	int result;
	unsigned args[] = {
		XGRABSERVER,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

Status XIconifyWindow(Display *display, Window w, int screen_number) {
	fprintf(stderr, "Unimplemented stub XIconifyWindow\n");
	exit(EXIT_FAILURE);
	if (display || w || screen_number) {}
}

int XIfEvent(Display *display, XEvent *event_return,
	Bool (*predicate)(Display *, XEvent *, XPointer), XPointer arg) {
	int result;
	unsigned args[] = {
		XIFEVENT,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) event_return,
		(unsigned) predicate,
		(unsigned) arg
	};
	do_predicate(callback_call(args));
	return result;
}

Status XInitImage(XImage *image) {
	Status result;
	unsigned args[] = {
		XINITIMAGE,
		(unsigned) &result,
		(unsigned) image
	};
	normal_call(args);
	image->f.create_image = (void *) unimplemented_image_function;
	image->f.destroy_image = (void *) unimplemented_image_function;
	image->f.get_pixel = (void *) unimplemented_image_function;
	image->f.put_pixel = (void *) unimplemented_image_function;
	image->f.sub_image = (void *) unimplemented_image_function;
	image->f.add_pixel = (void *) unimplemented_image_function;
	return result;
}

void _XInitImageFuncPtrs(register XImage *image) {
	unsigned args[] = {
		_XINITIMAGEFUNCPTRS,
		(unsigned) image
	};
	normal_call(args);
}

int XInstallColormap(Display *display, Colormap colormap) {
	fprintf(stderr, "Unimplemented stub XInstallColormap\n");
	exit(EXIT_FAILURE);
	if (display || colormap) {}
}

Atom XInternAtom(Display *display, const char *atom_name, Bool only_if_exists) {
	Atom result;
	unsigned args[] = {
		XINTERNATOM,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) atom_name,
		only_if_exists
	};
	normal_call(args);
	return result;
}

Status XInternAtoms(Display *dpy, char **names, int count, Bool onlyIfExists,
	Atom *atoms_return) {
	Status result;
	unsigned args[] = {
		XINTERNATOMS,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) names,
		count,
		onlyIfExists,
		(unsigned) atoms_return
	};
	normal_call(args);
	return result;
}

int XIntersectRegion(Region sra, Region srb, Region dr_return) {
	int result;
	unsigned args[] = {
		XINTERSECTREGION,
		(unsigned) &result,
		(unsigned) sra,
		(unsigned) srb,
		(unsigned) dr_return
	};
	normal_call(args);
	return result;
}

Bool XkbBell(Display *dpy, Window win, int percent, Atom name) {
	Bool result;
	unsigned args[] = {
		XKBBELL,
		(unsigned) &result,
		(unsigned) dpy,
		win,
		percent,
		name
	};
	normal_call(args);
	return result;
}

XkbDescPtr XkbGetMap(Display *dpy, unsigned int which,
	unsigned int deviceSpec) {
	XkbDescPtr result;
	unsigned args[] = {
		XKBGETMAP,
		(unsigned) &result,
		(unsigned) dpy,
		which,
		deviceSpec
	};
	normal_call(args);
	return result;
}

Status XkbGetNames(Display *dpy, unsigned int which, XkbDescPtr desc) {
	Status result;
	unsigned args[] = {
		XKBGETNAMES,
		(unsigned) &result,
		(unsigned) dpy,
		which,
		(unsigned) desc
	};
	normal_call(args);
	return result;
}

Status XkbGetState(Display *dpy, unsigned int deviceSpec,
	XkbStatePtr rtrnState) {
	Status result;
	unsigned args[] = {
		XKBGETSTATE,
		(unsigned) &result,
		(unsigned) dpy,
		deviceSpec,
		(unsigned) rtrnState
	};
	normal_call(args);
	return result;
}

Status XkbGetUpdatedMap(Display *dpy, unsigned int which, XkbDescPtr desc) {
	Status result;
	unsigned args[] = {
		XKBGETUPDATEDMAP,
		(unsigned) &result,
		(unsigned) dpy,
		which,
		(unsigned) desc
	};
	normal_call(args);
	return result;
}

unsigned int XkbKeysymToModifiers(Display *dpy, KeySym ks) {
	unsigned int result;
	unsigned args[] = {
		XKBKEYSYMTOMODIFIERS,
		(unsigned) &result,
		(unsigned) dpy,
		ks
	};
	normal_call(args);
	return result;
}

Bool XkbLibraryVersion(int *libMajorRtrn, int *libMinorRtrn) {
	Bool result;
	unsigned args[] = {
		XKBLIBRARYVERSION,
		(unsigned) &result,
		(unsigned) libMajorRtrn,
		(unsigned) libMinorRtrn
	};
	normal_call(args);
	return result;
}

Bool XkbQueryExtension(Display *dpy, int *opcodeReturn, int *eventBaseReturn,
	int *errorBaseReturn, int *majorRtrn, int *minorRtrn) {
	Bool result;
	unsigned args[] = {
		XKBQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) opcodeReturn,
		(unsigned) eventBaseReturn,
		(unsigned) errorBaseReturn,
		(unsigned) majorRtrn,
		(unsigned) minorRtrn
	};
	normal_call(args);
	return result;
}

Bool XkbSelectEventDetails(Display *dpy, unsigned int deviceID,
	unsigned int eventType, unsigned long affect, unsigned long details) {
	Bool result;
	unsigned args[] = {
		XKBSELECTEVENTDETAILS,
		(unsigned) &result,
		(unsigned) dpy,
		deviceID,
		eventType,
		affect,
		details
	};
	normal_call(args);
	return result;
}

Bool XkbSelectEvents(Display *dpy, unsigned int deviceID, unsigned int affect,
	unsigned int values) {
	Bool result;
	unsigned args[] = {
		XKBSELECTEVENTS,
		(unsigned) &result,
		(unsigned) dpy,
		deviceID,
		affect,
		values
	};
	normal_call(args);
	return result;
}

Bool XkbSetDetectableAutoRepeat(Display *dpy, Bool detectable,
	Bool *supported) {
	Bool result;
	unsigned args[] = {
		XKBSETDETECTABLEAUTOREPEAT,
		(unsigned) &result,
		(unsigned) dpy,
		detectable,
		(unsigned) supported
	};
	normal_call(args);
	return result;
}

int XkbTranslateKeySym(Display *dpy, register KeySym *sym_return,
	unsigned int modifiers, char *buffer, int nbytes, int *extra_rtrn) {
	int result;
	unsigned args[] = {
		XKBTRANSLATEKEYSYM,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) sym_return,
		modifiers,
		(unsigned) buffer,
		nbytes,
		(unsigned) extra_rtrn
	};
	normal_call(args);
	return result;
}

Bool XkbUseExtension(Display *dpy, int *major_rtrn, int *minor_rtrn) {
	Bool result;
	unsigned args[] = {
		XKBUSEEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) major_rtrn,
		(unsigned) minor_rtrn
	};
	normal_call(args);
	return result;
}

KeySym XKeycodeToKeysym(Display *display, KeyCode keycode, int index) {
	KeySym result;
	unsigned args[] = {
		XKEYCODETOKEYSYM,
		(unsigned) &result,
		(unsigned) display,
		keycode,
		index
	};
	normal_call(args);
	return result;
}

KeyCode XKeysymToKeycode(Display *display, KeySym keysym) {
	KeyCode result;
	unsigned args[] = {
		XKEYSYMTOKEYCODE,
		(unsigned) &result,
		(unsigned) display,
		keysym
	};
	normal_call(args);
	return result;
}

char *XKeysymToString(KeySym keysym) {
	char *result;
	unsigned args[] = {
		XKEYSYMTOSTRING,
		(unsigned) &result,
		keysym
	};
	normal_call(args);
	return result;
}

int *XListDepths(Display *display, int screen_number, int *count_return) {
	int *result;
	unsigned args[] = {
		XLISTDEPTHS,
		(unsigned) &result,
		(unsigned) display,
		screen_number,
		(unsigned) count_return
	};
	normal_call(args);
	return result;
}

char **XListFonts(Display *display, const char *pattern, int maxnames,
	int *actual_count_return) {
	fprintf(stderr, "Unimplemented stub XListFonts\n");
	exit(EXIT_FAILURE);
	if (display || pattern || maxnames || actual_count_return) {}
}

XPixmapFormatValues *XListPixmapFormats(Display *display, int *count_return) {
	XPixmapFormatValues *result;
	unsigned args[] = {
		XLISTPIXMAPFORMATS,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) count_return
	};
	normal_call(args);
	return result;
}

XFontStruct *XLoadQueryFont(Display *display, const char *name) {
	fprintf(stderr, "Unimplemented stub XLoadQueryFont\n");
	exit(EXIT_FAILURE);
	if (display || name) {}
}

char *XLocaleOfIM(XIM im) {
	char *result;
	unsigned args[] = {
		XLOCALEOFIM,
		(unsigned) &result,
		(unsigned) im
	};
	normal_call(args);
	return result;
}

Status XLookupColor(Display *display, Colormap colormap, const char *color_name,
	XColor *exact_def_return, XColor *screen_def_return) {
	Status result;
	unsigned args[] = {
		XLOOKUPCOLOR,
		(unsigned) &result,
		(unsigned) display,
		colormap,
		(unsigned) color_name,
		(unsigned) exact_def_return,
		(unsigned) screen_def_return
	};
	normal_call(args);
	return result;
}

KeySym XLookupKeysym(XKeyEvent *key_event, int index) {
	KeySym result;
	unsigned args[] = {
		XLOOKUPKEYSYM,
		(unsigned) &result,
		(unsigned) key_event,
		index
	};
	normal_call(args);
	return result;
}

int XLookupString(XKeyEvent *event_struct, char *buffer_return,
	int bytes_buffer, KeySym *keysym_return,
	XComposeStatus *status_in_out) {
	int result;
	unsigned args[] = {
		XLOOKUPSTRING,
		(unsigned) &result,
		(unsigned) event_struct,
		(unsigned) buffer_return,
		bytes_buffer,
		(unsigned) keysym_return,
		(unsigned) status_in_out
	};
	normal_call(args);
	return result;
}

int XLowerWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XLOWERWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

int XMapSubwindows(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XMAPSUBWINDOWS,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

int XMapWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XMAPWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

Status XMatchVisualInfo(Display *display, int screen, int depth, int class,
	XVisualInfo *vinfo_return) {
	fprintf(stderr, "Unimplemented stub XMatchVisualInfo\n");
	exit(EXIT_FAILURE);
	if (display || screen || depth || class || vinfo_return) {}
}

long XMaxRequestSize(Display *display) {
	long result;
	unsigned args[] = {
		XMAXREQUESTSIZE,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XmbLookupString(XIC ic, XKeyPressedEvent *event, char *buffer_return,
	int bytes_buffer, KeySym *keysym_return, Status *status_return) {
	int result;
	unsigned args[] = {
		XMBLOOKUPSTRING,
		(unsigned) &result,
		(unsigned) ic,
		(unsigned) event,
		(unsigned) buffer_return,
		bytes_buffer,
		(unsigned) keysym_return,
		(unsigned) status_return
	};
	normal_call(args);
	return result;
}

char *XmbResetIC(XIC ic) {
	fprintf(stderr, "Unimplemented stub XmbResetIC\n");
	exit(EXIT_FAILURE);
	if (ic) {}
}

void XmbSetWMProperties(Display *display, Window w, const char *window_name,
	const char *icon_name, char **argv, int argc, XSizeHints *normal_hints,
	XWMHints *wm_hints, XClassHint *class_hints) {
	unsigned args[] = {
		XMBSETWMPROPERTIES,
		(unsigned) display,
		w,
		(unsigned) window_name,
		(unsigned) icon_name,
		(unsigned) argv,
		argc,
		(unsigned) normal_hints,
		(unsigned) wm_hints,
		(unsigned) class_hints
	};
	normal_call(args);
}

int XmbTextListToTextProperty(Display *display, char **list, int count,
	XICCEncodingStyle style, XTextProperty *text_prop_return) {
	int result;
	unsigned args[] = {
		XMBTEXTLISTTOTEXTPROPERTY,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) list,
		count,
		style,
		(unsigned) text_prop_return
	};
	normal_call(args);
	return result;
}

int XmbTextPropertyToTextList(Display *display, const XTextProperty *text_prop,
	char ***list_return, int *count_return) {
	fprintf(stderr, "Unimplemented stub XmbTextPropertyToTextList\n");
	exit(EXIT_FAILURE);
	if (display || text_prop || list_return || count_return) {}
}

int XMoveResizeWindow(Display *display, Window w, int x, int y,
	unsigned int width, unsigned int height) {
	int result;
	unsigned args[] = {
		XMOVERESIZEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		x,
		y,
		width,
		height
	};
	normal_call(args);
	return result;
}

int XMoveWindow(Display *display, Window w, int x, int y) {
	int result;
	unsigned args[] = {
		XMOVEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		x,
		y
	};
	normal_call(args);
	return result;
}

int XNextEvent(Display *display, XEvent *event_return) {
	int result;
	unsigned args[] = {
		XNEXTEVENT,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) event_return
	};
	normal_call(args);
	return result;
}

Display *XOpenDisplay(const char *display_name) {
	Display *result;
	unsigned args[] = {
		XOPENDISPLAY,
		(unsigned) &result,
		(unsigned) display_name
	};
	normal_call(args);
	return result;
}

XIM XOpenIM(Display *dpy, struct _XrmHashBucketRec *rdb, char *res_name,
	char *res_class) {
	XIM result;
	unsigned args[] = {
		XOPENIM,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) rdb,
		(unsigned) res_name,
		(unsigned) res_class
	};
	normal_call(args);
	return result;
}

int XPending(Display *display) {
	int result;
	unsigned args[] = {
		XPENDING,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XPutImage(Display *display, Drawable d, GC gc, XImage *image, int src_x,
	int src_y, int dest_x, int dest_y, unsigned int width,
	unsigned int height) {
	int result;
	unsigned args[] = {
		XPUTIMAGE,
		(unsigned) &result,
		(unsigned) display,
		d,
		(unsigned) gc,
		(unsigned) image,
		src_x,
		src_y,
		dest_x,
		dest_y,
		width,
		height
	};
	normal_call(args);
	return result;
}

int XQueryColor(Display *display, Colormap colormap, XColor *def_in_out) {
	fprintf(stderr, "Unimplemented stub XQueryColor\n");
	exit(EXIT_FAILURE);
	if (display || colormap || def_in_out) {}
}

int XQueryColors(Display *display, Colormap colormap, XColor *defs_in_out,
	int ncolors) {
	int result;
	unsigned args[] = {
		XQUERYCOLORS,
		(unsigned) &result,
		(unsigned) display,
		colormap,
		(unsigned) defs_in_out,
		ncolors
	};
	normal_call(args);
	return result;
}

Bool XQueryExtension(Display *display, const char *name,
	int *major_opcode_return, int *first_event_return,
	int *first_error_return) {
	Bool result;
	unsigned args[] = {
		XQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) name,
		(unsigned) major_opcode_return,
		(unsigned) first_event_return,
		(unsigned) first_error_return
	};
	normal_call(args);
	return result;
}

int XQueryKeymap(Display *display, char keys_return[32]) {
	int result;
	unsigned args[] = {
		XQUERYKEYMAP,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) keys_return
	};
	normal_call(args);
	return result;
}

Bool XQueryPointer(Display *display, Window w, Window *root_return,
	Window *child_return, int *root_x_return, int *root_y_return,
	int *win_x_return, int *win_y_return, unsigned int *mask_return) {
	Bool result;
	unsigned args[] = {
		XQUERYPOINTER,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) root_return,
		(unsigned) child_return,
		(unsigned) root_x_return,
		(unsigned) root_y_return,
		(unsigned) win_x_return,
		(unsigned) win_y_return,
		(unsigned) mask_return
	};
	normal_call(args);
	return result;
}

Status XQueryTree(Display *display, Window w, Window *root_return,
	Window *parent_return, Window **children_return,
	unsigned int *nchildren_return) {
	Status result;
	unsigned args[] = {
		XQUERYTREE,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) root_return,
		(unsigned) parent_return,
		(unsigned) children_return,
		(unsigned) nchildren_return
	};
	normal_call(args);
	return result;
}

int XRaiseWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XRAISEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

Status XReconfigureWMWindow(Display *display, Window w, int screen_number,
	unsigned int mask, XWindowChanges *changes) {
	Status result;
	unsigned args[] = {
		XRECONFIGUREWMWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		screen_number,
		mask,
		(unsigned) changes
	};
	normal_call(args);
	return result;
}

int XRefreshKeyboardMapping(XMappingEvent *event_map) {
	fprintf(stderr, "Unimplemented stub XRefreshKeyboardMapping\n");
	exit(EXIT_FAILURE);
	if (event_map) {}
}

Bool XRegisterIMInstantiateCallback(Display *dpy, struct _XrmHashBucketRec *rdb,
	char *res_name, char *res_class, XIDProc callback,
	XPointer client_data) {
	fprintf(stderr, "Unimplemented stub XRegisterIMInstantiateCallback\n");
	exit(EXIT_FAILURE);
	if (dpy || rdb || res_name || res_class || callback || client_data) {}
}

int XReparentWindow(Display *display, Window w, Window parent, int x, int y) {
	int result;
	unsigned args[] = {
		XREPARENTWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		parent,
		x,
		y
	};
	normal_call(args);
	return result;
}

int XResizeWindow(Display *display, Window w, unsigned int width,
	unsigned int height) {
	int result;
	unsigned args[] = {
		XRESIZEWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		width,
		height
	};
	normal_call(args);
	return result;
}

char *XResourceManagerString(Display *display) {
	char *result;
	unsigned args[] = {
		XRESOURCEMANAGERSTRING,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

void XrmCombineDatabase(XrmDatabase source_db, XrmDatabase *target_db,
	Bool override) {
	unsigned args[] = {
		XRMCOMBINEDATABASE,
		(unsigned) source_db,
		(unsigned) target_db,
		override
	};
	normal_call(args);
}

Status XrmCombineFileDatabase(const char *filename, XrmDatabase *target,
	Bool override) {
	Status result;
	unsigned args[] = {
		XRMCOMBINEFILEDATABASE,
		(unsigned) &result,
		(unsigned) filename,
		(unsigned) target,
		override
	};
	normal_call(args);
	return result;
}

void XrmDestroyDatabase(XrmDatabase database) {
	unsigned args[] = {
		XRMDESTROYDATABASE,
		(unsigned) database
	};
	normal_call(args);
}

XrmDatabase XrmGetDatabase(Display *display) {
	XrmDatabase result;
	unsigned args[] = {
		XRMGETDATABASE,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

XrmDatabase XrmGetFileDatabase(const char *filename) {
	XrmDatabase result;
	unsigned args[] = {
		XRMGETFILEDATABASE,
		(unsigned) &result,
		(unsigned) filename
	};
	normal_call(args);
	return result;
}

Bool XrmGetResource(XrmDatabase database, const char *str_name,
	const char *str_class, char **str_type_return, XrmValue *value_return) {
	Bool result;
	unsigned args[] = {
		XRMGETRESOURCE,
		(unsigned) &result,
		(unsigned) database,
		(unsigned) str_name,
		(unsigned) str_class,
		(unsigned) str_type_return,
		(unsigned) value_return
	};
	normal_call(args);
	return result;
}

XrmDatabase XrmGetStringDatabase(const char *data) {
	XrmDatabase result;
	unsigned args[] = {
		XRMGETSTRINGDATABASE,
		(unsigned) &result,
		(unsigned) data
	};
	normal_call(args);
	return result;
}

void XrmInitialize(void) {
	unsigned args[] = {
		XRMINITIALIZE
	};
	normal_call(args);
}

void XrmMergeDatabases(XrmDatabase source_db, XrmDatabase *target_db) {
	unsigned args[] = {
		XRMMERGEDATABASES,
		(unsigned) source_db,
		(unsigned) target_db
	};
	normal_call(args);
}

void XrmParseCommand(XrmDatabase *database, XrmOptionDescList table,
	int table_count, const char *name, int *argc_in_out,
	char **argv_in_out) {
	unsigned args[] = {
		XRMPARSECOMMAND,
		(unsigned) database,
		(unsigned) table,
		table_count,
		(unsigned) name,
		(unsigned) argc_in_out,
		(unsigned) argv_in_out
	};
	normal_call(args);
}

XrmQuark XrmPermStringToQuark(const char *string) {
	XrmQuark result;
	unsigned args[] = {
		XRMPERMSTRINGTOQUARK,
		(unsigned) &result,
		(unsigned) string
	};
	normal_call(args);
	return result;
}

Bool XrmQGetResource(XrmDatabase database, XrmNameList quark_name,
	XrmClassList quark_class, XrmRepresentation *quark_type_return,
	XrmValue *value_return) {
	Bool result;
	unsigned args[] = {
		XRMQGETRESOURCE,
		(unsigned) &result,
		(unsigned) database,
		(unsigned) quark_name,
		(unsigned) quark_class,
		(unsigned) quark_type_return,
		(unsigned) value_return
	};
	normal_call(args);
	return result;
}

Bool XrmQGetSearchList(XrmDatabase database, XrmNameList names,
	XrmClassList classes, XrmSearchList list_return, int list_length) {
	Bool result;
	unsigned args[] = {
		XRMQGETSEARCHLIST,
		(unsigned) &result,
		(unsigned) database,
		(unsigned) names,
		(unsigned) classes,
		(unsigned) list_return,
		list_length
	};
	normal_call(args);
	return result;
}

Bool XrmQGetSearchResource(XrmSearchList list, XrmName name, XrmClass class,
	XrmRepresentation *type_return, XrmValue *value_return) {
	Bool result;
	unsigned args[] = {
		XRMQGETSEARCHRESOURCE,
		(unsigned) &result,
		(unsigned) list,
		name,
		class,
		(unsigned) type_return,
		(unsigned) value_return
	};
	normal_call(args);
	return result;
}

XrmString XrmQuarkToString(XrmQuark quark) {
	XrmString result;
	unsigned args[] = {
		XRMQUARKTOSTRING,
		(unsigned) &result,
		quark
	};
	normal_call(args);
	return result;
}

void XrmSetDatabase(Display *display, XrmDatabase database) {
	unsigned args[] = {
		XRMSETDATABASE,
		(unsigned) display,
		(unsigned) database
	};
	normal_call(args);
}

XrmQuark XrmStringToQuark(const char *string) {
	XrmQuark result;
	unsigned args[] = {
		XRMSTRINGTOQUARK,
		(unsigned) &result,
		(unsigned) string
	};
	normal_call(args);
	return result;
}

XrmQuark XrmUniqueQuark(void) {
	XrmQuark result;
	unsigned args[] = {
		XRMUNIQUEQUARK,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

Window XRootWindowOfScreen(Screen *screen) {
	return RootWindowOfScreen(screen);
}

int XSaveContext(Display *display, XID rid, XContext context,
	const char *data) {
	int result;
	unsigned args[] = {
		XSAVECONTEXT,
		(unsigned) &result,
		(unsigned) display,
		rid,
		context,
		(unsigned) data
	};
	normal_call(args);
	return result;
}

int XScreenNumberOfScreen(Screen *screen) {
	int result;
	unsigned args[] = {
		XSCREENNUMBEROFSCREEN,
		(unsigned) &result,
		(unsigned) screen
	};
	normal_call(args);
	return result;
}

char *XScreenResourceString(Screen *screen) {
	char *result;
	unsigned args[] = {
		XSCREENRESOURCESTRING,
		(unsigned) &result,
		(unsigned) screen
	};
	normal_call(args);
	return result;
}

int XSelectInput(Display *display, Window w, long event_mask) {
	int result;
	unsigned args[] = {
		XSELECTINPUT,
		(unsigned) &result,
		(unsigned) display,
		w,
		event_mask
	};
	normal_call(args);
	return result;
}

Status XSendEvent(Display *display, Window w, Bool propagate, long event_mask,
	XEvent *event_send) {
	Status result;
	unsigned args[] = {
		XSENDEVENT,
		(unsigned) &result,
		(unsigned) display,
		w,
		propagate,
		event_mask,
		(unsigned) event_send
	};
	normal_call(args);
	return result;
}

int XSetArcMode(Display *display, GC gc, int arc_mode) {
	int result;
	unsigned args[] = {
		XSETARCMODE,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		arc_mode
	};
	normal_call(args);
	return result;
}

int XSetBackground(Display *display, GC gc, unsigned long background) {
	int result;
	unsigned args[] = {
		XSETBACKGROUND,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		background
	};
	normal_call(args);
	return result;
}

int XSetClassHint(Display *display, Window w, XClassHint *class_hints) {
	int result;
	unsigned args[] = {
		XSETCLASSHINT,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) class_hints
	};
	normal_call(args);
	return result;
}

int XSetClipMask(Display *display, GC gc, Pixmap pixmap) {
	int result;
	unsigned args[] = {
		XSETCLIPMASK,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		pixmap
	};
	normal_call(args);
	return result;
}

int XSetClipOrigin(Display *display, GC gc, int clip_x_origin,
	int clip_y_origin) {
	int result;
	unsigned args[] = {
		XSETCLIPORIGIN,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		clip_x_origin,
		clip_y_origin
	};
	normal_call(args);
	return result;
}

int XSetClipRectangles(Display *display, GC gc, int clip_x_origin,
	int clip_y_origin, XRectangle *rectangles, int n, int ordering) {
	int result;
	unsigned args[] = {
		XSETCLIPRECTANGLES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		clip_x_origin,
		clip_y_origin,
		(unsigned) rectangles,
		n,
		ordering
	};
	normal_call(args);
	return result;
}

int XSetDashes(Display *display, GC gc, int dash_offset, const char *dash_list,
	int n) {
	int result;
	unsigned args[] = {
		XSETDASHES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		dash_offset,
		(unsigned) dash_list,
		n
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_ErrorHandler(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	for (;;) {
		XErrorHandler handler = (void *) callback_args[0];
		Display *display = (void *) callback_args[1];
		XErrorEvent *error_event = (void *) callback_args[2];
		handler(display, error_event);
		emu_stub_return();
	}
}

XErrorHandler XSetErrorHandler(XErrorHandler handler) {
	XErrorHandler result;
	unsigned args[] = {
		XSETERRORHANDLER,
		(unsigned) &result,
		(unsigned) handler
	};
	static int once = 1;
	if (once) {
		once = 0;
		do_ErrorHandler(callback_call(args));
	}
	else
		normal_call(args);
	return result;
}

int XSetFillStyle(Display *display, GC gc, int fill_style) {
	fprintf(stderr, "Unimplemented stub XSetFillStyle\n");
	exit(EXIT_FAILURE);
	if (display || gc || fill_style) {}
}

int XSetForeground(Display *display, GC gc, unsigned long foreground) {
	int result;
	unsigned args[] = {
		XSETFOREGROUND,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		foreground
	};
	normal_call(args);
	return result;
}

int XSetFunction(Display *display, GC gc, int function) {
	int result;
	unsigned args[] = {
		XSETFUNCTION,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		function
	};
	normal_call(args);
	return result;
}

int XSetGraphicsExposures(Display *display, GC gc, Bool graphics_exposures) {
	int result;
	unsigned args[] = {
		XSETGRAPHICSEXPOSURES,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		graphics_exposures
	};
	normal_call(args);
	return result;
}

void XSetICFocus(XIC ic) {
	unsigned args[] = {
		XSETICFOCUS,
		(unsigned) ic
	};
	normal_call(args);
}

char *XSetIMValues(XIM im, ...) {
	char *result;
	unsigned *vargs;
	va_list ap;
	va_start(ap, im);
	int count = get_vargs(ap, &vargs);
	va_end(ap);
	unsigned args[] = {
		XSETIMVALUES,
		(unsigned) &result,
		(unsigned) im,
		(unsigned) vargs,
		count
	};
	normal_call(args);
	free(vargs);
	return result;
}

int XSetInputFocus(Display *display, Window focus, int revert_to, Time time) {
	int result;
	unsigned args[] = {
		XSETINPUTFOCUS,
		(unsigned) &result,
		(unsigned) display,
		focus,
		revert_to,
		time
	};
	normal_call(args);
	return result;
}

XIOErrorHandler XSetIOErrorHandler(XIOErrorHandler handler) {
	XIOErrorHandler result;
	unsigned args[] = {
		XSETIOERRORHANDLER,
		(unsigned) &result,
		(unsigned) handler
	};
	normal_call(args);
	return result;
}

char *XSetLocaleModifiers(const char *modifier_list) {
	char *result;
	unsigned args[] = {
		XSETLOCALEMODIFIERS,
		(unsigned) &result,
		(unsigned) modifier_list
	};
	normal_call(args);
	return result;
}

int XSetNormalHints(Display *display, Window w, XSizeHints *hints) {
	int result;
	unsigned args[] = {
		XSETNORMALHINTS,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) hints
	};
	normal_call(args);
	return result;
}

int XSetScreenSaver(Display *display, int timeout, int interval,
	int prefer_blanking, int allow_exposures) {
	fprintf(stderr, "Unimplemented stub XSetScreenSaver\n");
	exit(EXIT_FAILURE);
	if (display || timeout || interval || prefer_blanking
		|| allow_exposures) {}
}

int XSetSelectionOwner(Display *display, Atom selection, Window owner,
	Time time) {
	int result;
	unsigned args[] = {
		XSETSELECTIONOWNER,
		(unsigned) &result,
		(unsigned) display,
		selection,
		owner,
		time
	};
	normal_call(args);
	return result;
}

int XSetStandardProperties(Display *display, Window w, const char *window_name,
	const char *icon_name, Pixmap icon_pixmap, char **argv, int argc,
	XSizeHints *hints) {
	int result;
	unsigned args[] = {
		XSETSTANDARDPROPERTIES,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) window_name,
		(unsigned) icon_name,
		icon_pixmap,
		(unsigned) argv,
		argc,
		(unsigned) hints
	};
	normal_call(args);
	return result;
}

int XSetSubwindowMode(Display *display, GC gc, int subwindow_mode) {
	int result;
	unsigned args[] = {
		XSETSUBWINDOWMODE,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		subwindow_mode
	};
	normal_call(args);
	return result;
}

void XSetTextProperty(Display *display, Window w, XTextProperty *text_prop,
	Atom property) {
	fprintf(stderr, "Unimplemented stub XSetTextProperty\n");
	exit(EXIT_FAILURE);
	if (display || w || text_prop || property) {}
}

int XSetTransientForHint(Display *display, Window w, Window prop_window) {
	int result;
	unsigned args[] = {
		XSETTRANSIENTFORHINT,
		(unsigned) &result,
		(unsigned) display,
		w,
		prop_window
	};
	normal_call(args);
	return result;
}

int XSetTSOrigin(Display *display, GC gc, int ts_x_origin, int ts_y_origin) {
	int result;
	unsigned args[] = {
		XSETTSORIGIN,
		(unsigned) &result,
		(unsigned) display,
		(unsigned) gc,
		ts_x_origin,
		ts_y_origin
	};
	normal_call(args);
	return result;
}

int XSetWindowBackground(Display *display, Window w,
	unsigned long background_pixel) {
	int result;
	unsigned args[] = {
		XSETWINDOWBACKGROUND,
		(unsigned) &result,
		(unsigned) display,
		w,
		background_pixel
	};
	normal_call(args);
	return result;
}

int XSetWindowBackgroundPixmap(Display *display, Window w,
	Pixmap background_pixmap) {
	int result;
	unsigned args[] = {
		XSETWINDOWBACKGROUNDPIXMAP,
		(unsigned) &result,
		(unsigned) display,
		w,
		background_pixmap
	};
	normal_call(args);
	return result;
}

int XSetWMHints(Display *display, Window w, XWMHints *wm_hints) {
	int result;
	unsigned args[] = {
		XSETWMHINTS,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) wm_hints
	};
	normal_call(args);
	return result;
}

void XSetWMIconName(Display *display, Window w, XTextProperty *text_prop) {
	unsigned args[] = {
		XSETWMICONNAME,
		(unsigned) display,
		w,
		(unsigned) text_prop
	};
	normal_call(args);
}

void XSetWMName(Display *display, Window w, XTextProperty *text_prop) {
	unsigned args[] = {
		XSETWMNAME,
		(unsigned) display,
		w,
		(unsigned) text_prop
	};
	normal_call(args);
}

void XSetWMNormalHints(Display *display, Window w, XSizeHints *hints) {
	unsigned args[] = {
		XSETWMNORMALHINTS,
		(unsigned) display,
		w,
		(unsigned) hints
	};
	normal_call(args);
}

void XSetWMProperties(Display *display, Window w, XTextProperty *window_name,
	XTextProperty *icon_name, char **argv, int argc,
	XSizeHints *normal_hints, XWMHints *wm_hints, XClassHint *class_hints) {
	unsigned args[] = {
		XSETWMPROPERTIES,
		(unsigned) display,
		w,
		(unsigned) window_name,
		(unsigned) icon_name,
		(unsigned) argv,
		argc,
		(unsigned) normal_hints,
		(unsigned) wm_hints,
		(unsigned) class_hints
	};
	normal_call(args);
}

Status XSetWMProtocols(Display *display, Window w, Atom *protocols, int count) {
	Status result;
	unsigned args[] = {
		XSETWMPROTOCOLS,
		(unsigned) &result,
		(unsigned) display,
		w,
		(unsigned) protocols,
		count
	};
	normal_call(args);
	return result;
}

int XStoreColor(Display *display, Colormap colormap, XColor *color) {
	fprintf(stderr, "Unimplemented stub XStoreColor\n");
	exit(EXIT_FAILURE);
	if (display || colormap || color) {}
}

KeySym XStringToKeysym(const char *string) {
	KeySym result;
	unsigned args[] = {
		XSTRINGTOKEYSYM,
		(unsigned) &result,
		(unsigned) string
	};
	normal_call(args);
	return result;
}

Bool XSupportsLocale(void) {
	Bool result;
	unsigned args[] = {
		XSUPPORTSLOCALE,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int XSync(Display *display, Bool discard) {
	int result;
	unsigned args[] = {
		XSYNC,
		(unsigned) &result,
		(unsigned) display,
		discard
	};
	normal_call(args);
	return result;
}

int do_synchronize(Display *display) {
	fprintf(stderr, "synchronize function called!\n");
	exit(EXIT_FAILURE);
	if (display) {}
}

int (*XSynchronize(Display *display, Bool onoff))(Display *) {
	int (*result)(Display *);
	unsigned args[] = {
		XSYNCHRONIZE,
		(unsigned) &result,
		(unsigned) display,
		onoff
	};
	normal_call(args);
	result = do_synchronize;
	return result;
}

int XTextExtents16(XFontStruct *font_struct, const XChar2b *string, int nchars,
	int *direction_return, int *font_ascent_return,
	int *font_descent_return, XCharStruct *overall_return) {
	fprintf(stderr, "Unimplemented stub XTextExtents16\n");
	exit(EXIT_FAILURE);
	if (font_struct || string || nchars || direction_return
		|| font_ascent_return || font_descent_return
		|| overall_return) {}
}

int XTextWidth16(XFontStruct *font_struct, const XChar2b *string, int count) {
	fprintf(stderr, "Unimplemented stub XTextWidth16\n");
	exit(EXIT_FAILURE);
	if (font_struct || string || count) {}
}

Bool XTranslateCoordinates(Display *display, Window src_w, Window dest_w,
	int src_x, int src_y, int *dest_x_return, int *dest_y_return,
	Window *child_return) {
	Bool result;
	unsigned args[] = {
		XTRANSLATECOORDINATES,
		(unsigned) &result,
		(unsigned) display,
		src_w,
		dest_w,
		src_x,
		src_y,
		(unsigned) dest_x_return,
		(unsigned) dest_y_return,
		(unsigned) child_return
	};
	normal_call(args);
	return result;
}

int XUngrabKeyboard(Display *display, Time time) {
	int result;
	unsigned args[] = {
		XUNGRABKEYBOARD,
		(unsigned) &result,
		(unsigned) display,
		time
	};
	normal_call(args);
	return result;
}

int XUngrabPointer(Display *display, Time time) {
	int result;
	unsigned args[] = {
		XUNGRABPOINTER,
		(unsigned) &result,
		(unsigned) display,
		time
	};
	normal_call(args);
	return result;
}

int XUngrabServer(Display *display) {
	int result;
	unsigned args[] = {
		XUNGRABSERVER,
		(unsigned) &result,
		(unsigned) display
	};
	normal_call(args);
	return result;
}

int XUninstallColormap(Display *display, Colormap colormap) {
	fprintf(stderr, "Unimplemented stub XUninstallColormap\n");
	exit(EXIT_FAILURE);
	if (display || colormap) {}
}

int XUnionRectWithRegion(XRectangle *rectangle, Region src_region,
	Region dest_region_return) {
	int result;
	unsigned args[] = {
		XUNIONRECTWITHREGION,
		(unsigned) &result,
		(unsigned) rectangle,
		(unsigned) src_region,
		(unsigned) dest_region_return
	};
	normal_call(args);
	return result;
}

int XUnmapWindow(Display *display, Window w) {
	int result;
	unsigned args[] = {
		XUNMAPWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w
	};
	normal_call(args);
	return result;
}

Bool XUnregisterIMInstantiateCallback(Display *dpy,
	struct _XrmHashBucketRec *rdb, char *res_name, char *res_class,
	XIDProc callback, XPointer client_data) {
	fprintf(stderr,
		"Unimplemented stub XUnregisterIMInstantiateCallback\n");
	exit(EXIT_FAILURE);
	if (dpy || rdb || res_name || res_class || callback || client_data) {}
}

void XUnsetICFocus(XIC ic) {
	unsigned args[] = {
		XUNSETICFOCUS,
		(unsigned) ic
	};
	normal_call(args);
}

XVaNestedList XVaCreateNestedList(int unused, ...) {
	fprintf(stderr, "Unimplemented stub XVaCreateNestedList\n");
	exit(EXIT_FAILURE);
	if (unused) {}
}

VisualID XVisualIDFromVisual(Visual *visual) {
	return visual->visualid;
}

int XWarpPointer(Display *display, Window src_w, Window dest_w, int src_x,
	int src_y, unsigned int src_width, unsigned int src_height, int dest_x,
	int dest_y) {
	fprintf(stderr, "Unimplemented stub XWarpPointer\n");
	exit(EXIT_FAILURE);
	if (display || src_w || dest_w || src_x || src_y || src_width
		|| src_height || dest_x || dest_y) {}
}

int XWindowEvent(Display *display, Window w, long event_mask,
	XEvent *event_return) {
	int result;
	unsigned args[] = {
		XWINDOWEVENT,
		(unsigned) &result,
		(unsigned) display,
		w,
		event_mask,
		(unsigned) event_return
	};
	normal_call(args);
	return result;
}

Status XWithdrawWindow(Display *display, Window w, int screen_number) {
	Status result;
	unsigned args[] = {
		XWITHDRAWWINDOW,
		(unsigned) &result,
		(unsigned) display,
		w,
		screen_number
	};
	normal_call(args);
	return result;
}

int XWMGeometry(Display *display, int screen_number, const char *user_geometry,
	const char *default_geometry, unsigned int border_width,
	XSizeHints *hints, int *x_return, int *y_return, int *width_return,
	int *height_return, int *gravity_return) {
	int result;
	unsigned args[] = {
		XWMGEOMETRY,
		(unsigned) &result,
		(unsigned) display,
		screen_number,
		(unsigned) user_geometry,
		(unsigned) default_geometry,
		border_width,
		(unsigned) hints,
		(unsigned) x_return,
		(unsigned) y_return,
		(unsigned) width_return,
		(unsigned) height_return,
		(unsigned) gravity_return
	};
	normal_call(args);
	return result;
}
