#define _GNU_SOURCE

#include <stdio.h>
#include <emu-stub/base.h>
#include <emu-stub/stub.h>
#include <SDL/SDL.h>

#include "libSDL-1.2_const.h"

void SDL_CloseAudio(void) {
	unsigned args[] = {
		SDL_CLOSEAUDIO
	};
	normal_call(args);
}

SDL_Surface *SDL_CreateRGBSurface(Uint32 flags, int width, int height,
	int depth, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask, Uint32 Amask) {
	SDL_Surface *result;
	unsigned args[] = {
		SDL_CREATERGBSURFACE,
		(unsigned) &result,
		flags,
		width,
		height,
		depth,
		Rmask,
		Gmask,
		Bmask,
		Amask
	};
	normal_call(args);
	return result;
}

SDL_Surface *SDL_CreateRGBSurfaceFrom(void *pixels, int width, int height,
	int depth, int pitch, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask,
	Uint32 Amask) {
	SDL_Surface *result;
	unsigned args[] = {
		SDL_CREATERGBSURFACEFROM,
		(unsigned) &result,
		(unsigned) pixels,
		width,
		height,
		depth,
		pitch,
		Rmask,
		Gmask,
		Bmask,
		Amask
	};
	normal_call(args);
	return result;
}

SDL_sem *SDL_CreateSemaphore(Uint32 initial_value) {
	SDL_sem *result;
	unsigned args[] = {
		SDL_CREATESEMAPHORE,
		(unsigned) &result,
		initial_value
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_thread(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *fn_args = (unsigned *) syscall_result;
	int (*fn)(void *) = (void *) fn_args[0];
	void *data = (void *) fn_args[1];
	int status = fn(data);
	fn_args[0] = status;
	emu_stub_return();
}

SDL_Thread *SDL_CreateThread(int (*fn)(void *), void *data) {
	SDL_Thread *result;
	unsigned args[] = {
		SDL_CREATETHREAD,
		(unsigned) &result,
		(unsigned) fn,
		(unsigned) data
	};
	do_thread(callback_call(args));
	return result;
}

void SDL_Delay(Uint32 ms) {
	unsigned args[] = {
		SDL_DELAY,
		ms
	};
	normal_call(args);
}

void SDL_DestroySemaphore(SDL_sem *sem) {
	unsigned args[] = {
		SDL_DESTROYSEMAPHORE,
		(unsigned) sem
	};
	normal_call(args);
}

SDL_Surface *SDL_DisplayFormat(SDL_Surface *surface) {
	SDL_Surface *result;
	unsigned args[] = {
		SDL_DISPLAYFORMAT,
		(unsigned) &result,
		(unsigned) surface
	};
	normal_call(args);
	return result;
}

int SDL_FillRect(SDL_Surface *dst, SDL_Rect *dstrect, Uint32 color) {
	int result;
	unsigned args[] = {
		SDL_FILLRECT,
		(unsigned) &result,
		(unsigned) dst,
		(unsigned) dstrect,
		color
	};
	normal_call(args);
	return result;
}

int SDL_Flip(SDL_Surface *screen) {
	int result;
	unsigned args[] = {
		SDL_FLIP,
		(unsigned) &result,
		(unsigned) screen
	};
	normal_call(args);
	return result;
}

void SDL_FreeSurface(SDL_Surface *surface) {
	unsigned args[] = {
		SDL_FREESURFACE,
		(unsigned) surface
	};
	normal_call(args);
}

SDLMod SDL_GetModState(void) {
	SDLMod result;
	unsigned args[] = {
		SDL_GETMODSTATE,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

Uint8 SDL_GetMouseState(int *x, int *y) {
	Uint8 result;
	unsigned args[] = {
		SDL_GETMOUSESTATE,
		(unsigned) &result,
		(unsigned) x,
		(unsigned) y
	};
	normal_call(args);
	return result;
}

Uint32 SDL_GetTicks(void) {
	Uint32 result;
	unsigned args[] = {
		SDL_GETTICKS,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

int SDL_GL_SetAttribute(SDL_GLattr attr, int value) {
	int result;
	unsigned args[] = {
		SDL_GL_SETATTRIBUTE,
		(unsigned) &result,
		attr,
		value
	};
	normal_call(args);
	return result;
}

void SDL_GL_SwapBuffers(void) {
	unsigned args[] = {
		SDL_GL_SWAPBUFFERS
	};
	normal_call(args);
}

int SDL_Init(Uint32 flags) {
	int result;
	unsigned args[] = {
		SDL_INIT,
		(unsigned) &result,
		flags
	};
	normal_call(args);
	return result;
}

int SDL_InitSubSystem(Uint32 flags) {
	int result;
	unsigned args[] = {
		SDL_INITSUBSYSTEM,
		(unsigned) &result,
		flags
	};
	normal_call(args);
	return result;
}

int SDL_JoystickEventState(int state) {
	int result;
	unsigned args[] = {
		SDL_JOYSTICKEVENTSTATE,
		(unsigned) &result,
		state
	};
	normal_call(args);
	return result;
}

SDL_Joystick *SDL_JoystickOpen(int device_index) {
	SDL_Joystick *result;
	unsigned args[] = {
		SDL_JOYSTICKOPEN,
		(unsigned) &result,
		device_index
	};
	normal_call(args);
	return result;
}

SDL_Surface *SDL_LoadBMP_RW(SDL_RWops *src, int freesrc) {
	SDL_Surface *result;
	unsigned args[] = {
		SDL_LOADBMP_RW,
		(unsigned) &result,
		(unsigned) src,
		freesrc
	};
	normal_call(args);
	return result;
}

void SDL_LockAudio(void) {
	unsigned args[] = {
		SDL_LOCKAUDIO
	};
	normal_call(args);
}

int SDL_LockSurface(SDL_Surface *surface) {
	int result;
	unsigned args[] = {
		SDL_LOCKSURFACE,
		(unsigned) &result,
		(unsigned) surface
	};
	normal_call(args);
	return result;
}

Uint32 SDL_MapRGB(const SDL_PixelFormat *format, Uint8 r, Uint8 g, Uint8 b) {
	Uint32 result;
	unsigned args[] = {
		SDL_MAPRGB,
		(unsigned) &result,
		(unsigned) format,
		r,
		g,
		b
	};
	normal_call(args);
	return result;
}

Uint32 SDL_MapRGBA(const SDL_PixelFormat *format, Uint8 r, Uint8 g, Uint8 b,
	Uint8 a) {
	Uint32 result;
	unsigned args[] = {
		SDL_MAPRGBA,
		(unsigned) &result,
		(unsigned) format,
		r,
		g,
		b,
		a
	};
	normal_call(args);
	return result;
}

int SDL_NumJoysticks(void) {
	int result;
	unsigned args[] = {
		SDL_NUMJOYSTICKS,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

__attribute__((noinline)) static void do_callback(int syscall_result) {
	switch (syscall_result) {
	case -1:
		emu_stub_error(EMU_STUB_CALL);
	case 0:
		return;
	}
	unsigned *callback_args = (unsigned *) syscall_result;
	void (*callback)(void *, Uint8 *, int) = (void *) callback_args[0];
	void *userdata = (void *) callback_args[1];
	for (;;) {
		Uint8 *stream = (void *) callback_args[2];
		int len = callback_args[3];
		callback(userdata, stream, len);
		emu_stub_return();
	}
}

int SDL_OpenAudio(SDL_AudioSpec *desired, SDL_AudioSpec *obtained) {
	int result;
	unsigned args[] = {
		SDL_OPENAUDIO,
		(unsigned) &result,
		(unsigned) desired,
		(unsigned) obtained
	};
	do_callback(callback_call(args));
	return result;
}

void SDL_PauseAudio(int pause_on) {
	unsigned args[] = {
		SDL_PAUSEAUDIO,
		pause_on
	};
	normal_call(args);
}

int SDL_PollEvent(SDL_Event *event) {
	int result;
	unsigned args[] = {
		SDL_POLLEVENT,
		(unsigned) &result,
		(unsigned) event
	};
	normal_call(args);
	return result;
}

int SDL_PushEvent(SDL_Event *event) {
	int result;
	unsigned args[] = {
		SDL_PUSHEVENT,
		(unsigned) &result,
		(unsigned) event
	};
	normal_call(args);
	return result;
}

void SDL_Quit(void) {
	unsigned args[] = {
		SDL_QUIT__FUNCTION
	};
	normal_call(args);
}

void SDL_QuitSubSystem(Uint32 flags) {
	unsigned args[] = {
		SDL_QUITSUBSYSTEM,
		flags
	};
	normal_call(args);
}

static int SDL_RWops_close(struct SDL_RWops *context);
static int SDL_RWops_read(struct SDL_RWops *context, void *ptr, int size,
	int maxnum);
static int SDL_RWops_seek(struct SDL_RWops *context, int offset, int whence);

SDL_RWops *SDL_RWFromFile(const char *file, const char *mode) {
	SDL_RWops *result;
	unsigned args[] = {
		SDL_RWFROMFILE,
		(unsigned) &result,
		(unsigned) file,
		(unsigned) mode
	};
	normal_call(args);
	if (result) {
		result->seek = SDL_RWops_seek;
		result->read = SDL_RWops_read;
		result->close = SDL_RWops_close;
	}
	return result;
}

static int SDL_RWops_close(struct SDL_RWops *context) {
	int result;
	unsigned args[] = {
		SDL_RWOPS_CLOSE,
		(unsigned) &result,
		(unsigned) context
	};
	normal_call(args);
	return result;
}

static int SDL_RWops_read(struct SDL_RWops *context, void *ptr, int size,
	int maxnum) {
	int result;
	unsigned args[] = {
		SDL_RWOPS_READ,
		(unsigned) &result,
		(unsigned) context,
		(unsigned) ptr,
		size,
		maxnum
	};
	normal_call(args);
	return result;
}

static int SDL_RWops_seek(struct SDL_RWops *context, int offset, int whence) {
	int result;
	unsigned args[] = {
		SDL_RWOPS_SEEK,
		(unsigned) &result,
		(unsigned) context,
		offset,
		whence
	};
	normal_call(args);
	return result;
}

int SDL_SemPost(SDL_sem *sem) {
	int result;
	unsigned args[] = {
		SDL_SEMPOST,
		(unsigned) &result,
		(unsigned) sem
	};
	normal_call(args);
	return result;
}

int SDL_SemWaitTimeout(SDL_sem *sem, Uint32 timeout) {
	int result;
	unsigned args[] = {
		SDL_SEMWAITTIMEOUT,
		(unsigned) &result,
		(unsigned) sem,
		timeout
	};
	normal_call(args);
	return result;
}

int SDL_SetAlpha(SDL_Surface *surface, Uint32 flag, Uint8 alpha) {
	int result;
	unsigned args[] = {
		SDL_SETALPHA,
		(unsigned) &result,
		(unsigned) surface,
		flag,
		alpha
	};
	normal_call(args);
	return result;
}

int SDL_SetColorKey(SDL_Surface *surface, Uint32 flag, Uint32 key) {
	int result;
	unsigned args[] = {
		SDL_SETCOLORKEY,
		(unsigned) &result,
		(unsigned) surface,
		flag,
		key
	};
	normal_call(args);
	return result;
}

void SDL_SetError(const char *fmt, ...) {
	char *strp;
	va_list ap;
	va_start(ap, fmt);
	int ret = vasprintf(&strp, fmt, ap);
	va_end(ap);
	unsigned args[] = {
		SDL_SETERROR,
		(unsigned) (ret != -1 ? strp : "Not enough memory")
	};
	normal_call(args);
	if (ret != -1)
		free(strp);
}

SDL_Surface *SDL_SetVideoMode(int width, int height, int bpp, Uint32 flags) {
	SDL_Surface *result;
	unsigned args[] = {
		SDL_SETVIDEOMODE,
		(unsigned) &result,
		width,
		height,
		bpp,
		flags
	};
	normal_call(args);
	return result;
}

int SDL_ShowCursor(int toggle) {
	int result;
	unsigned args[] = {
		SDL_SHOWCURSOR,
		(unsigned) &result,
		toggle
	};
	normal_call(args);
	return result;
}

void SDL_UnlockAudio(void) {
	unsigned args[] = {
		SDL_UNLOCKAUDIO
	};
	normal_call(args);
}

void SDL_UnlockSurface(SDL_Surface *surface) {
	unsigned args[] = {
		SDL_UNLOCKSURFACE,
		(unsigned) surface
	};
	normal_call(args);
}

void SDL_UpdateRect(SDL_Surface *screen, Sint32 x, Sint32 y, Uint32 w,
	Uint32 h) {
	unsigned args[] = {
		SDL_UPDATERECT,
		(unsigned) screen,
		x,
		y,
		w,
		h
	};
	normal_call(args);
}

int SDL_UpperBlit(SDL_Surface *src, const SDL_Rect *srcrect, SDL_Surface *dst,
	SDL_Rect *dstrect) {
	int result;
	unsigned args[] = {
		SDL_UPPERBLIT,
		(unsigned) &result,
		(unsigned) src,
		(unsigned) srcrect,
		(unsigned) dst,
		(unsigned) dstrect
	};
	normal_call(args);
	return result;
}

int SDL_WaitEvent(SDL_Event *event) {
	int result;
	unsigned args[] = {
		SDL_WAITEVENT,
		(unsigned) &result,
		(unsigned) event
	};
	normal_call(args);
	return result;
}

void SDL_WaitThread(SDL_Thread *thread, int *status) {
	unsigned args[] = {
		SDL_WAITTHREAD,
		(unsigned) thread,
		(unsigned) status
	};
	normal_call(args);
}

void SDL_WarpMouse(Uint16 x, Uint16 y) {
	unsigned args[] = {
		SDL_WARPMOUSE,
		x,
		y
	};
	normal_call(args);
}

SDL_GrabMode SDL_WM_GrabInput(SDL_GrabMode mode) {
	SDL_GrabMode result;
	unsigned args[] = {
		SDL_WM_GRABINPUT,
		(unsigned) &result,
		mode
	};
	normal_call(args);
	return result;
}

void SDL_WM_SetCaption(const char *title, const char *icon) {
	unsigned args[] = {
		SDL_WM_SETCAPTION,
		(unsigned) title,
		(unsigned) icon
	};
	normal_call(args);
}

void SDL_WM_SetIcon(SDL_Surface *icon, Uint8 *mask) {
	unsigned args[] = {
		SDL_WM_SETICON,
		(unsigned) icon,
		(unsigned) mask
	};
	normal_call(args);
}
