#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <emu-stub/base.h>
#include <emu-stub/typeswap.h>
#include <GL/glx.h>

#include "libGL_const.h"

typedef struct {
	const char *name;
	void *ptr;
} proc_table_pair;

static void __glXCopySubBufferMESA(Display *dpy, GLXDrawable drawable, int x,
	int y, int width, int height);
static int __glXGetSwapIntervalMESA(void);

static proc_table_pair proc_table[] = {
#define PAIR(x) { #x, x }
	PAIR(glBindTexture),
	PAIR(glBitmap),
	PAIR(glCopyTexImage2D),
	PAIR(glCopyTexSubImage1D),
	PAIR(glCopyTexSubImage2D),
	PAIR(glDrawBuffer),
	PAIR(glEndList),
	PAIR(glFinish),
	PAIR(glFlush),
	PAIR(glGetError),
	PAIR(glGetIntegerv),
	PAIR(glGetString),
	PAIR(glNewList),
	PAIR(glPixelStorei),
	PAIR(glReadPixels),
	PAIR(glTexImage2D),
	PAIR(glXAllocateMemoryNV),
	{ "glXChooseFBConfigSGIX", glXChooseFBConfig },
	PAIR(glXChooseVisual),
	PAIR(glXCopyContext),
	{ "glXCopySubBufferMESA", __glXCopySubBufferMESA },
	PAIR(glXCreateContext),
	PAIR(glXCreateGLXPixmap),
	PAIR(glXCreateNewContext),
	PAIR(glXCreatePbuffer),
	PAIR(glXDestroyContext),
	PAIR(glXDestroyGLXPixmap),
	PAIR(glXDestroyPbuffer),
	PAIR(glXFreeMemoryNV),
	PAIR(glXGetClientString),
	PAIR(glXGetConfig),
	PAIR(glXGetCurrentContext),
	PAIR(glXGetCurrentDrawable),
	PAIR(glXGetCurrentReadDrawable),
	{ "glXGetFBConfigAttribSGIX", glXGetFBConfigAttrib },
	PAIR(glXGetFBConfigs),
	{ "glXGetSwapIntervalMESA", __glXGetSwapIntervalMESA },
	{ "glXGetVisualFromFBConfigSGIX", glXGetVisualFromFBConfig },
	PAIR(glXIsDirect),
	PAIR(glXMakeContextCurrent),
	PAIR(glXMakeCurrent),
	PAIR(glXQueryExtension),
	PAIR(glXQueryExtensionsString),
	PAIR(glXQueryServerString),
	PAIR(glXQueryVersion),
	PAIR(glXSwapBuffers),
	PAIR(glXUseXFont)
#undef PAIR
};

static int proc_table_compar(const void *key, const void *member);

void glAccum(GLenum op, GLfloat value) {
	fprintf(stderr, "Unimplemented stub glAccum\n");
	exit(EXIT_FAILURE);
	if (op || value) {}
}

void glAlphaFunc(GLenum func, GLclampf ref) {
	fprintf(stderr, "Unimplemented stub glAlphaFunc\n");
	exit(EXIT_FAILURE);
	if (func || ref) {}
}

GLboolean glAreTexturesResident(GLsizei n, const GLuint *textures,
	GLboolean *residences) {
	fprintf(stderr, "Unimplemented stub glAreTexturesResident\n");
	exit(EXIT_FAILURE);
	if (n || textures || residences) {}
}

void glArrayElement(GLint i) {
	fprintf(stderr, "Unimplemented stub glArrayElement\n");
	exit(EXIT_FAILURE);
	if (i) {}
}

void glBegin(GLenum mode) {
	unsigned args[] = {
		GLBEGIN,
		mode
	};
	normal_call(args);
}

void glBindTexture(GLenum target, GLuint texture) {
	unsigned args[] = {
		GLBINDTEXTURE,
		target,
		texture
	};
	normal_call(args);
}

void glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig,
	GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) {
	fprintf(stderr, "Unimplemented stub glBitmap\n");
	exit(EXIT_FAILURE);
	if (width || height || xorig || yorig || xmove || ymove || bitmap) {}
}

void glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
	fprintf(stderr, "Unimplemented stub glBlendColor\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glBlendEquation(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glBlendEquation\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glBlendFunc(GLenum sfactor, GLenum dfactor) {
	unsigned args[] = {
		GLBLENDFUNC,
		sfactor,
		dfactor
	};
	normal_call(args);
}

void glCallList(GLuint list) {
	unsigned args[] = {
		GLCALLLIST,
		list
	};
	normal_call(args);
}

void glCallLists(GLsizei n, GLenum type, const GLvoid *lists) {
	fprintf(stderr, "Unimplemented stub glCallLists\n");
	exit(EXIT_FAILURE);
	if (n || type || lists) {}
}

void glClear(GLbitfield mask) {
	unsigned args[] = {
		GLCLEAR,
		mask
	};
	normal_call(args);
}

void glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
	fprintf(stderr, "Unimplemented stub glClearAccum\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
	fprintf(stderr, "Unimplemented stub glClearColor\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glClearDepth(GLclampd depth) {
	fprintf(stderr, "Unimplemented stub glClearDepth\n");
	exit(EXIT_FAILURE);
	if (depth) {}
}

void glClearIndex(GLfloat c) {
	fprintf(stderr, "Unimplemented stub glClearIndex\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glClearStencil(GLint s) {
	fprintf(stderr, "Unimplemented stub glClearStencil\n");
	exit(EXIT_FAILURE);
	if (s) {}
}

void glClipPlane(GLenum plane, const GLdouble *equation) {
	fprintf(stderr, "Unimplemented stub glClipPlane\n");
	exit(EXIT_FAILURE);
	if (plane || equation) {}
}

void glColor3b(GLbyte red, GLbyte green, GLbyte blue) {
	fprintf(stderr, "Unimplemented stub glColor3b\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3bv(const GLbyte *v) {
	fprintf(stderr, "Unimplemented stub glColor3bv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3d(GLdouble red, GLdouble green, GLdouble blue) {
	fprintf(stderr, "Unimplemented stub glColor3d\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glColor3dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3f(GLfloat red, GLfloat green, GLfloat blue) {
	fprintf(stderr, "Unimplemented stub glColor3f\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glColor3fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3i(GLint red, GLint green, GLint blue) {
	fprintf(stderr, "Unimplemented stub glColor3i\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glColor3iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3s(GLshort red, GLshort green, GLshort blue) {
	fprintf(stderr, "Unimplemented stub glColor3s\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glColor3sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3ub(GLubyte red, GLubyte green, GLubyte blue) {
	fprintf(stderr, "Unimplemented stub glColor3ub\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3ubv(const GLubyte *v) {
	fprintf(stderr, "Unimplemented stub glColor3ubv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3ui(GLuint red, GLuint green, GLuint blue) {
	fprintf(stderr, "Unimplemented stub glColor3ui\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3uiv(const GLuint *v) {
	fprintf(stderr, "Unimplemented stub glColor3uiv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor3us(GLushort red, GLushort green, GLushort blue) {
	fprintf(stderr, "Unimplemented stub glColor3us\n");
	exit(EXIT_FAILURE);
	if (red || green || blue) {}
}

void glColor3usv(const GLushort *v) {
	fprintf(stderr, "Unimplemented stub glColor3usv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) {
	fprintf(stderr, "Unimplemented stub glColor4b\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4bv(const GLbyte *v) {
	fprintf(stderr, "Unimplemented stub glColor4bv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) {
	fprintf(stderr, "Unimplemented stub glColor4d\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glColor4dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
	fprintf(stderr, "Unimplemented stub glColor4f\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glColor4fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4i(GLint red, GLint green, GLint blue, GLint alpha) {
	fprintf(stderr, "Unimplemented stub glColor4i\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glColor4iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha) {
	fprintf(stderr, "Unimplemented stub glColor4s\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glColor4sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
	fprintf(stderr, "Unimplemented stub glColor4ub\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4ubv(const GLubyte *v) {
	fprintf(stderr, "Unimplemented stub glColor4ubv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha) {
	fprintf(stderr, "Unimplemented stub glColor4ui\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4uiv(const GLuint *v) {
	fprintf(stderr, "Unimplemented stub glColor4uiv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha) {
	fprintf(stderr, "Unimplemented stub glColor4us\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColor4usv(const GLushort *v) {
	fprintf(stderr, "Unimplemented stub glColor4usv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glColorMask(GLboolean red, GLboolean green, GLboolean blue,
	GLboolean alpha) {
	fprintf(stderr, "Unimplemented stub glColorMask\n");
	exit(EXIT_FAILURE);
	if (red || green || blue || alpha) {}
}

void glColorMaterial(GLenum face, GLenum mode) {
	fprintf(stderr, "Unimplemented stub glColorMaterial\n");
	exit(EXIT_FAILURE);
	if (face || mode) {}
}

void glColorPointer(GLint size, GLenum type, GLsizei stride,
	const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glColorPointer\n");
	exit(EXIT_FAILURE);
	if (size || type || stride || ptr) {}
}

void glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format,
	GLenum type, const GLvoid *data) {
	fprintf(stderr, "Unimplemented stub glColorSubTable\n");
	exit(EXIT_FAILURE);
	if (target || start || count || format || type || data) {}
}

void glColorTable(GLenum target, GLenum internalformat, GLsizei width,
	GLenum format, GLenum type, const GLvoid *table) {
	fprintf(stderr, "Unimplemented stub glColorTable\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || width || format || type || table) {}
}

void glColorTableParameterfv(GLenum target, GLenum pname,
	const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glColorTableParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glColorTableParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width,
	GLenum format, GLenum type, const GLvoid *image) {
	fprintf(stderr, "Unimplemented stub glConvolutionFilter1D\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || width || format || type || image) {}
}

void glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width,
	GLsizei height, GLenum format, GLenum type, const GLvoid *image) {
	fprintf(stderr, "Unimplemented stub glConvolutionFilter2D\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || width || height || format || type
		|| image) {}
}

void glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params) {
	fprintf(stderr, "Unimplemented stub glConvolutionParameterf\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glConvolutionParameterfv(GLenum target, GLenum pname,
	const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glConvolutionParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glConvolutionParameteri(GLenum target, GLenum pname, GLint params) {
	fprintf(stderr, "Unimplemented stub glConvolutionParameteri\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glConvolutionParameteriv(GLenum target, GLenum pname,
	const GLint *params) {
	fprintf(stderr, "Unimplemented stub glConvolutionParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y,
	GLsizei width) {
	fprintf(stderr, "Unimplemented stub glCopyColorSubTable\n");
	exit(EXIT_FAILURE);
	if (target || start || x || y || width) {}
}

void glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y,
	GLsizei width) {
	fprintf(stderr, "Unimplemented stub glCopyColorTable\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || x || y || width) {}
}

void glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x,
	GLint y, GLsizei width) {
	fprintf(stderr, "Unimplemented stub glCopyConvolutionFilter1D\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || x || y || width) {}
}

void glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x,
	GLint y, GLsizei width, GLsizei height) {
	fprintf(stderr, "Unimplemented stub glCopyConvolutionFilter2D\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || x || y || width || height) {}
}

void glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height,
	GLenum type) {
	fprintf(stderr, "Unimplemented stub glCopyPixels\n");
	exit(EXIT_FAILURE);
	if (x || y || width || height || type) {}
}

void glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat,
	GLint x, GLint y, GLsizei width, GLint border) {
	fprintf(stderr, "Unimplemented stub glCopyTexImage1D\n");
	exit(EXIT_FAILURE);
	if (target || level || internalformat || x || y || width || border) {}
}

void glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat,
	GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
	fprintf(stderr, "Unimplemented stub glCopyTexImage2D\n");
	exit(EXIT_FAILURE);
	if (target || level || internalformat || x || y || width || height
		|| border) {}
}

void glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x,
	GLint y, GLsizei width) {
	fprintf(stderr, "Unimplemented stub glCopyTexSubImage1D\n");
	exit(EXIT_FAILURE);
	if (target || level || xoffset || x || y || width) {}
}

void glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset,
	GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
	fprintf(stderr, "Unimplemented stub glCopyTexSubImage2D\n");
	exit(EXIT_FAILURE);
	if (target || level || xoffset || yoffset || x || y || width
		|| height) {}
}

void glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset,
	GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width,
	GLsizei height) {
	fprintf(stderr, "Unimplemented stub glCopyTexSubImage3D\n");
	exit(EXIT_FAILURE);
	if (target || level || xoffset || yoffset || zoffset || x || y || width
		|| height) {}
}

void glCullFace(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glCullFace\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glDeleteLists(GLuint list, GLsizei range) {
	unsigned args[] = {
		GLDELETELISTS,
		list,
		range
	};
	normal_call(args);
}

void glDeleteTextures(GLsizei n, const GLuint *textures) {
	unsigned args[] = {
		GLDELETETEXTURES,
		n,
		(unsigned) textures
	};
	normal_call(args);
}

void glDepthFunc(GLenum func) {
	fprintf(stderr, "Unimplemented stub glDepthFunc\n");
	exit(EXIT_FAILURE);
	if (func) {}
}

void glDepthMask(GLboolean flag) {
	fprintf(stderr, "Unimplemented stub glDepthMask\n");
	exit(EXIT_FAILURE);
	if (flag) {}
}

void glDepthRange(GLclampd near_val, GLclampd far_val) {
	fprintf(stderr, "Unimplemented stub glDepthRange\n");
	exit(EXIT_FAILURE);
	if (near_val || far_val) {}
}

void glDisable(GLenum cap) {
	unsigned args[] = {
		GLDISABLE,
		cap
	};
	normal_call(args);
}

void glDisableClientState(GLenum cap) {
	fprintf(stderr, "Unimplemented stub glDisableClientState\n");
	exit(EXIT_FAILURE);
	if (cap) {}
}

void glDrawArrays(GLenum mode, GLint first, GLsizei count) {
	fprintf(stderr, "Unimplemented stub glDrawArrays\n");
	exit(EXIT_FAILURE);
	if (mode || first || count) {}
}

void glDrawBuffer(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glDrawBuffer\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glDrawElements(GLenum mode, GLsizei count, GLenum type,
	const GLvoid *indices) {
	fprintf(stderr, "Unimplemented stub glDrawElements\n");
	exit(EXIT_FAILURE);
	if (mode || count || type || indices) {}
}

void glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type,
	const GLvoid *pixels) {
	fprintf(stderr, "Unimplemented stub glDrawPixels\n");
	exit(EXIT_FAILURE);
	if (width || height || format || type || pixels) {}
}

void glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count,
	GLenum type, const GLvoid *indices) {
	fprintf(stderr, "Unimplemented stub glDrawRangeElements\n");
	exit(EXIT_FAILURE);
	if (mode || start || end || count || type || indices) {}
}

void glEdgeFlag(GLboolean flag) {
	fprintf(stderr, "Unimplemented stub glEdgeFlag\n");
	exit(EXIT_FAILURE);
	if (flag) {}
}

void glEdgeFlagPointer(GLsizei stride, const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glEdgeFlagPointer\n");
	exit(EXIT_FAILURE);
	if (stride || ptr) {}
}

void glEdgeFlagv(const GLboolean *flag) {
	fprintf(stderr, "Unimplemented stub glEdgeFlagv\n");
	exit(EXIT_FAILURE);
	if (flag) {}
}

void glEnable(GLenum cap) {
	unsigned args[] = {
		GLENABLE,
		cap
	};
	normal_call(args);
}

void glEnableClientState(GLenum cap) {
	fprintf(stderr, "Unimplemented stub glEnableClientState\n");
	exit(EXIT_FAILURE);
	if (cap) {}
}

void glEnd(void) {
	unsigned args[] = {
		GLEND
	};
	normal_call(args);
}

void glEndList(void) {
	unsigned args[] = {
		GLENDLIST
	};
	normal_call(args);
}

void glEvalCoord1d(GLdouble u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord1d\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalCoord1dv(const GLdouble *u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord1dv\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalCoord1f(GLfloat u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord1f\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalCoord1fv(const GLfloat *u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord1fv\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalCoord2d(GLdouble u, GLdouble v) {
	fprintf(stderr, "Unimplemented stub glEvalCoord2d\n");
	exit(EXIT_FAILURE);
	if (u || v) {}
}

void glEvalCoord2dv(const GLdouble *u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord2dv\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalCoord2f(GLfloat u, GLfloat v) {
	fprintf(stderr, "Unimplemented stub glEvalCoord2f\n");
	exit(EXIT_FAILURE);
	if (u || v) {}
}

void glEvalCoord2fv(const GLfloat *u) {
	fprintf(stderr, "Unimplemented stub glEvalCoord2fv\n");
	exit(EXIT_FAILURE);
	if (u) {}
}

void glEvalMesh1(GLenum mode, GLint i1, GLint i2) {
	fprintf(stderr, "Unimplemented stub glEvalMesh1\n");
	exit(EXIT_FAILURE);
	if (mode || i1 || i2) {}
}

void glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2) {
	fprintf(stderr, "Unimplemented stub glEvalMesh2\n");
	exit(EXIT_FAILURE);
	if (mode || i1 || i2 || j1 || j2) {}
}

void glEvalPoint1(GLint i) {
	fprintf(stderr, "Unimplemented stub glEvalPoint1\n");
	exit(EXIT_FAILURE);
	if (i) {}
}

void glEvalPoint2(GLint i, GLint j) {
	fprintf(stderr, "Unimplemented stub glEvalPoint2\n");
	exit(EXIT_FAILURE);
	if (i || j) {}
}

void glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer) {
	fprintf(stderr, "Unimplemented stub glFeedbackBuffer\n");
	exit(EXIT_FAILURE);
	if (size || type || buffer) {}
}

void glFinish(void) {
	fprintf(stderr, "Unimplemented stub glFinish\n");
	exit(EXIT_FAILURE);
}

void glFlush(void) {
	unsigned args[] = {
		GLFLUSH
	};
	normal_call(args);
}

void glFogf(GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glFogf\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glFogfv(GLenum pname, const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glFogfv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glFogi(GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glFogi\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glFogiv(GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glFogiv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glFrontFace(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glFrontFace\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
	GLdouble near_val, GLdouble far_val) {
	int_s64 is1 = { .d = left };
	int_s64 is2 = { .d = right };
	int_s64 is3 = { .d = bottom };
	int_s64 is4 = { .d = top };
	int_s64 is5 = { .d = near_val };
	int_s64 is6 = { .d = far_val };
	unsigned args[] = {
		GLFRUSTUM,
		is1.i[0], is1.i[1],
		is2.i[0], is2.i[1],
		is3.i[0], is3.i[1],
		is4.i[0], is4.i[1],
		is5.i[0], is5.i[1],
		is6.i[0], is6.i[1]
	};
	normal_call(args);
}

GLuint glGenLists(GLsizei range) {
	GLuint result;
	unsigned args[] = {
		GLGENLISTS,
		(unsigned) &result,
		range
	};
	normal_call(args);
	return result;
}

void glGenTextures(GLsizei n, GLuint *textures) {
	unsigned args[] = {
		GLGENTEXTURES,
		n,
		(unsigned) textures
	};
	normal_call(args);
}

void glGetBooleanv(GLenum pname, GLboolean *params) {
	fprintf(stderr, "Unimplemented stub glGetBooleanv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glGetClipPlane(GLenum plane, GLdouble *equation) {
	fprintf(stderr, "Unimplemented stub glGetClipPlane\n");
	exit(EXIT_FAILURE);
	if (plane || equation) {}
}

void glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid *table) {
	fprintf(stderr, "Unimplemented stub glGetColorTable\n");
	exit(EXIT_FAILURE);
	if (target || format || type || table) {}
}

void glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetColorTableParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetColorTableParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetConvolutionFilter(GLenum target, GLenum format, GLenum type,
	GLvoid *image) {
	fprintf(stderr, "Unimplemented stub glGetConvolutionFilter\n");
	exit(EXIT_FAILURE);
	if (target || format || type || image) {}
}

void glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetConvolutionParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetConvolutionParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetDoublev(GLenum pname, GLdouble *params) {
	fprintf(stderr, "Unimplemented stub glGetDoublev\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

GLenum glGetError(void) {
	fprintf(stderr, "Unimplemented stub glGetError\n");
	exit(EXIT_FAILURE);
}

void glGetFloatv(GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetFloatv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type,
	GLvoid *values) {
	fprintf(stderr, "Unimplemented stub glGetHistogram\n");
	exit(EXIT_FAILURE);
	if (target || reset || format || type || values) {}
}

void glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetHistogramParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetHistogramParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetIntegerv(GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetIntegerv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glGetLightfv(GLenum light, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetLightfv\n");
	exit(EXIT_FAILURE);
	if (light || pname || params) {}
}

void glGetLightiv(GLenum light, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetLightiv\n");
	exit(EXIT_FAILURE);
	if (light || pname || params) {}
}

void glGetMapdv(GLenum target, GLenum query, GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glGetMapdv\n");
	exit(EXIT_FAILURE);
	if (target || query || v) {}
}

void glGetMapfv(GLenum target, GLenum query, GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glGetMapfv\n");
	exit(EXIT_FAILURE);
	if (target || query || v) {}
}

void glGetMapiv(GLenum target, GLenum query, GLint *v) {
	fprintf(stderr, "Unimplemented stub glGetMapiv\n");
	exit(EXIT_FAILURE);
	if (target || query || v) {}
}

void glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetMaterialfv\n");
	exit(EXIT_FAILURE);
	if (face || pname || params) {}
}

void glGetMaterialiv(GLenum face, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetMaterialiv\n");
	exit(EXIT_FAILURE);
	if (face || pname || params) {}
}

void glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum types,
	GLvoid *values) {
	fprintf(stderr, "Unimplemented stub glGetMinmax\n");
	exit(EXIT_FAILURE);
	if (target || reset || format || types || values) {}
}

void glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetMinmaxParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetMinmaxParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetPixelMapfv(GLenum map, GLfloat *values) {
	fprintf(stderr, "Unimplemented stub glGetPixelMapfv\n");
	exit(EXIT_FAILURE);
	if (map || values) {}
}

void glGetPixelMapuiv(GLenum map, GLuint *values) {
	fprintf(stderr, "Unimplemented stub glGetPixelMapuiv\n");
	exit(EXIT_FAILURE);
	if (map || values) {}
}

void glGetPixelMapusv(GLenum map, GLushort *values) {
	fprintf(stderr, "Unimplemented stub glGetPixelMapusv\n");
	exit(EXIT_FAILURE);
	if (map || values) {}
}

void glGetPointerv(GLenum pname, GLvoid **params) {
	fprintf(stderr, "Unimplemented stub glGetPointerv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glGetPolygonStipple(GLubyte *mask) {
	fprintf(stderr, "Unimplemented stub glGetPolygonStipple\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glGetSeparableFilter(GLenum target, GLenum format, GLenum type,
	GLvoid *row, GLvoid *column, GLvoid *span) {
	fprintf(stderr, "Unimplemented stub glGetSeparableFilter\n");
	exit(EXIT_FAILURE);
	if (target || format || type || row || column || span) {}
}

const GLubyte *glGetString(GLenum name) {
	const GLubyte *result;
	unsigned args[] = {
		GLGETSTRING,
		(unsigned) &result,
		name
	};
	normal_call(args);
	return result;
}

void glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetTexEnvfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetTexEnviv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetTexEnviv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params) {
	fprintf(stderr, "Unimplemented stub glGetTexGendv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetTexGenfv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glGetTexGeniv(GLenum coord, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetTexGeniv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type,
	GLvoid *pixels) {
	unsigned args[] = {
		GLGETTEXIMAGE,
		target,
		level,
		format,
		type,
		(unsigned) pixels
	};
	normal_call(args);
}

void glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname,
	GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetTexLevelParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || level || pname || params) {}
}

void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname,
	GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetTexLevelParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || level || pname || params) {}
}

void glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glGetTexParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glGetTexParameteriv(GLenum target, GLenum pname, GLint *params) {
	fprintf(stderr, "Unimplemented stub glGetTexParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glHint(GLenum target, GLenum mode) {
	fprintf(stderr, "Unimplemented stub glHint\n");
	exit(EXIT_FAILURE);
	if (target || mode) {}
}

void glHistogram(GLenum target, GLsizei width, GLenum internalformat,
	GLboolean sink) {
	fprintf(stderr, "Unimplemented stub glHistogram\n");
	exit(EXIT_FAILURE);
	if (target || width || internalformat || sink) {}
}

void glIndexd(GLdouble c) {
	fprintf(stderr, "Unimplemented stub glIndexd\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexdv(const GLdouble *c) {
	fprintf(stderr, "Unimplemented stub glIndexdv\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexf(GLfloat c) {
	fprintf(stderr, "Unimplemented stub glIndexf\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexfv(const GLfloat *c) {
	fprintf(stderr, "Unimplemented stub glIndexfv\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexi(GLint c) {
	fprintf(stderr, "Unimplemented stub glIndexi\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexiv(const GLint *c) {
	fprintf(stderr, "Unimplemented stub glIndexiv\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexMask(GLuint mask) {
	fprintf(stderr, "Unimplemented stub glIndexMask\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glIndexPointer(GLenum type, GLsizei stride, const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glIndexPointer\n");
	exit(EXIT_FAILURE);
	if (type || stride || ptr) {}
}

void glIndexs(GLshort c) {
	fprintf(stderr, "Unimplemented stub glIndexs\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexsv(const GLshort *c) {
	fprintf(stderr, "Unimplemented stub glIndexsv\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexub(GLubyte c) {
	fprintf(stderr, "Unimplemented stub glIndexub\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glIndexubv(const GLubyte *c) {
	fprintf(stderr, "Unimplemented stub glIndexubv\n");
	exit(EXIT_FAILURE);
	if (c) {}
}

void glInitNames(void) {
	fprintf(stderr, "Unimplemented stub glInitNames\n");
	exit(EXIT_FAILURE);
}

void glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer) {
	fprintf(stderr, "Unimplemented stub glInterleavedArrays\n");
	exit(EXIT_FAILURE);
	if (format || stride || pointer) {}
}

GLboolean glIsEnabled(GLenum cap) {
	fprintf(stderr, "Unimplemented stub glIsEnabled\n");
	exit(EXIT_FAILURE);
	if (cap) {}
}

GLboolean glIsList(GLuint list) {
	fprintf(stderr, "Unimplemented stub glIsList\n");
	exit(EXIT_FAILURE);
	if (list) {}
}

GLboolean glIsTexture(GLuint texture) {
	fprintf(stderr, "Unimplemented stub glIsTexture\n");
	exit(EXIT_FAILURE);
	if (texture) {}
}

void glLightf(GLenum light, GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glLightf\n");
	exit(EXIT_FAILURE);
	if (light || pname || param) {}
}

void glLightfv(GLenum light, GLenum pname, const GLfloat *params) {
	unsigned args[] = {
		GLLIGHTFV,
		light,
		pname,
		(unsigned) params
	};
	normal_call(args);
}

void glLighti(GLenum light, GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glLighti\n");
	exit(EXIT_FAILURE);
	if (light || pname || param) {}
}

void glLightiv(GLenum light, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glLightiv\n");
	exit(EXIT_FAILURE);
	if (light || pname || params) {}
}

void glLightModelf(GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glLightModelf\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glLightModelfv(GLenum pname, const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glLightModelfv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glLightModeli(GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glLightModeli\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glLightModeliv(GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glLightModeliv\n");
	exit(EXIT_FAILURE);
	if (pname || params) {}
}

void glLineStipple(GLint factor, GLushort pattern) {
	fprintf(stderr, "Unimplemented stub glLineStipple\n");
	exit(EXIT_FAILURE);
	if (factor || pattern) {}
}

void glLineWidth(GLfloat width) {
	fprintf(stderr, "Unimplemented stub glLineWidth\n");
	exit(EXIT_FAILURE);
	if (width) {}
}

void glListBase(GLuint base) {
	fprintf(stderr, "Unimplemented stub glListBase\n");
	exit(EXIT_FAILURE);
	if (base) {}
}

void glLoadIdentity(void) {
	unsigned args[] = {
		GLLOADIDENTITY
	};
	normal_call(args);
}

void glLoadMatrixd(const GLdouble *m) {
	fprintf(stderr, "Unimplemented stub glLoadMatrixd\n");
	exit(EXIT_FAILURE);
	if (m) {}
}

void glLoadMatrixf(const GLfloat *m) {
	fprintf(stderr, "Unimplemented stub glLoadMatrixf\n");
	exit(EXIT_FAILURE);
	if (m) {}
}

void glLoadName(GLuint name) {
	fprintf(stderr, "Unimplemented stub glLoadName\n");
	exit(EXIT_FAILURE);
	if (name) {}
}

void glLogicOp(GLenum opcode) {
	fprintf(stderr, "Unimplemented stub glLogicOp\n");
	exit(EXIT_FAILURE);
	if (opcode) {}
}

void glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order,
	const GLdouble *points) {
	fprintf(stderr, "Unimplemented stub glMap1d\n");
	exit(EXIT_FAILURE);
	if (target || u1 || u2 || stride || order || points) {}
}

void glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order,
	const GLfloat *points) {
	fprintf(stderr, "Unimplemented stub glMap1f\n");
	exit(EXIT_FAILURE);
	if (target || u1 || u2 || stride || order || points) {}
}

void glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride,
	GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder,
	const GLdouble *points) {
	fprintf(stderr, "Unimplemented stub glMap2d\n");
	exit(EXIT_FAILURE);
	if (target || u1 || u2 || ustride || uorder || v1 || v2 || vstride
		|| vorder || points) {}
}

void glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder,
	GLfloat v1, GLfloat v2, GLint vstride, GLint vorder,
	const GLfloat *points) {
	fprintf(stderr, "Unimplemented stub glMap2f\n");
	exit(EXIT_FAILURE);
	if (target || u1 || u2 || ustride || uorder || v1 || v2 || vstride
		|| vorder || points) {}
}

void glMapGrid1d(GLint un, GLdouble u1, GLdouble u2) {
	fprintf(stderr, "Unimplemented stub glMapGrid1d\n");
	exit(EXIT_FAILURE);
	if (un || u1 || u2) {}
}

void glMapGrid1f(GLint un, GLfloat u1, GLfloat u2) {
	fprintf(stderr, "Unimplemented stub glMapGrid1f\n");
	exit(EXIT_FAILURE);
	if (un || u1 || u2) {}
}

void glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1,
	GLdouble v2) {
	fprintf(stderr, "Unimplemented stub glMapGrid2d\n");
	exit(EXIT_FAILURE);
	if (un || u1 || u2 || vn || v1 || v2) {}
}

void glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1,
	GLfloat v2) {
	fprintf(stderr, "Unimplemented stub glMapGrid2f\n");
	exit(EXIT_FAILURE);
	if (un || u1 || u2 || vn || v1 || v2) {}
}

void glMaterialf(GLenum face, GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glMaterialf\n");
	exit(EXIT_FAILURE);
	if (face || pname || param) {}
}

void glMaterialfv(GLenum face, GLenum pname, const GLfloat *params) {
	unsigned args[] = {
		GLMATERIALFV,
		face,
		pname,
		(unsigned) params
	};
	normal_call(args);
}

void glMateriali(GLenum face, GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glMateriali\n");
	exit(EXIT_FAILURE);
	if (face || pname || param) {}
}

void glMaterialiv(GLenum face, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glMaterialiv\n");
	exit(EXIT_FAILURE);
	if (face || pname || params) {}
}

void glMatrixMode(GLenum mode) {
	unsigned args[] = {
		GLMATRIXMODE,
		mode
	};
	normal_call(args);
}

void glMinmax(GLenum target, GLenum internalformat, GLboolean sink) {
	fprintf(stderr, "Unimplemented stub glMinmax\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || sink) {}
}

void glMultMatrixd(const GLdouble *m) {
	fprintf(stderr, "Unimplemented stub glMultMatrixd\n");
	exit(EXIT_FAILURE);
	if (m) {}
}

void glMultMatrixf(const GLfloat *m) {
	fprintf(stderr, "Unimplemented stub glMultMatrixf\n");
	exit(EXIT_FAILURE);
	if (m) {}
}

void glNewList(GLuint list, GLenum mode) {
	unsigned args[] = {
		GLNEWLIST,
		list,
		mode
	};
	normal_call(args);
}

void glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz) {
	fprintf(stderr, "Unimplemented stub glNormal3b\n");
	exit(EXIT_FAILURE);
	if (nx || ny || nz) {}
}

void glNormal3bv(const GLbyte *v) {
	fprintf(stderr, "Unimplemented stub glNormal3bv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz) {
	fprintf(stderr, "Unimplemented stub glNormal3d\n");
	exit(EXIT_FAILURE);
	if (nx || ny || nz) {}
}

void glNormal3dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glNormal3dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) {
	unsigned args[] = {
		GLNORMAL3F,
		to_unsigned(nx),
		to_unsigned(ny),
		to_unsigned(nz)
	};
	normal_call(args);
}

void glNormal3fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glNormal3fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glNormal3i(GLint nx, GLint ny, GLint nz) {
	fprintf(stderr, "Unimplemented stub glNormal3i\n");
	exit(EXIT_FAILURE);
	if (nx || ny || nz) {}
}

void glNormal3iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glNormal3iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glNormal3s(GLshort nx, GLshort ny, GLshort nz) {
	fprintf(stderr, "Unimplemented stub glNormal3s\n");
	exit(EXIT_FAILURE);
	if (nx || ny || nz) {}
}

void glNormal3sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glNormal3sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glNormalPointer(GLenum type, GLsizei stride, const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glNormalPointer\n");
	exit(EXIT_FAILURE);
	if (type || stride || ptr) {}
}

void glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
	GLdouble near_val, GLdouble far_val) {
	int_s64 is1 = { .d = left };
	int_s64 is2 = { .d = right };
	int_s64 is3 = { .d = bottom };
	int_s64 is4 = { .d = top };
	int_s64 is5 = { .d = near_val };
	int_s64 is6 = { .d = far_val };
	unsigned args[] = {
		GLORTHO,
		is1.i[0], is1.i[1],
		is2.i[0], is2.i[1],
		is3.i[0], is3.i[1],
		is4.i[0], is4.i[1],
		is5.i[0], is5.i[1],
		is6.i[0], is6.i[1]
	};
	normal_call(args);
}

void glPassThrough(GLfloat token) {
	fprintf(stderr, "Unimplemented stub glPassThrough\n");
	exit(EXIT_FAILURE);
	if (token) {}
}

void glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values) {
	fprintf(stderr, "Unimplemented stub glPixelMapfv\n");
	exit(EXIT_FAILURE);
	if (map || mapsize || values) {}
}

void glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values) {
	fprintf(stderr, "Unimplemented stub glPixelMapuiv\n");
	exit(EXIT_FAILURE);
	if (map || mapsize || values) {}
}

void glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values) {
	fprintf(stderr, "Unimplemented stub glPixelMapusv\n");
	exit(EXIT_FAILURE);
	if (map || mapsize || values) {}
}

void glPixelStoref(GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glPixelStoref\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glPixelStorei(GLenum pname, GLint param) {
	unsigned args[] = {
		GLPIXELSTOREI,
		pname,
		param
	};
	normal_call(args);
}

void glPixelTransferf(GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glPixelTransferf\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glPixelTransferi(GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glPixelTransferi\n");
	exit(EXIT_FAILURE);
	if (pname || param) {}
}

void glPixelZoom(GLfloat xfactor, GLfloat yfactor) {
	fprintf(stderr, "Unimplemented stub glPixelZoom\n");
	exit(EXIT_FAILURE);
	if (xfactor || yfactor) {}
}

void glPointSize(GLfloat size) {
	fprintf(stderr, "Unimplemented stub glPointSize\n");
	exit(EXIT_FAILURE);
	if (size) {}
}

void glPolygonMode(GLenum face, GLenum mode) {
	fprintf(stderr, "Unimplemented stub glPolygonMode\n");
	exit(EXIT_FAILURE);
	if (face || mode) {}
}

void glPolygonOffset(GLfloat factor, GLfloat units) {
	fprintf(stderr, "Unimplemented stub glPolygonOffset\n");
	exit(EXIT_FAILURE);
	if (factor || units) {}
}

void glPolygonStipple(const GLubyte *mask) {
	fprintf(stderr, "Unimplemented stub glPolygonStipple\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glPopAttrib(void) {
	fprintf(stderr, "Unimplemented stub glPopAttrib\n");
	exit(EXIT_FAILURE);
}

void glPopClientAttrib(void) {
	fprintf(stderr, "Unimplemented stub glPopClientAttrib\n");
	exit(EXIT_FAILURE);
}

void glPopMatrix(void) {
	unsigned args[] = {
		GLPOPMATRIX
	};
	normal_call(args);
}

void glPopName(void) {
	fprintf(stderr, "Unimplemented stub glPopName\n");
	exit(EXIT_FAILURE);
}

void glPrioritizeTextures(GLsizei n, const GLuint *textures,
	const GLclampf *priorities) {
	fprintf(stderr, "Unimplemented stub glPrioritizeTextures\n");
	exit(EXIT_FAILURE);
	if (n || textures || priorities) {}
}

void glPushAttrib(GLbitfield mask) {
	fprintf(stderr, "Unimplemented stub glPushAttrib\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glPushClientAttrib(GLbitfield mask) {
	fprintf(stderr, "Unimplemented stub glPushClientAttrib\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glPushMatrix(void) {
	unsigned args[] = {
		GLPUSHMATRIX
	};
	normal_call(args);
}

void glPushName(GLuint name) {
	fprintf(stderr, "Unimplemented stub glPushName\n");
	exit(EXIT_FAILURE);
	if (name) {}
}

void glRasterPos2d(GLdouble x, GLdouble y) {
	fprintf(stderr, "Unimplemented stub glRasterPos2d\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glRasterPos2dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos2dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos2f(GLfloat x, GLfloat y) {
	fprintf(stderr, "Unimplemented stub glRasterPos2f\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glRasterPos2fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos2fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos2i(GLint x, GLint y) {
	fprintf(stderr, "Unimplemented stub glRasterPos2i\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glRasterPos2iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos2iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos2s(GLshort x, GLshort y) {
	fprintf(stderr, "Unimplemented stub glRasterPos2s\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glRasterPos2sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos2sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos3d(GLdouble x, GLdouble y, GLdouble z) {
	fprintf(stderr, "Unimplemented stub glRasterPos3d\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glRasterPos3dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos3dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos3f(GLfloat x, GLfloat y, GLfloat z) {
	fprintf(stderr, "Unimplemented stub glRasterPos3f\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glRasterPos3fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos3fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos3i(GLint x, GLint y, GLint z) {
	fprintf(stderr, "Unimplemented stub glRasterPos3i\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glRasterPos3iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos3iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos3s(GLshort x, GLshort y, GLshort z) {
	fprintf(stderr, "Unimplemented stub glRasterPos3s\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glRasterPos3sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos3sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
	fprintf(stderr, "Unimplemented stub glRasterPos4d\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glRasterPos4dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos4dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
	fprintf(stderr, "Unimplemented stub glRasterPos4f\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glRasterPos4fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos4fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos4i(GLint x, GLint y, GLint z, GLint w) {
	fprintf(stderr, "Unimplemented stub glRasterPos4i\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glRasterPos4iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos4iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w) {
	fprintf(stderr, "Unimplemented stub glRasterPos4s\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glRasterPos4sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glRasterPos4sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glReadBuffer(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glReadBuffer\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height,
	GLenum format, GLenum type, GLvoid *pixels) {
	fprintf(stderr, "Unimplemented stub glReadPixels\n");
	exit(EXIT_FAILURE);
	if (x || y || width || height || format || type || pixels) {}
}

void glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2) {
	fprintf(stderr, "Unimplemented stub glRectd\n");
	exit(EXIT_FAILURE);
	if (x1 || y1 || x2 || y2) {}
}

void glRectdv(const GLdouble *v1, const GLdouble *v2) {
	fprintf(stderr, "Unimplemented stub glRectdv\n");
	exit(EXIT_FAILURE);
	if (v1 || v2) {}
}

void glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2) {
	fprintf(stderr, "Unimplemented stub glRectf\n");
	exit(EXIT_FAILURE);
	if (x1 || y1 || x2 || y2) {}
}

void glRectfv(const GLfloat *v1, const GLfloat *v2) {
	fprintf(stderr, "Unimplemented stub glRectfv\n");
	exit(EXIT_FAILURE);
	if (v1 || v2) {}
}

void glRecti(GLint x1, GLint y1, GLint x2, GLint y2) {
	fprintf(stderr, "Unimplemented stub glRecti\n");
	exit(EXIT_FAILURE);
	if (x1 || y1 || x2 || y2) {}
}

void glRectiv(const GLint *v1, const GLint *v2) {
	fprintf(stderr, "Unimplemented stub glRectiv\n");
	exit(EXIT_FAILURE);
	if (v1 || v2) {}
}

void glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2) {
	fprintf(stderr, "Unimplemented stub glRects\n");
	exit(EXIT_FAILURE);
	if (x1 || y1 || x2 || y2) {}
}

void glRectsv(const GLshort *v1, const GLshort *v2) {
	fprintf(stderr, "Unimplemented stub glRectsv\n");
	exit(EXIT_FAILURE);
	if (v1 || v2) {}
}

GLint glRenderMode(GLenum mode) {
	fprintf(stderr, "Unimplemented stub glRenderMode\n");
	exit(EXIT_FAILURE);
	if (mode) {}
}

void glResetHistogram(GLenum target) {
	fprintf(stderr, "Unimplemented stub glResetHistogram\n");
	exit(EXIT_FAILURE);
	if (target) {}
}

void glResetMinmax(GLenum target) {
	fprintf(stderr, "Unimplemented stub glResetMinmax\n");
	exit(EXIT_FAILURE);
	if (target) {}
}

void glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) {
	fprintf(stderr, "Unimplemented stub glRotated\n");
	exit(EXIT_FAILURE);
	if (angle || x || y || z) {}
}

void glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
	unsigned args[] = {
		GLROTATEF,
		to_unsigned(angle),
		to_unsigned(x),
		to_unsigned(y),
		to_unsigned(z)
	};
	normal_call(args);
}

void glScaled(GLdouble x, GLdouble y, GLdouble z) {
	fprintf(stderr, "Unimplemented stub glScaled\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glScalef(GLfloat x, GLfloat y, GLfloat z) {
	fprintf(stderr, "Unimplemented stub glScalef\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glScissor(GLint x, GLint y, GLsizei width, GLsizei height) {
	fprintf(stderr, "Unimplemented stub glScissor\n");
	exit(EXIT_FAILURE);
	if (x || y || width || height) {}
}

void glSelectBuffer(GLsizei size, GLuint *buffer) {
	fprintf(stderr, "Unimplemented stub glSelectBuffer\n");
	exit(EXIT_FAILURE);
	if (size || buffer) {}
}

void glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width,
	GLsizei height, GLenum format, GLenum type, const GLvoid *row,
	const GLvoid *column) {
	fprintf(stderr, "Unimplemented stub glSeparableFilter2D\n");
	exit(EXIT_FAILURE);
	if (target || internalformat || width || height || format || type || row
		|| column) {}
}

void glShadeModel(GLenum mode) {
	unsigned args[] = {
		GLSHADEMODEL,
		mode
	};
	normal_call(args);
}

void glStencilFunc(GLenum func, GLint ref, GLuint mask) {
	fprintf(stderr, "Unimplemented stub glStencilFunc\n");
	exit(EXIT_FAILURE);
	if (func || ref || mask) {}
}

void glStencilMask(GLuint mask) {
	fprintf(stderr, "Unimplemented stub glStencilMask\n");
	exit(EXIT_FAILURE);
	if (mask) {}
}

void glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) {
	fprintf(stderr, "Unimplemented stub glStencilOp\n");
	exit(EXIT_FAILURE);
	if (fail || zfail || zpass) {}
}

void glTexCoord1d(GLdouble s) {
	fprintf(stderr, "Unimplemented stub glTexCoord1d\n");
	exit(EXIT_FAILURE);
	if (s) {}
}

void glTexCoord1dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord1dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord1f(GLfloat s) {
	unsigned args[] = {
		GLTEXCOORD1F,
		to_unsigned(s)
	};
	normal_call(args);
}

void glTexCoord1fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord1fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord1i(GLint s) {
	fprintf(stderr, "Unimplemented stub glTexCoord1i\n");
	exit(EXIT_FAILURE);
	if (s) {}
}

void glTexCoord1iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord1iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord1s(GLshort s) {
	fprintf(stderr, "Unimplemented stub glTexCoord1s\n");
	exit(EXIT_FAILURE);
	if (s) {}
}

void glTexCoord1sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord1sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord2d(GLdouble s, GLdouble t) {
	fprintf(stderr, "Unimplemented stub glTexCoord2d\n");
	exit(EXIT_FAILURE);
	if (s || t) {}
}

void glTexCoord2dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord2dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord2f(GLfloat s, GLfloat t) {
	unsigned args[] = {
		GLTEXCOORD2F,
		to_unsigned(s),
		to_unsigned(t)
	};
	normal_call(args);
}

void glTexCoord2fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord2fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord2i(GLint s, GLint t) {
	fprintf(stderr, "Unimplemented stub glTexCoord2i\n");
	exit(EXIT_FAILURE);
	if (s || t) {}
}

void glTexCoord2iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord2iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord2s(GLshort s, GLshort t) {
	fprintf(stderr, "Unimplemented stub glTexCoord2s\n");
	exit(EXIT_FAILURE);
	if (s || t) {}
}

void glTexCoord2sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord2sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord3d(GLdouble s, GLdouble t, GLdouble r) {
	fprintf(stderr, "Unimplemented stub glTexCoord3d\n");
	exit(EXIT_FAILURE);
	if (s || t || r) {}
}

void glTexCoord3dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord3dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord3f(GLfloat s, GLfloat t, GLfloat r) {
	fprintf(stderr, "Unimplemented stub glTexCoord3f\n");
	exit(EXIT_FAILURE);
	if (s || t || r) {}
}

void glTexCoord3fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord3fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord3i(GLint s, GLint t, GLint r) {
	fprintf(stderr, "Unimplemented stub glTexCoord3i\n");
	exit(EXIT_FAILURE);
	if (s || t || r) {}
}

void glTexCoord3iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord3iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord3s(GLshort s, GLshort t, GLshort r) {
	fprintf(stderr, "Unimplemented stub glTexCoord3s\n");
	exit(EXIT_FAILURE);
	if (s || t || r) {}
}

void glTexCoord3sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord3sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q) {
	fprintf(stderr, "Unimplemented stub glTexCoord4d\n");
	exit(EXIT_FAILURE);
	if (s || t || r || q) {}
}

void glTexCoord4dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord4dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
	fprintf(stderr, "Unimplemented stub glTexCoord4f\n");
	exit(EXIT_FAILURE);
	if (s || t || r || q) {}
}

void glTexCoord4fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord4fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord4i(GLint s, GLint t, GLint r, GLint q) {
	fprintf(stderr, "Unimplemented stub glTexCoord4i\n");
	exit(EXIT_FAILURE);
	if (s || t || r || q) {}
}

void glTexCoord4iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord4iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q) {
	fprintf(stderr, "Unimplemented stub glTexCoord4s\n");
	exit(EXIT_FAILURE);
	if (s || t || r || q) {}
}

void glTexCoord4sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glTexCoord4sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glTexCoordPointer(GLint size, GLenum type, GLsizei stride,
	const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glTexCoordPointer\n");
	exit(EXIT_FAILURE);
	if (size || type || stride || ptr) {}
}

void glTexEnvf(GLenum target, GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glTexEnvf\n");
	exit(EXIT_FAILURE);
	if (target || pname || param) {}
}

void glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glTexEnvfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glTexEnvi(GLenum target, GLenum pname, GLint param) {
	unsigned args[] = {
		GLTEXENVI,
		target,
		pname,
		param
	};
	normal_call(args);
}

void glTexEnviv(GLenum target, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glTexEnviv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glTexGend(GLenum coord, GLenum pname, GLdouble param) {
	fprintf(stderr, "Unimplemented stub glTexGend\n");
	exit(EXIT_FAILURE);
	if (coord || pname || param) {}
}

void glTexGendv(GLenum coord, GLenum pname, const GLdouble *params) {
	fprintf(stderr, "Unimplemented stub glTexGendv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glTexGenf(GLenum coord, GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glTexGenf\n");
	exit(EXIT_FAILURE);
	if (coord || pname || param) {}
}

void glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glTexGenfv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glTexGeni(GLenum coord, GLenum pname, GLint param) {
	fprintf(stderr, "Unimplemented stub glTexGeni\n");
	exit(EXIT_FAILURE);
	if (coord || pname || param) {}
}

void glTexGeniv(GLenum coord, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glTexGeniv\n");
	exit(EXIT_FAILURE);
	if (coord || pname || params) {}
}

void glTexImage1D(GLenum target, GLint level, GLint internalFormat,
	GLsizei width, GLint border, GLenum format, GLenum type,
	const GLvoid *pixels) {
	unsigned args[] = {
		GLTEXIMAGE1D,
		target,
		level,
		internalFormat,
		width,
		border,
		format,
		type,
		(unsigned) pixels
	};
	normal_call(args);
}

void glTexImage2D(GLenum target, GLint level, GLint internalFormat,
	GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type,
	const GLvoid *pixels) {
	unsigned args[] = {
		GLTEXIMAGE2D,
		target,
		level,
		internalFormat,
		width,
		height,
		border,
		format,
		type,
		(unsigned) pixels
	};
	normal_call(args);
}

void glTexImage3D(GLenum target, GLint level, GLint internalFormat,
	GLsizei width, GLsizei height, GLsizei depth, GLint border,
	GLenum format, GLenum type, const GLvoid *pixels) {
	fprintf(stderr, "Unimplemented stub glTexImage3D\n");
	exit(EXIT_FAILURE);
	if (target || level || internalFormat || width || height || depth
		|| border || format || type || pixels) {}
}

void glTexParameterf(GLenum target, GLenum pname, GLfloat param) {
	fprintf(stderr, "Unimplemented stub glTexParameterf\n");
	exit(EXIT_FAILURE);
	if (target || pname || param) {}
}

void glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params) {
	fprintf(stderr, "Unimplemented stub glTexParameterfv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glTexParameteri(GLenum target, GLenum pname, GLint param) {
	unsigned args[] = {
		GLTEXPARAMETERI,
		target,
		pname,
		param
	};
	normal_call(args);
}

void glTexParameteriv(GLenum target, GLenum pname, const GLint *params) {
	fprintf(stderr, "Unimplemented stub glTexParameteriv\n");
	exit(EXIT_FAILURE);
	if (target || pname || params) {}
}

void glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width,
	GLenum format, GLenum type, const GLvoid *pixels) {
	fprintf(stderr, "Unimplemented stub glTexSubImage1D\n");
	exit(EXIT_FAILURE);
	if (target || level || xoffset || width || format || type || pixels) {}
}

void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset,
	GLsizei width, GLsizei height, GLenum format, GLenum type,
	const GLvoid *pixels) {
	unsigned args[] = {
		GLTEXSUBIMAGE2D,
		target,
		level,
		xoffset,
		yoffset,
		width,
		height,
		format,
		type,
		(unsigned) pixels
	};
	normal_call(args);
}

void glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset,
	GLint zoffset, GLsizei width, GLsizei height, GLsizei depth,
	GLenum format, GLenum type, const GLvoid *pixels) {
	fprintf(stderr, "Unimplemented stub glTexSubImage3D\n");
	exit(EXIT_FAILURE);
	if (target || level || xoffset || yoffset || zoffset || width || height
		|| depth || format || type || pixels) {}
}

void glTranslated(GLdouble x, GLdouble y, GLdouble z) {
	fprintf(stderr, "Unimplemented stub glTranslated\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glTranslatef(GLfloat x, GLfloat y, GLfloat z) {
	unsigned args[] = {
		GLTRANSLATEF,
		to_unsigned(x),
		to_unsigned(y),
		to_unsigned(z)
	};
	normal_call(args);
}

void glVertex2d(GLdouble x, GLdouble y) {
	fprintf(stderr, "Unimplemented stub glVertex2d\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glVertex2dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glVertex2dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex2f(GLfloat x, GLfloat y) {
	unsigned args[] = {
		GLVERTEX2F,
		to_unsigned(x),
		to_unsigned(y)
	};
	normal_call(args);
}

void glVertex2fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glVertex2fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex2i(GLint x, GLint y) {
	fprintf(stderr, "Unimplemented stub glVertex2i\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glVertex2iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glVertex2iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex2s(GLshort x, GLshort y) {
	fprintf(stderr, "Unimplemented stub glVertex2s\n");
	exit(EXIT_FAILURE);
	if (x || y) {}
}

void glVertex2sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glVertex2sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex3d(GLdouble x, GLdouble y, GLdouble z) {
	fprintf(stderr, "Unimplemented stub glVertex3d\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glVertex3dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glVertex3dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex3f(GLfloat x, GLfloat y, GLfloat z) {
	unsigned args[] = {
		GLVERTEX3F,
		to_unsigned(x),
		to_unsigned(y),
		to_unsigned(z)
	};
	normal_call(args);
}

void glVertex3fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glVertex3fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex3i(GLint x, GLint y, GLint z) {
	fprintf(stderr, "Unimplemented stub glVertex3i\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glVertex3iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glVertex3iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex3s(GLshort x, GLshort y, GLshort z) {
	fprintf(stderr, "Unimplemented stub glVertex3s\n");
	exit(EXIT_FAILURE);
	if (x || y || z) {}
}

void glVertex3sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glVertex3sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {
	fprintf(stderr, "Unimplemented stub glVertex4d\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glVertex4dv(const GLdouble *v) {
	fprintf(stderr, "Unimplemented stub glVertex4dv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
	fprintf(stderr, "Unimplemented stub glVertex4f\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glVertex4fv(const GLfloat *v) {
	fprintf(stderr, "Unimplemented stub glVertex4fv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex4i(GLint x, GLint y, GLint z, GLint w) {
	fprintf(stderr, "Unimplemented stub glVertex4i\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glVertex4iv(const GLint *v) {
	fprintf(stderr, "Unimplemented stub glVertex4iv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w) {
	fprintf(stderr, "Unimplemented stub glVertex4s\n");
	exit(EXIT_FAILURE);
	if (x || y || z || w) {}
}

void glVertex4sv(const GLshort *v) {
	fprintf(stderr, "Unimplemented stub glVertex4sv\n");
	exit(EXIT_FAILURE);
	if (v) {}
}

void glVertexPointer(GLint size, GLenum type, GLsizei stride,
	const GLvoid *ptr) {
	fprintf(stderr, "Unimplemented stub glVertexPointer\n");
	exit(EXIT_FAILURE);
	if (size || type || stride || ptr) {}
}

void glViewport(GLint x, GLint y, GLsizei width, GLsizei height) {
	unsigned args[] = {
		GLVIEWPORT,
		x,
		y,
		width,
		height
	};
	normal_call(args);
}

void *glXAllocateMemoryNV(GLsizei size, GLfloat readfreq, GLfloat writefreq,
	GLfloat priority) {
	fprintf(stderr, "Unimplemented stub glXAllocateMemoryNV\n");
	exit(EXIT_FAILURE);
	if (size || readfreq || writefreq || priority) {}
}

GLXFBConfig *glXChooseFBConfig(Display *dpy, int screen, const int *attribList,
	int *nitems) {
	fprintf(stderr, "Unimplemented stub glXChooseFBConfig\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || attribList || nitems) {}
}

XVisualInfo *glXChooseVisual(Display *dpy, int screen, int *attribList) {
	XVisualInfo *result;
	unsigned args[] = {
		GLXCHOOSEVISUAL,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		(unsigned) attribList
	};
	normal_call(args);
	return result;
}

void glXCopyContext(Display *dpy, GLXContext src, GLXContext dst,
	unsigned long mask) {
	fprintf(stderr, "Unimplemented stub glXCopyContext\n");
	exit(EXIT_FAILURE);
	if (dpy || src || dst || mask) {}
}

static void __glXCopySubBufferMESA(Display *dpy, GLXDrawable drawable, int x,
	int y, int width, int height) {
	fprintf(stderr, "Unimplemented stub __glXCopySubBufferMESA\n");
	exit(EXIT_FAILURE);
	if (dpy || drawable || x || y || width || height) {}
}

GLXContext glXCreateContext(Display *dpy, XVisualInfo *vis,
	GLXContext shareList, Bool direct) {
	GLXContext result;
	unsigned args[] = {
		GLXCREATECONTEXT,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) vis,
		(unsigned) shareList,
		direct
	};
	normal_call(args);
	return result;
}

GLXPixmap glXCreateGLXPixmap(Display *dpy, XVisualInfo *visual, Pixmap pixmap) {
	fprintf(stderr, "Unimplemented stub glXCreateGLXPixmap\n");
	exit(EXIT_FAILURE);
	if (dpy || visual || pixmap) {}
}

GLXContext glXCreateNewContext(Display *dpy, GLXFBConfig config, int renderType,
	GLXContext shareList, Bool direct) {
	fprintf(stderr, "Unimplemented stub glXCreateNewContext\n");
	exit(EXIT_FAILURE);
	if (dpy || config || renderType || shareList || direct) {}
}

GLXPbuffer glXCreatePbuffer(Display *dpy, GLXFBConfig config,
	const int *attribList) {
	fprintf(stderr, "Unimplemented stub glXCreatePbuffer\n");
	exit(EXIT_FAILURE);
	if (dpy || config || attribList) {}
}

void glXDestroyContext(Display *dpy, GLXContext ctx) {
	unsigned args[] = {
		GLXDESTROYCONTEXT,
		(unsigned) dpy,
		(unsigned) ctx
	};
	normal_call(args);
}

void glXDestroyGLXPixmap(Display *dpy, GLXPixmap pixmap) {
	fprintf(stderr, "Unimplemented stub glXDestroyGLXPixmap\n");
	exit(EXIT_FAILURE);
	if (dpy || pixmap) {}
}

void glXDestroyPbuffer(Display *dpy, GLXPbuffer pbuf) {
	fprintf(stderr, "Unimplemented stub glXDestroyPbuffer\n");
	exit(EXIT_FAILURE);
	if (dpy || pbuf) {}
}

void glXFreeMemoryNV(GLvoid *pointer) {
	fprintf(stderr, "Unimplemented stub glXFreeMemoryNV\n");
	exit(EXIT_FAILURE);
	if (pointer) {}
}

const char *glXGetClientString(Display *dpy, int name) {
	const char *result;
	unsigned args[] = {
		GLXGETCLIENTSTRING,
		(unsigned) &result,
		(unsigned) dpy,
		name
	};
	normal_call(args);
	return result;
}

int glXGetConfig(Display *dpy, XVisualInfo *visual, int attrib, int *value) {
	int result;
	unsigned args[] = {
		GLXGETCONFIG,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) visual,
		attrib,
		(unsigned) value
	};
	normal_call(args);
	return result;
}

GLXContext glXGetCurrentContext(void) {
	fprintf(stderr, "Unimplemented stub glXGetCurrentContext\n");
	exit(EXIT_FAILURE);
}

GLXDrawable glXGetCurrentDrawable(void) {
	fprintf(stderr, "Unimplemented stub glXGetCurrentDrawable\n");
	exit(EXIT_FAILURE);
}

GLXDrawable glXGetCurrentReadDrawable(void) {
	fprintf(stderr, "Unimplemented stub glXGetCurrentReadDrawable\n");
	exit(EXIT_FAILURE);
}

int glXGetFBConfigAttrib(Display *dpy, GLXFBConfig config, int attribute,
	int *value) {
	fprintf(stderr, "Unimplemented stub glXGetFBConfigAttrib\n");
	exit(EXIT_FAILURE);
	if (dpy || config || attribute || value) {}
}

GLXFBConfig *glXGetFBConfigs(Display *dpy, int screen, int *nelements) {
	fprintf(stderr, "Unimplemented stub glXGetFBConfigs\n");
	exit(EXIT_FAILURE);
	if (dpy || screen || nelements) {}
}

__GLXextFuncPtr glXGetProcAddressARB(const GLubyte *procName) {
	proc_table_pair request;
	request.name = (const char *) procName;
	proc_table_pair *proc = bsearch(&request, proc_table,
		sizeof(proc_table) / sizeof(proc_table_pair),
		sizeof(proc_table_pair), proc_table_compar);
	if (!proc) {
		fprintf(stderr, "Unimplemented procName %s\n", procName);
		return NULL;
	}
	return proc->ptr;
}

static int __glXGetSwapIntervalMESA(void) {
	int result;
	unsigned args[] = {
		__GLXGETSWAPINTERVALMESA,
		(unsigned) &result
	};
	normal_call(args);
	return result;
}

XVisualInfo *glXGetVisualFromFBConfig(Display *dpy, GLXFBConfig config) {
	fprintf(stderr, "Unimplemented stub glXGetVisualFromFBConfig\n");
	exit(EXIT_FAILURE);
	if (dpy || config) {}
}

Bool glXIsDirect(Display *dpy, GLXContext ctx) {
	Bool result;
	unsigned args[] = {
		GLXISDIRECT,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) ctx
	};
	normal_call(args);
	return result;
}

Bool glXMakeContextCurrent(Display *dpy, GLXDrawable draw, GLXDrawable read,
	GLXContext ctx) {
	fprintf(stderr, "Unimplemented stub glXMakeContextCurrent\n");
	exit(EXIT_FAILURE);
	if (dpy || draw || read || ctx) {}
}

Bool glXMakeCurrent(Display *dpy, GLXDrawable drawable, GLXContext ctx) {
	Bool result;
	unsigned args[] = {
		GLXMAKECURRENT,
		(unsigned) &result,
		(unsigned) dpy,
		drawable,
		(unsigned) ctx
	};
	normal_call(args);
	return result;
}

Bool glXQueryExtension(Display *dpy, int *errorb, int *event) {
	Bool result;
	unsigned args[] = {
		GLXQUERYEXTENSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) errorb,
		(unsigned) event
	};
	normal_call(args);
	return result;
}

const char *glXQueryExtensionsString(Display *dpy, int screen) {
	const char *result;
	unsigned args[] = {
		GLXQUERYEXTENSIONSSTRING,
		(unsigned) &result,
		(unsigned) dpy,
		screen
	};
	normal_call(args);
	return result;
}

const char *glXQueryServerString(Display *dpy, int screen, int name) {
	const char *result;
	unsigned args[] = {
		GLXQUERYSERVERSTRING,
		(unsigned) &result,
		(unsigned) dpy,
		screen,
		name
	};
	normal_call(args);
	return result;
}

Bool glXQueryVersion(Display *dpy, int *maj, int *min) {
	Bool result;
	unsigned args[] = {
		GLXQUERYVERSION,
		(unsigned) &result,
		(unsigned) dpy,
		(unsigned) maj,
		(unsigned) min
	};
	normal_call(args);
	return result;
}

void glXSwapBuffers(Display *dpy, GLXDrawable drawable) {
	unsigned args[] = {
		GLXSWAPBUFFERS,
		(unsigned) dpy,
		drawable
	};
	normal_call(args);
}

void glXUseXFont(Font font, int first, int count, int list) {
	fprintf(stderr, "Unimplemented stub glXUseXFont\n");
	exit(EXIT_FAILURE);
	if (font || first || count || list) {}
}

static int proc_table_compar(const void *key, const void *member) {
        const proc_table_pair *request = key;
        const proc_table_pair *proc = member;
        return strcmp(request->name, proc->name);
}
