// ELF note identifying the required operating-system ABI

#include <stdint.h>

#define VENDOR_NAME "GNU"

enum {
	LINUX = 0
};

__attribute__((section(".note.ABI-tag"))) const struct {
	uint32_t name_length;
	uint32_t data_length;
	uint32_t note_type;
	char vendor_name[sizeof VENDOR_NAME];
	uint32_t note_data[4];
} note = { sizeof VENDOR_NAME, sizeof note.note_data, 1, VENDOR_NAME,
	{ LINUX, 2, 6, 18 } };
