#include <err.h>
#include <time.h>
#include <emu-stub/handler.h>

#include "librt_const.h"

int handle_syscall(unsigned args[],
	__attribute__((unused)) struct emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case CLOCK_GETTIME:
	{
		clockid_t clk_id = tswap32(args[2]);
		struct timespec *target_tp = (void *) tswap32(args[3]);
		struct timespec tp;
		assign_result32(args[1], clock_gettime(clk_id, &tp));
		memswap32(target_tp, &tp, size32of(struct timespec));
		return 0;
	}
	default:
		warnx("Unimplemented function #%d.", function);
		return -1;
	}
}
