#ifndef _QEMU_HANDLER_LIBFREETYPE_H
#define _QEMU_HANDLER_LIBFREETYPE_H

#include <emu-stub/handler.h>

struct _DisplayProxy;

typedef struct {
	FT_Long num_faces;
	FT_Long face_index;
	FT_Long face_flags;
	FT_Long style_flags;
	FT_Long num_glyphs;
	FT_String *family_name;
	FT_String *style_name;
	FT_Int num_fixed_sizes;
	FT_Bitmap_Size *available_sizes;
	FT_Int num_charmaps;
	FT_CharMap *charmaps;
	FT_Face native;
} FT_FaceProxy;

static inline FT_Face get_face(unsigned arg) {
	FT_FaceProxy *proxy = (void *) tswap32(arg);
	return proxy->native;
}

#endif
