#include <ft2build.h>
#include <stdio.h>
#include <freetype/freetype.h>

#include "libfreetype.h"
#include "libfreetype_const.h"

int handle_syscall(unsigned args[], emu_cpu_env *env) {
	unsigned function = tswap32(args[0]);
	switch (function) {
	case FT_INIT_FREETYPE:
	{
		FT_Library *alibrary = (void *) tswap32(args[2]);
		assign_result32(args[1], FT_Init_FreeType(alibrary));
		return 0;
	}
	case FT_LOAD_GLYPH:
	{
		FT_Face face = get_face(args[2]);
printf("face %p\n", face);
		FT_UInt glyph_index = tswap32(args[3]);
		FT_Int32 load_flags = tswap32(args[4]);
		assign_result32(args[1], FT_Load_Glyph(face, glyph_index,
			load_flags));
		return 0;
	}
	default:
		fprintf(stderr, "Unimplemented function #%d.\n", function);
		return -1;
	}
}
